/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.docking.controls;

import de.javasoft.docking.controls.DockingManager;
import de.javasoft.docking.controls.DockingPortTracker;
import de.javasoft.docking.controls.DockingStateListener;
import de.javasoft.docking.controls.DockingUtility;
import de.javasoft.docking.controls.FloatingGroup;
import de.javasoft.docking.controls.IDockable;
import de.javasoft.docking.controls.IDockingPort;
import de.javasoft.docking.controls.IFloatingDockingPort;
import de.javasoft.docking.controls.ILayoutNode;
import de.javasoft.docking.controls.IPerspectiveFactory;
import de.javasoft.docking.controls.IPerspectiveListener;
import de.javasoft.docking.controls.IPerspectiveManager;
import de.javasoft.docking.controls.Perspective;
import de.javasoft.docking.controls.PerspectiveEvent;
import de.javasoft.docking.controls.PerspectiveModel;
import de.javasoft.docking.controls.RootWindow;
import de.javasoft.docking.controls.XMLPersister;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Window;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;

public class PerspectiveManager
implements IPerspectiveManager {
    private static final String DEFAULT_DIRECTORY = String.valueOf(System.getProperty("user.home")) + "/.jydocking";
    private static final String DEFAULT_FILENAME = "perspectives.xml";
    static final String DEFAULT_PERSPECTIVE_ID = "PerspectiveManager.DefaultPerspective";
    private static final PerspectiveManager INSTANCE = new PerspectiveManager();
    private static DockingStateListener dockingStateListener;
    private static String defaultPerspectiveID;
    private static String currentPerspectiveID;
    private static HashMap<String, Perspective> perspectives;
    private static boolean restoreFloatingOnLoad;
    private String persistenceKey;
    private IPerspectiveFactory perspectiveFactory;
    private InputStream inputStream;
    private OutputStream outputStream;

    static {
        perspectives = new HashMap();
        dockingStateListener = new DockingStateListener();
        PerspectiveManager.setDefaultPerspectiveID(DEFAULT_PERSPECTIVE_ID);
        PerspectiveManager.loadPerspective(defaultPerspectiveID, null, false);
        restoreFloatingOnLoad = true;
    }

    private PerspectiveManager() {
    }

    static PerspectiveManager getInstance() {
        return INSTANCE;
    }

    private static void add(Perspective perspective, boolean asDefault) {
        if (perspective == null) {
            throw new NullPointerException("perspective cannot be null");
        }
        String id = perspective.getID();
        perspectives.put(id, perspective);
        if (asDefault) {
            PerspectiveManager.setDefaultPerspectiveID(id);
        }
        PerspectiveManager.dispatchEvent(new PerspectiveEvent(perspective, 0));
    }

    static void remove(String perspectiveID) {
        if (perspectiveID == null) {
            throw new NullPointerException("perspectiveId cannot be null");
        }
        Perspective perspective = DockingManager.getPerspectiveManager().getPerspective(perspectiveID);
        if (perspective == null) {
            return;
        }
        perspectives.remove(perspectiveID);
        if (defaultPerspectiveID.equals(perspectiveID)) {
            PerspectiveManager.setDefaultPerspectiveID(DEFAULT_PERSPECTIVE_ID);
        }
        PerspectiveManager.dispatchEvent(new PerspectiveEvent(perspective, 1));
    }

    static Perspective getDefaultPerspective() {
        return DockingManager.getPerspectiveManager().getPerspective(defaultPerspectiveID);
    }

    public static String getDefaultPerspectiveID() {
        return defaultPerspectiveID;
    }

    public static void setDefaultPerspectiveID(String perspectiveID) {
        defaultPerspectiveID = perspectiveID;
    }

    public static void setCurrentPerspectiveID(String perspectiveID, boolean asDefault) {
        perspectiveID = perspectiveID == null ? defaultPerspectiveID : perspectiveID;
        PerspectiveManager.setCurrentPerspectiveID(perspectiveID);
        if (asDefault) {
            PerspectiveManager.setDefaultPerspectiveID(perspectiveID);
        }
    }

    static void setCurrentPerspectiveID(String perspectiveID) {
        currentPerspectiveID = perspectiveID;
    }

    static String getCurrentPerspectiveID() {
        return currentPerspectiveID;
    }

    private static void applyPerspectives(IDockingPort rootPort, boolean reset) {
        String current = PerspectiveManager.getCurrentPerspectiveID();
        String perspectiveID = current == null ? defaultPerspectiveID : current;
        for (Perspective perspective : DockingManager.getPerspectiveManager().getPerspectives()) {
            String id = perspective.getID();
            if (id.equals(DEFAULT_PERSPECTIVE_ID) || !reset) continue;
            perspective.getModel().setRestorationLayout(null);
        }
        PerspectiveManager.loadPerspective(perspectiveID, rootPort, reset);
    }

    public static void loadPerspective(String perspectiveID, Component window, boolean reset) {
        IDockingPort rootPort = DockingPortTracker.getRootDockingPort(window);
        Perspective currentPerspective = DockingManager.getPerspectiveManager().getCurrentPerspective();
        if (currentPerspective != null) {
            currentPerspective.updateRestorationLayoutNode(rootPort);
            currentPerspective.unload();
            if (reset) {
                currentPerspective.getModel().setRestorationLayout(null);
            }
        }
        PerspectiveManager.loadPerspective(perspectiveID, rootPort, reset);
    }

    private static void loadPerspective(String perspectiveID, IDockingPort rootPort, boolean reset) {
        Perspective perspective = DockingManager.getPerspectiveManager().getPerspective(perspectiveID);
        if (perspective == null) {
            return;
        }
        PerspectiveManager.setCurrentPerspectiveID(perspectiveID);
        if (reset) {
            perspective.reset(rootPort);
        } else {
            perspective.load(rootPort);
        }
        perspective.updateRestorationLayoutNode(rootPort);
        if (rootPort != null) {
            RootWindow.getRootWindow(rootPort.getComponent()).setPerspectiveID(perspectiveID);
        }
    }

    static DockingStateListener getDockingStateListener() {
        return dockingStateListener;
    }

    static void setDockingStateListening(boolean enabled) {
        dockingStateListener.setEnabled(enabled);
    }

    static boolean isDockingStateListening() {
        return dockingStateListener.isEnabled();
    }

    static void updateDockingStates(final IDockable[] dockables) {
        if (dockables == null) {
            return;
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                int i = 0;
                while (i < dockables.length) {
                    dockingStateListener.updateState(dockables[i]);
                    ++i;
                }
            }
        });
    }

    static void clear(IDockingPort port) {
        if (port != null) {
            boolean currState = PerspectiveManager.isDockingStateListening();
            PerspectiveManager.setDockingStateListening(false);
            port.clear();
            PerspectiveManager.setDockingStateListening(currState);
        }
    }

    static void setPerspectives(Perspective[] perspectives) {
        PerspectiveManager.perspectives.clear();
        int i = 0;
        while (i < perspectives.length) {
            PerspectiveManager.add(perspectives[i], false);
            ++i;
        }
    }

    public static boolean isRestoreFloatingOnLoad() {
        return restoreFloatingOnLoad;
    }

    public static void setRestoreFloatingOnLoad(boolean restoreFloatingOnLoad) {
        PerspectiveManager.restoreFloatingOnLoad = restoreFloatingOnLoad;
    }

    private static ILayoutNode createLayout(JSplitPane split) {
        String region = (String)split.getClientProperty("region");
        Component left = split.getLeftComponent();
        Component right = split.getRightComponent();
        float splitRatio = DockingUtility.calcSplitRatio(split);
        PerspectiveModel.SplitNode node = new PerspectiveModel.SplitNode(split.getOrientation(), 0, splitRatio, null);
        node.setDockingRegion(region);
        PerspectiveManager.link((ILayoutNode)node, left);
        PerspectiveManager.link((ILayoutNode)node, right);
        return node;
    }

    private static ILayoutNode createLayout(IDockable dockable) {
        if (dockable == null) {
            return null;
        }
        PerspectiveModel.DockableNode node = new PerspectiveModel.DockableNode();
        node.setDockableID(dockable.getID());
        return node;
    }

    private static ILayoutNode[] createLayout(JTabbedPane tabs) {
        int len = tabs.getTabCount();
        ILayoutNode[] nodes = new ILayoutNode[len];
        int i = 0;
        while (i < len) {
            Component comp = tabs.getComponentAt(i);
            IDockable dockable = DockingManager.getDockable(comp);
            nodes[i] = PerspectiveManager.createLayout(dockable);
            ++i;
        }
        return nodes;
    }

    private static void link(ILayoutNode node, Component child) {
        if (child instanceof IDockingPort) {
            ILayoutNode childNode = DockingManager.getPerspectiveManager().createLayoutModel((IDockingPort)((Object)child));
            PerspectiveManager.link(node, childNode);
        } else if (child instanceof JSplitPane) {
            ILayoutNode childNode = PerspectiveManager.createLayout((JSplitPane)child);
            PerspectiveManager.link(node, childNode);
        } else if (child instanceof JTabbedPane) {
            ILayoutNode[] children = PerspectiveManager.createLayout((JTabbedPane)child);
            int i = 0;
            while (i < children.length) {
                PerspectiveManager.link(node, children[i]);
                ++i;
            }
        } else {
            IDockable dockable = DockingManager.getDockable(child);
            ILayoutNode childNode = PerspectiveManager.createLayout(dockable);
            PerspectiveManager.link(node, childNode);
        }
    }

    private static void link(ILayoutNode parent, ILayoutNode child) {
        if (child != null) {
            parent.add(child);
        }
    }

    static void dispatchEvent(PerspectiveEvent evt) {
        block6: for (IPerspectiveListener l : evt.getPerspective().getPerspectiveListeners()) {
            PerspectiveEvent e = evt;
            switch (evt.getEventType()) {
                case 0: {
                    if (evt.getSource() instanceof Perspective) {
                        l.perspectiveAdded(e);
                        break;
                    }
                    if (!(evt.getSource() instanceof IDockable)) continue block6;
                    l.dockableAdded(e);
                    break;
                }
                case 1: {
                    if (evt.getSource() instanceof Perspective) {
                        l.perspectiveRemoved(e);
                        break;
                    }
                    if (!(evt.getSource() instanceof IDockable)) continue block6;
                    l.dockableRemoved(e);
                    break;
                }
                case 2: {
                    l.perspectiveChanged(e);
                    break;
                }
                case 3: {
                    l.perspectiveReset(e);
                    break;
                }
                default: {
                    throw new RuntimeException("Event not handled");
                }
            }
        }
    }

    @Override
    public ILayoutNode createLayoutModel(IDockingPort port) {
        PerspectiveModel.DockingPortNode node = new PerspectiveModel.DockingPortNode();
        node.setUserObject(port);
        JComponent docked = port.getDockedComponent();
        PerspectiveManager.link((ILayoutNode)node, docked);
        return node;
    }

    @Override
    public void storePerspectives(Window w, String persistenceKey) throws IOException {
        this.storePerspectives(w, persistenceKey, this.getOutputStream());
    }

    private void storePerspectives(Window w, String persistenceKey, OutputStream outputStream) throws IOException {
        this.getCurrentPerspective().updateRestorationLayoutNode(DockingPortTracker.getRootDockingPort(w, false));
        if (outputStream == null) {
            File file = this.getPerspectiveFile(persistenceKey == null ? this.getPersistenceKey() : persistenceKey);
            this.validatePerspectiveFile(file);
            outputStream = new FileOutputStream(file);
        }
        XMLPersister xp = new XMLPersister(PerspectiveManager.getInstance());
        xp.setOutputStream(outputStream);
        xp.store();
    }

    @Override
    public boolean restorePerspectives(Window w, boolean loadFromStorage) {
        return this.restorePerspectives(w, loadFromStorage, this.getInputStream());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean restorePerspectives(Window w, boolean loadFromStorage, InputStream inputStream) {
        boolean loaded;
        boolean bl = loaded = !loadFromStorage;
        if (loadFromStorage) {
            try {
                if (inputStream == null) {
                    File file = this.getPerspectiveFile(this.getPersistenceKey());
                    if (file == null || !file.exists()) {
                        return false;
                    }
                    inputStream = new FileInputStream(file);
                }
                loaded = this.loadPerspectives(inputStream);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        IDockingPort rootPort = DockingPortTracker.getRootDockingPort(w, false);
        PerspectiveManager.applyPerspectives(rootPort, this.getPersistenceKey() == null && inputStream == null);
        return loaded;
    }

    private boolean loadPerspectives(InputStream inputStream) throws IOException {
        XMLPersister xp = new XMLPersister(PerspectiveManager.getInstance());
        xp.setInputStream(inputStream);
        xp.load();
        return true;
    }

    private File getPerspectiveFile(String xmlFileName) {
        String filePath;
        if (xmlFileName == null) {
            xmlFileName = DEFAULT_FILENAME;
        }
        if ((filePath = xmlFileName).indexOf(47) == -1 && filePath.indexOf(92) == -1) {
            filePath = String.valueOf(new File(DEFAULT_DIRECTORY).getAbsolutePath()) + "/" + filePath;
        }
        return new File(filePath);
    }

    private void validatePerspectiveFile(File file) throws IOException {
        File dir = file.getParentFile();
        if (!dir.exists()) {
            dir.mkdirs();
        }
        if (!file.exists()) {
            file.createNewFile();
        }
    }

    @Override
    public void storeMainFrame(JFrame f, OutputStream outputStream) throws IOException {
        this.getCurrentPerspective().updateRestorationLayoutNode(DockingPortTracker.getRootDockingPort(f, false));
        XMLPersister xp = new XMLPersister(PerspectiveManager.getInstance());
        xp.store(f, null, outputStream);
    }

    @Override
    public void restoreMainFrame(JFrame f, InputStream inputStream) {
        Perspective perspective;
        IDockingPort rootPort = DockingPortTracker.getRootDockingPort(f, false);
        try {
            XMLPersister xp = new XMLPersister(PerspectiveManager.getInstance());
            xp.load(inputStream, false);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        String perspectiveID = PerspectiveManager.getCurrentPerspectiveID();
        if (perspectiveID == null) {
            perspectiveID = defaultPerspectiveID;
        }
        if ((perspective = DockingManager.getPerspectiveManager().getPerspective(perspectiveID)) == null) {
            return;
        }
        PerspectiveManager.setCurrentPerspectiveID(perspectiveID);
        perspective.load(rootPort);
        perspective.updateRestorationLayoutNode(rootPort);
        if (rootPort != null) {
            RootWindow.getRootWindow(rootPort.getComponent()).setPerspectiveID(perspectiveID);
        }
    }

    @Override
    public void storeFloatingGroup(Window w, OutputStream outputStream) throws IOException {
        this.getCurrentPerspective().updateRestorationLayoutNode(DockingPortTracker.getRootDockingPort(w, false));
        XMLPersister xp = new XMLPersister(PerspectiveManager.getInstance());
        xp.store(null, w, outputStream);
    }

    @Override
    public void restoreFloatingGroup(Window owner, InputStream inputStream) {
        this.restoreFloatingGroup(owner, null, inputStream);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void restoreFloatingGroup(Window owner, Window floatingWindow, InputStream inputStream) {
        void var10_13;
        Perspective perspective;
        if (owner == null) {
            owner = RootWindow.getMainWindow();
        }
        IDockingPort ownerRootPort = DockingPortTracker.getRootDockingPort(owner, false);
        String perspectiveID = PerspectiveManager.getCurrentPerspectiveID();
        if (perspectiveID == null) {
            perspectiveID = defaultPerspectiveID;
        }
        if ((perspective = DockingManager.getPerspectiveManager().getPerspective(perspectiveID)) == null) {
            return;
        }
        PerspectiveManager.setCurrentPerspectiveID(perspectiveID);
        LinkedHashMap<String, FloatingGroup> oldGroups = new LinkedHashMap<String, FloatingGroup>();
        String[] stringArray = perspective.getModel().getFloatingGroupIDs();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            oldGroups.put(id, perspective.getModel().getFloatingGroup(id));
            ++n2;
        }
        try {
            XMLPersister xp = new XMLPersister(PerspectiveManager.getInstance());
            xp.load(inputStream, true);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        LinkedHashMap<String, FloatingGroup> newGroups = new LinkedHashMap<String, FloatingGroup>();
        String[] stringArray2 = perspective.getModel().getFloatingGroupIDs();
        int n3 = stringArray2.length;
        boolean bl = false;
        while (var10_13 < n3) {
            String id = stringArray2[var10_13];
            newGroups.put(id, perspective.getModel().getFloatingGroup(id));
            ++var10_13;
        }
        String floatingGroupID = null;
        for (String string : ((HashMap)newGroups).keySet()) {
            if (((HashMap)oldGroups).keySet().contains(string)) continue;
            floatingGroupID = string;
        }
        if (floatingGroupID == null) {
            for (Map.Entry entry : ((HashMap)newGroups).entrySet()) {
                if (((FloatingGroup)entry.getValue()).getFloatingWindow() != null || ((FloatingGroup)((HashMap)oldGroups).get(entry.getKey())).getFloatingWindow() == null) continue;
                floatingGroupID = (String)entry.getKey();
            }
            if (floatingGroupID == null) {
                return;
            }
        }
        perspective.loadFloatingGroup(ownerRootPort, floatingGroupID);
        FloatingGroup floatingGroup = perspective.getModel().getFloatingGroup(floatingGroupID);
        if (floatingGroup != null) {
            IFloatingDockingPort floatingPort = perspective.getFloatingPortByID(floatingGroupID, floatingGroup);
            if (floatingGroup.getFloatingWindow() == null && floatingWindow != null) {
                floatingGroup.setFloatingWindow(floatingWindow);
            }
            perspective.updateFloatingRestorationLayoutNode(floatingPort, floatingGroup);
            if (floatingPort != null) {
                RootWindow.getRootWindow(floatingPort.getComponent()).setPerspectiveID(perspectiveID);
            }
        }
    }

    @Override
    public Perspective getCurrentPerspective() {
        return this.getPerspective(PerspectiveManager.getCurrentPerspectiveID());
    }

    @Override
    public Perspective getPerspective(String perspectiveID) {
        if (perspectiveID == null) {
            return null;
        }
        Perspective perspective = perspectives.get(perspectiveID);
        if (perspective == null && (perspective = this.createPerspective(perspectiveID)) != null) {
            PerspectiveManager.add(perspective, false);
        }
        return perspective;
    }

    boolean perspectiveIsValid(String perspectiveID) {
        return perspectives.get(perspectiveID) != null;
    }

    private Perspective createPerspective(String perspectiveId) {
        if (DEFAULT_PERSPECTIVE_ID.equals(perspectiveId)) {
            return new Perspective(DEFAULT_PERSPECTIVE_ID, DEFAULT_PERSPECTIVE_ID){
                private static final long serialVersionUID = 1781193914305449271L;

                @Override
                public void load(IDockingPort port) {
                }
            };
        }
        Perspective p = null;
        if (!(this.perspectiveFactory == null || (p = this.perspectiveFactory.getPerspective(perspectiveId)) != null && p.getID().equals(perspectiveId))) {
            throw new IllegalStateException("Perspective created by " + this.perspectiveFactory + " factory for perspective-ID: " + perspectiveId + " is null or perspective-ID does not match intended ID. You're possibly using multiple perspective factories!");
        }
        return p;
    }

    @Override
    public ArrayList<Perspective> getPerspectives() {
        return new ArrayList<Perspective>(perspectives.values());
    }

    @Override
    public void removePerspective(Perspective p) {
        PerspectiveManager.remove(p.getID());
    }

    @Override
    public String getPersistenceKey() {
        return this.persistenceKey;
    }

    @Override
    public void setPersistenceKey(String key) {
        this.persistenceKey = key;
    }

    @Override
    public void setFactory(IPerspectiveFactory factory) {
        PerspectiveManager.getInstance().perspectiveFactory = factory;
    }

    @Override
    public void setInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    @Override
    public InputStream getInputStream() {
        return this.inputStream;
    }

    @Override
    public void setOutputStream(OutputStream outputStream) {
        this.outputStream = outputStream;
    }

    @Override
    public OutputStream getOutputStream() {
        return this.outputStream;
    }
}

