/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.docking.controls;

import de.javasoft.docking.controls.DockingManager;
import de.javasoft.docking.controls.IDockable;
import de.javasoft.docking.controls.IDockingConstants;
import de.javasoft.docking.controls.IDockingPort;
import de.javasoft.docking.controls.IRegionChecker;
import de.javasoft.tabpane.JYTabbedPane;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;

class RegionChecker
implements IRegionChecker,
IDockingConstants {
    RegionChecker() {
    }

    @Override
    public String getRegion(Component c, Point point) {
        if (c == null || point == null) {
            return "UNKNOWN";
        }
        Rectangle targetArea = c.getBounds();
        if (c instanceof IDockingPort) {
            targetArea.setLocation(0, 0);
        }
        Container parent = c.getParent();
        if (DockingManager.isTabReorderByDraggingEnabled() && (parent instanceof JTabbedPane || parent != null && parent.getParent() instanceof JYTabbedPane)) {
            JTabbedPane tabPane = parent instanceof JTabbedPane ? (JTabbedPane)parent : (JTabbedPane)parent.getParent();
            Point p = SwingUtilities.convertPoint(c.getParent(), point, tabPane.getParent());
            Rectangle r = SwingUtilities.convertRectangle(c.getParent(), targetArea, tabPane.getParent());
            if (tabPane.getBounds().contains(p) && !r.contains(p)) {
                return "CENTER";
            }
        }
        if (!targetArea.contains(point)) {
            return "UNKNOWN";
        }
        if (c instanceof IDockingPort) {
            return "CENTER";
        }
        Rectangle north = this.getNorthRegion(c);
        int rightX = north.x + north.width;
        if (north.contains(point)) {
            Rectangle west = this.getWestRegion(c);
            if (west.contains(point)) {
                Polygon westPoly = new Polygon();
                westPoly.addPoint(0, 0);
                westPoly.addPoint(0, north.height);
                westPoly.addPoint(west.width, north.height);
                return westPoly.contains(point) ? "WEST" : "NORTH";
            }
            Rectangle east = this.getEastRegion(c);
            if (east.contains(point)) {
                Polygon eastPoly = new Polygon();
                eastPoly.addPoint(rightX, 0);
                eastPoly.addPoint(rightX, north.height);
                eastPoly.addPoint(east.x, north.height);
                return eastPoly.contains(point) ? "EAST" : "NORTH";
            }
            return "NORTH";
        }
        Rectangle south = this.getSouthRegion(c);
        int bottomY = south.y + south.height;
        if (south.contains(point)) {
            Rectangle west = this.getWestRegion(c);
            if (west.contains(point)) {
                Polygon westPoly = new Polygon();
                westPoly.addPoint(0, south.y);
                westPoly.addPoint(west.width, south.y);
                westPoly.addPoint(0, bottomY);
                return westPoly.contains(point) ? "WEST" : "SOUTH";
            }
            Rectangle east = this.getEastRegion(c);
            if (east.contains(point)) {
                Polygon eastPoly = new Polygon();
                eastPoly.addPoint(east.y, south.y);
                eastPoly.addPoint(rightX, south.y);
                eastPoly.addPoint(rightX, bottomY);
                return eastPoly.contains(point) ? "EAST" : "SOUTH";
            }
            return "SOUTH";
        }
        Rectangle east = this.getEastRegion(c);
        if (east.contains(point)) {
            return "EAST";
        }
        Rectangle west = this.getWestRegion(c);
        if (west.contains(point)) {
            return "WEST";
        }
        return "CENTER";
    }

    @Override
    public Rectangle getNorthRegion(Component c) {
        return this.getRegionBounds(c, "NORTH");
    }

    @Override
    public Rectangle getSouthRegion(Component c) {
        return this.getRegionBounds(c, "SOUTH");
    }

    @Override
    public Rectangle getEastRegion(Component c) {
        return this.getRegionBounds(c, "EAST");
    }

    @Override
    public Rectangle getWestRegion(Component c) {
        return this.getRegionBounds(c, "WEST");
    }

    @Override
    public Rectangle getRegionBounds(Component c, String region) {
        if (c != null && region != null) {
            float size = this.getRegionSize(c, region);
            return this.calculateRegionalBounds(c, region, size);
        }
        return null;
    }

    @Override
    public float getRegionSize(Component c, String region) {
        IDockable d = DockingManager.getDockable(c);
        return RegionChecker.getRegionPreference(d, region);
    }

    @Override
    public Rectangle getSiblingBounds(Component c, String region) {
        if (c != null && region != null) {
            float size = this.getSiblingSize(c, region);
            return this.calculateRegionalBounds(c, region, size);
        }
        return null;
    }

    @Override
    public float getSiblingSize(Component c, String region) {
        IDockable d = DockingManager.getDockable(c);
        return RegionChecker.getSiblingPreference(d, region);
    }

    protected Rectangle calculateRegionalBounds(Component c, String region, float size) {
        if (c == null || region == null) {
            return null;
        }
        Rectangle bounds = c.getBounds();
        if ("NORTH".equals(region) || "SOUTH".equals(region)) {
            int h = (int)((float)bounds.height * size);
            int y = "NORTH".equals(region) ? 0 : bounds.height - h;
            return new Rectangle(0, y, bounds.width, h);
        }
        if ("WEST".equals(region) || "EAST".equals(region)) {
            int w = (int)((float)bounds.width * size);
            int x = "WEST".equals(region) ? 0 : bounds.width - w;
            return new Rectangle(x, 0, w, bounds.height);
        }
        return null;
    }

    protected static float getDockingInset(Float value, float defaultVal, float max, float min) {
        float f;
        float f2 = f = value == null ? -1.0f : value.floatValue();
        if (f == -1.0f) {
            f = defaultVal;
        }
        return RegionChecker.checkBounds(f, max, min);
    }

    protected static float checkBounds(float val, float max, float min) {
        val = Math.min(val, max);
        return Math.max(val, min);
    }

    public static float validateRegionSize(float size) {
        return RegionChecker.checkBounds(size, 0.5f, 0.0f);
    }

    public static float validateSiblingSize(float size) {
        return RegionChecker.checkBounds(size, 1.0f, 0.0f);
    }

    public static float getRegionPreference(IDockable d, String region) {
        Float inset = d == null ? null : Float.valueOf(d.getRegionInset(region));
        return RegionChecker.getDockingInset(inset, 0.25f, 0.5f, 0.0f);
    }

    public static float getSiblingPreference(IDockable d, String region) {
        Float size = d == null ? null : Float.valueOf(d.getSiblingSize(region));
        return RegionChecker.getDockingInset(size, DockingManager.getDefaultSiblingSize(), 1.0f, 0.0f);
    }
}

