/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.util;

import java.io.File;
import java.io.IOException;
import java.util.Objects;
import java.util.function.Supplier;
import org.apache.poi.util.DefaultTempFileCreationStrategy;
import org.apache.poi.util.TempFileCreationStrategy;
import org.apache.poi.util.ThreadLocalUtil;

public final class TempFile {
    private static TempFileCreationStrategy strategy = new DefaultTempFileCreationStrategy();
    private static final ThreadLocal<TempFileCreationStrategy> threadLocalStrategy = new ThreadLocal();
    public static final String JAVA_IO_TMPDIR = "java.io.tmpdir";

    private TempFile() {
    }

    public static void setTempFileCreationStrategy(TempFileCreationStrategy strategy) {
        if (strategy == null) {
            throw new IllegalArgumentException("strategy == null");
        }
        TempFile.strategy = strategy;
    }

    public static void setThreadLocalTempFileCreationStrategy(TempFileCreationStrategy strategy) {
        if (strategy == null) {
            threadLocalStrategy.remove();
        } else {
            threadLocalStrategy.set(strategy);
        }
    }

    public static File createTempFile(String prefix, String suffix) throws IOException {
        return TempFile.getStrategy().createTempFile(prefix, suffix);
    }

    public static File createTempDirectory(String name) throws IOException {
        return TempFile.getStrategy().createTempDirectory(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <R> R withStrategy(TempFileCreationStrategy newStrategy, Supplier<? extends R> task) {
        Objects.requireNonNull(newStrategy, "newStrategy");
        Objects.requireNonNull(task, "task");
        TempFileCreationStrategy oldStrategy = threadLocalStrategy.get();
        try {
            threadLocalStrategy.set(newStrategy);
            R r = task.get();
            return r;
        }
        finally {
            TempFile.setThreadLocalTempFileCreationStrategy(oldStrategy);
        }
    }

    private static TempFileCreationStrategy getStrategy() {
        TempFileCreationStrategy s = threadLocalStrategy.get();
        if (s == null) {
            threadLocalStrategy.remove();
            return strategy;
        }
        return s;
    }

    static {
        ThreadLocalUtil.registerCleaner(threadLocalStrategy::remove);
    }
}

