/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.application.properties;

import com.macrofocus.common.properties.MutableProperty;
import com.macrofocus.common.properties.Property;
import com.macrofocus.common.properties.PropertyEvent;
import com.macrofocus.common.properties.PropertyListener;
import java.util.HashSet;
import java.util.Set;

public class WrappedMutableProperty<T>
implements MutableProperty<T> {
    private MutableProperty<T> property;
    private Set<PropertyListener<T>> listeners;
    private PropertyListener<T> listener = new PropertyListener<T>(){

        public void propertyChanged(PropertyEvent<T> event) {
        }
    };

    public WrappedMutableProperty(MutableProperty<T> property) {
        this.property = property;
    }

    public T getValue() {
        return (T)this.property.getValue();
    }

    public void addPropertyListener(PropertyListener<T> listener) {
        this.getListeners().add(listener);
        this.property.addPropertyListener(listener);
    }

    public void addWeakPropertyListener(PropertyListener<T> listener) {
        this.getListeners().add(listener);
        this.property.addWeakPropertyListener(listener);
    }

    public void removePropertyListener(PropertyListener<T> listener) {
        this.getListeners().remove(listener);
        this.property.removePropertyListener(listener);
    }

    public void bind(Property<T> source) {
        throw new UnsupportedOperationException();
    }

    public void bindBidirectional(MutableProperty<T> source) {
        throw new UnsupportedOperationException();
    }

    public void setValue(T value) {
        this.property.setValue(value);
    }

    private Set<PropertyListener<T>> getListeners() {
        if (this.listeners == null) {
            this.listeners = new HashSet<PropertyListener<T>>();
        }
        return this.listeners;
    }

    public void dispose() {
        if (this.listeners != null) {
            for (PropertyListener<T> listener : this.listeners) {
                this.property.removePropertyListener(listener);
            }
        }
        this.listeners = null;
        this.property = null;
    }
}

