/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.plaf.synthetica.styles;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.styles.StyleWrapper;
import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.synth.ColorType;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthStyle;

public class TableStyle
extends StyleWrapper {
    private static TableStyle instance = new TableStyle();

    private TableStyle() {
    }

    public static SynthStyle getStyle(SynthStyle style, JComponent c, Region region) {
        if (SyntheticaLookAndFeel.getStyleName(c) == null) {
            instance.setStyle(style);
            return instance;
        }
        TableStyle sw = new TableStyle();
        sw.setStyle(style);
        return sw;
    }

    @Override
    public Color getColor(SynthContext sc, ColorType type) {
        Color background;
        if (type == ColorType.BACKGROUND && (background = sc.getComponent().getBackground()) != null && !(background instanceof UIResource)) {
            return background;
        }
        return super.getColor(sc, type);
    }

    @Override
    public Object get(SynthContext sc, Object key) {
        if ("Table.rowHeight".equals(key)) {
            JComponent c = sc.getComponent();
            FontMetrics fm = ((Component)c).getFontMetrics(this.getFont(sc));
            int h = fm.getHeight();
            Integer rowHeight = (Integer)this.synthStyle.get(sc, key);
            if (rowHeight == null) {
                return h + 2;
            }
            return (int)SyntheticaLookAndFeel.getInstance().scaleFontSize(rowHeight.intValue());
        }
        if ("Table.dropLineColor".equals(key)) {
            return UIManager.get("Table.dropLineColor");
        }
        if ("Table.dropLineShortColor".equals(key)) {
            return UIManager.get("Table.dropLineShortColor");
        }
        return this.synthStyle.get(sc, key);
    }
}

