/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.cartoplot.georeferencing;

import com.macrofocus.cartoplot.georeferencing.GeoReferencingService;
import com.macrofocus.cartoplot.georeferencing.GeoReferencingServiceFactory;
import com.macrofocus.cartoplot.georeferencing.GeometryGeoReferencingService;
import com.macrofocus.cartoplot.georeferencing.LatLonGeoReferencingService;
import com.macrofocus.crossplatform.CPFactory;
import com.macrofocus.molap.dataframe.DataFrame;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DefaultGeoReferencingServiceFactory<Component, R>
implements GeoReferencingServiceFactory<Component, R> {
    private static Map<DataFrame, GeoReferencingServiceFactory> ourInstances = new HashMap<DataFrame, GeoReferencingServiceFactory>();
    private final List<GeoReferencingService<Component, R>> entries = new ArrayList<GeoReferencingService<Component, R>>();

    public static <R> GeoReferencingServiceFactory getInstance(CPFactory cpFactory, DataFrame<R, ?, ?> dataFrame) {
        if (!ourInstances.containsKey(dataFrame)) {
            DefaultGeoReferencingServiceFactory factory = new DefaultGeoReferencingServiceFactory(cpFactory, dataFrame);
            ourInstances.put(dataFrame, factory);
        }
        return ourInstances.get(dataFrame);
    }

    protected <C> GeoReferencingService<Component, R>[] createServices(CPFactory factory, DataFrame<R, C, ?> dataFrame) {
        return new GeoReferencingService[]{new LatLonGeoReferencingService(factory, dataFrame), new GeometryGeoReferencingService(factory, dataFrame)};
    }

    protected DefaultGeoReferencingServiceFactory(CPFactory factory, DataFrame<R, ?, ?> dataFrame) {
        this.entries.addAll(Arrays.asList(this.createServices(factory, dataFrame)));
    }

    @Override
    public GeoReferencingService getDefault() {
        for (GeoReferencingService<Component, R> entry : this.entries) {
            if (!entry.isValid()) continue;
            return entry;
        }
        return this.entries.get(0);
    }

    @Override
    public List<GeoReferencingService<Component, R>> getGeoReferencingServices() {
        return this.entries;
    }
}

