/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.cartoplot.georeferencing;

import com.macrofocus.cartoplot.georeferencing.AbstractGeoReferencingService;
import com.macrofocus.crossplatform.CPFactory;
import com.macrofocus.molap.dataframe.DataFrame;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Point;

public class GeometryGeoReferencingService<Component, R, C>
extends AbstractGeoReferencingService<Component, R> {
    private CPFactory factory;
    protected DataFrame<R, C, ?> dataFrame;
    private C geometryIndex = null;

    public GeometryGeoReferencingService(CPFactory factory, DataFrame<R, C, ?> dataFrame) {
        this.factory = factory;
        this.dataFrame = dataFrame;
        if (dataFrame != null) {
            for (Object c : dataFrame.columns()) {
                if (!factory.isAssignableFrom(Geometry.class, dataFrame.getColumnClass(c))) continue;
                this.setGeometryIndex(c);
            }
        }
    }

    @Override
    public boolean isValid() {
        return this.geometryIndex != null;
    }

    @Override
    public Component getEditor() {
        return null;
    }

    @Override
    public boolean isPointGeometry() {
        return this.factory.isAssignableFrom(Point.class, this.dataFrame.getColumnClass(this.geometryIndex));
    }

    @Override
    public Geometry getGeometry(R row) {
        if (this.geometryIndex != null) {
            return (Geometry)this.dataFrame.getValueAt(row, this.geometryIndex);
        }
        return null;
    }

    public C getGeometryIndex() {
        return this.geometryIndex;
    }

    public void setGeometryIndex(C geometryIndex) {
        if (this.geometryIndex != geometryIndex) {
            C old = this.geometryIndex;
            this.geometryIndex = geometryIndex;
            this.notififyGeoReferencingServiceChanged();
        }
    }

    public String toString() {
        return "Geometry";
    }
}

