/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.cartoplot.tile;

import com.macrofocus.cartoplot.tile.Tile;
import com.macrofocus.cartoplot.tile.TileFactory;
import com.macrofocus.cartoplot.tile.TileFactoryInfo;
import com.macrofocus.cartoplot.tile.TileListener;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractTileFactory
implements TileFactory {
    private final TileFactoryInfo info;
    private final List<TileListener> tileListeners = new ArrayList<TileListener>();

    public AbstractTileFactory(TileFactoryInfo info) {
        this.info = info;
    }

    @Override
    public int getMapWidth(int zoom) {
        return this.info.getMapWidth(zoom);
    }

    @Override
    public TileFactoryInfo getInfo() {
        return this.info;
    }

    @Override
    public void addTileListener(TileListener listener) {
        this.tileListeners.add(listener);
    }

    @Override
    public void removeTileListener(TileListener listener) {
        this.tileListeners.remove(listener);
    }

    public void fireTileLoadedEvent(Tile tile) {
        for (TileListener listener : this.tileListeners) {
            listener.tileLoaded(tile);
        }
    }
}

