/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.cartoplot.tile;

import com.macrofocus.geom.Point2D;

public class TileFactoryInfo {
    private final int minimumZoomLevel;
    private final int maximumZoomLevel;
    private int tileSize = 256;
    private final int[] mapWidthInTilesAtZoom;
    private final Point2D[] mapCenterInPixelsAtZoom;
    private final double[] longitudeDegreeWidthInPixels;
    private final double[] longitudeRadianWidthInPixels;
    protected final String baseURL;
    private final String xparam;
    private final String yparam;
    private final String zparam;
    private boolean xr2l = true;
    private boolean yt2b = true;
    private final String name;

    public TileFactoryInfo(int minimumZoomLevel, int maximumZoomLevel, int totalMapZoom, int tileSize, boolean xr2l, boolean yt2b, String baseURL, String xparam, String yparam, String zparam) {
        this("name not provided", minimumZoomLevel, maximumZoomLevel, totalMapZoom, tileSize, xr2l, yt2b, baseURL, xparam, yparam, zparam);
    }

    protected TileFactoryInfo(String name, int minimumZoomLevel, int maximumZoomLevel, int totalMapZoom, int tileSize, boolean xr2l, boolean yt2b, String baseURL, String xparam, String yparam, String zparam) {
        this.name = name;
        this.minimumZoomLevel = minimumZoomLevel;
        this.maximumZoomLevel = maximumZoomLevel;
        this.baseURL = baseURL;
        this.xparam = xparam;
        this.yparam = yparam;
        this.zparam = zparam;
        this.xr2l = xr2l;
        this.yt2b = yt2b;
        this.tileSize = tileSize;
        int tilesize = this.getTileSize();
        this.longitudeDegreeWidthInPixels = new double[totalMapZoom + 1];
        this.longitudeRadianWidthInPixels = new double[totalMapZoom + 1];
        this.mapCenterInPixelsAtZoom = new Point2D.Double[totalMapZoom + 1];
        this.mapWidthInTilesAtZoom = new int[totalMapZoom + 1];
        for (int z = 0; z <= totalMapZoom; ++z) {
            this.longitudeDegreeWidthInPixels[z] = (double)tilesize / 360.0;
            this.longitudeRadianWidthInPixels[z] = (double)tilesize / (Math.PI * 2);
            int t2 = tilesize / 2;
            this.mapCenterInPixelsAtZoom[z] = new Point2D.Double((double)t2, (double)t2);
            this.mapWidthInTilesAtZoom[z] = tilesize / this.getTileSize();
            tilesize *= 2;
        }
    }

    public int getMinimumZoomLevel() {
        return this.minimumZoomLevel;
    }

    public int getMaximumZoomLevel() {
        return this.maximumZoomLevel;
    }

    int getMapWidthInTilesAtZoom(int zoom) {
        return this.mapWidthInTilesAtZoom[zoom];
    }

    Point2D getMapCenterInPixelsAtZoom(int zoom) {
        return this.mapCenterInPixelsAtZoom[zoom];
    }

    public String getTileUrl(int x, int y, int zoom) {
        String ypart = "&" + this.yparam + "=" + y;
        if (!this.yt2b) {
            int tilemax = this.getMapWidthInTilesAtZoom(zoom);
            ypart = "&" + this.yparam + "=" + (tilemax / 2 - y - 1);
        }
        String url = this.baseURL + "&" + this.xparam + "=" + x + ypart + "&" + this.zparam + "=" + zoom;
        return url;
    }

    public int getTileSize() {
        return this.tileSize;
    }

    public int getMapWidth(int zoom) {
        return this.getMapWidthInTilesAtZoom(zoom);
    }

    public boolean isValidTile(int x, int y, int zoomLevel) {
        if (x < 0 || y < 0) {
            return false;
        }
        if (this.getMapCenterInPixelsAtZoom(zoomLevel).getX() * 2.0 <= (double)(x * this.getTileSize())) {
            return false;
        }
        if (this.getMapCenterInPixelsAtZoom(zoomLevel).getY() * 2.0 <= (double)(y * this.getTileSize())) {
            return false;
        }
        return zoomLevel >= this.getMinimumZoomLevel() && zoomLevel <= this.getMaximumZoomLevel();
    }

    public String getName() {
        return this.name;
    }
}

