/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.application.document.swing;

import javax.swing.JComponent;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;

public class CheckThreadViolationRepaintManager
extends RepaintManager {
    private boolean completeCheck = true;

    public boolean isCompleteCheck() {
        return this.completeCheck;
    }

    public void setCompleteCheck(boolean completeCheck) {
        this.completeCheck = completeCheck;
    }

    @Override
    public synchronized void addInvalidComponent(JComponent component) {
        this.checkThreadViolations(component);
        super.addInvalidComponent(component);
    }

    @Override
    public void addDirtyRegion(JComponent component, int x, int y, int w, int h) {
        this.checkThreadViolations(component);
        super.addDirtyRegion(component, x, y, w, h);
    }

    private void checkThreadViolations(JComponent c) {
        if (!SwingUtilities.isEventDispatchThread() && (this.completeCheck || c.isShowing())) {
            StackTraceElement[] stackTrace;
            Exception exception = new Exception();
            boolean repaint = false;
            boolean fromSwing = false;
            for (StackTraceElement st : stackTrace = exception.getStackTrace()) {
                if (repaint && st.getClassName().startsWith("javax.swing.")) {
                    fromSwing = true;
                }
                if (!"repaint".equals(st.getMethodName())) continue;
                repaint = true;
            }
            if (repaint && !fromSwing) {
                return;
            }
            exception.printStackTrace();
        }
    }
}

