/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.application.document.swing;

import com.install4j.api.launcher.StartupNotification;
import com.macrofocus.application.document.swing.DesktopDesktop;
import com.macrofocus.common.logging.Logging;
import java.awt.Desktop;
import java.awt.desktop.OpenFilesEvent;
import java.awt.desktop.OpenFilesHandler;
import java.io.File;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.SwingUtilities;

public class Install4JDesktop
extends DesktopDesktop {
    private Class<StartupNotification> startupNotification = StartupNotification.class;

    @Override
    public boolean isSupported(Desktop.Action action) {
        return this.startupNotification != null && action == Desktop.Action.APP_OPEN_FILE || super.isSupported(action);
    }

    @Override
    public void setOpenFileHandler(final OpenFilesHandler openFileHandler) {
        StartupNotification.Listener listener = new StartupNotification.Listener(){

            public void startupPerformed(String s) {
                if (s != null) {
                    try {
                        final ArrayList<File> list = new ArrayList<File>();
                        Matcher m = Pattern.compile("([^\"]\\S*|\".+?\")\\s*").matcher(s);
                        while (m.find()) {
                            File file = new File(m.group(1).replace("\"", ""));
                            list.add(file);
                        }
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                openFileHandler.openFiles(new OpenFilesEvent(list, null));
                            }
                        });
                    }
                    catch (Exception e) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                Logging.getInstance().process((Throwable)e);
                            }
                        });
                    }
                }
            }
        };
        StartupNotification.registerStartupListener((StartupNotification.Listener)listener);
    }
}

