/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.docking;

import com.macrofocus.docking.DockingAnchor;
import com.macrofocus.docking.DockingType;

public class DockingState {
    static final float DEFAULT_WEIGHT = 0.33f;
    private boolean active;
    private DockingAnchor anchor;
    private boolean autoHide;
    private String id;
    private DockingType internalType;
    private DockingType type;
    private boolean visible;
    private float weight;
    private int order;

    void setAnchor(DockingAnchor toolwindowanchor) {
        if (toolwindowanchor == null) {
            throw new IllegalArgumentException("anchor cannot be null");
        }
        this.anchor = toolwindowanchor;
    }

    DockingAnchor getAnchor() {
        return this.anchor;
    }

    String getId() {
        return this.id;
    }

    DockingType getInternalType() {
        return this.internalType;
    }

    DockingType getType() {
        return this.type;
    }

    float getWeight() {
        return this.weight;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int k) {
        this.order = k;
    }

    public boolean isActive() {
        return this.active;
    }

    boolean isAutoHide() {
        return this.autoHide;
    }

    boolean isDocked() {
        return DockingType.DOCKED == this.type;
    }

    public boolean isFloating() {
        return DockingType.FLOATING == this.type;
    }

    public boolean isSliding() {
        return DockingType.SLIDING == this.type;
    }

    boolean isVisible() {
        return this.visible;
    }

    public void setActive(boolean flag) {
        this.active = flag;
    }

    void setAutoHide(boolean flag) {
        this.autoHide = flag;
    }

    public void setType(DockingType toolwindowtype) {
        if (toolwindowtype == null) {
            throw new IllegalArgumentException("type cannot be null");
        }
        if (DockingType.DOCKED == toolwindowtype || DockingType.SLIDING == toolwindowtype) {
            this.internalType = toolwindowtype;
        }
        this.type = toolwindowtype;
    }

    void setVisible(boolean flag) {
        this.visible = flag;
    }

    void setWeight(float f1) {
        if (f1 < 0.0f) {
            f1 = 0.0f;
        } else if (f1 > 1.0f) {
            f1 = 1.0f;
        }
        this.weight = f1;
    }
}

