/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.docking.swing;

import com.macrofocus.docking.swing.DockingButton;
import com.macrofocus.docking.swing.DockingView;
import com.macrofocus.docking.swing.plaf.DockingViewTitleBarUI;
import com.macrofocus.docking.swing.plaf.basic.BasicDockingViewTitleBarUI;
import de.javasoft.docking.ui.controls.IDockingButtonFactory;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.util.LinkedHashMap;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import org.jdesktop.swingx.plaf.LookAndFeelAddons;

public class DockingViewTitleBar
extends JComponent {
    private static final long serialVersionUID = -8936591064762821423L;
    public static final String uiClassID = "DockingViewTitleBarUI";
    private JLabel titleLabel = new TitleLabel();
    private Color titleForeground;
    private Color activeTitleForeground;
    private LinkedHashMap<Action, DockingButton> dockingButtons;
    private DockingView parentView;

    public DockingViewTitleBar() {
        this(null, null);
    }

    public DockingViewTitleBar(String paramString, Action[] paramArrayOfAction) {
        this.setTitleText(paramString);
        this.setActions(paramArrayOfAction);
        this.add(this.titleLabel);
        this.add(Box.createHorizontalGlue());
        this.updateUI();
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    @Override
    public void updateUI() {
        this.setUI(LookAndFeelAddons.getUI((JComponent)this, DockingViewTitleBarUI.class));
    }

    @Override
    public DockingViewTitleBarUI getUI() {
        return (DockingViewTitleBarUI)this.ui;
    }

    protected void setActions(Action[] paramArrayOfAction) {
        if (paramArrayOfAction == null) {
            paramArrayOfAction = new Action[]{};
            this.dockingButtons = new LinkedHashMap(4);
        }
        this.removeActions();
        for (int i = 0; i < paramArrayOfAction.length; ++i) {
            this.addAction(paramArrayOfAction[i]);
        }
    }

    protected void removeActions() {
        for (Action localAction : this.getActions()) {
            this.removeAction(localAction);
        }
    }

    public Action[] getActions() {
        return this.dockingButtons.keySet().toArray(new Action[0]);
    }

    public void addAction(Action paramAction) {
        if (!this.dockingButtons.keySet().contains(paramAction)) {
            DockingButton localDockingButton = this.createDockingButton(paramAction);
            this.dockingButtons.put(paramAction, localDockingButton);
            this.add(localDockingButton);
        }
    }

    public void removeAction(Action paramAction) {
        if (this.dockingButtons.keySet().contains(paramAction)) {
            this.remove(this.dockingButtons.get(paramAction));
            this.dockingButtons.remove(paramAction);
        }
    }

    public boolean isActive() {
        return this.parentView != null && this.parentView.isActive();
    }

    public void setView(DockingView paramJYDockingView) {
        this.parentView = paramJYDockingView;
    }

    public DockingView getView() {
        return (DockingView)SwingUtilities.getAncestorOfClass(DockingView.class, this);
    }

    private DockingButton createDockingButton(Action paramAction) {
        DockingButton localDockingButton = null;
        IDockingButtonFactory localIDockingButtonFactory = ((BasicDockingViewTitleBarUI)this.getUI()).getDockingButtonFactory();
        return localDockingButton;
    }

    public void setTitleText(String paramString) {
        this.titleLabel.setText(paramString == null ? "" : paramString);
    }

    public String getTitleText() {
        return this.titleLabel.getText();
    }

    public Icon getTitleIcon() {
        return this.titleLabel.getIcon();
    }

    public void setTitleIcon(Icon paramIcon) {
        this.titleLabel.setIcon(paramIcon);
    }

    public void setTitleForeground(Color paramColor) {
        this.titleForeground = paramColor;
    }

    public Color getTitleForeground() {
        return this.titleForeground;
    }

    public void setActiveTitleForeground(Color paramColor) {
        this.activeTitleForeground = paramColor;
    }

    public Color getActiveTitleForeground() {
        return this.activeTitleForeground;
    }

    protected Icon getIcon(Action paramAction) {
        Object localObject = paramAction == null ? null : paramAction.getValue("SmallIcon");
        return localObject instanceof Icon ? (Icon)localObject : null;
    }

    private class TitleLabel
    extends JLabel {
        private static final long serialVersionUID = -1108225465058579891L;

        private TitleLabel() {
        }

        @Override
        public Dimension getMinimumSize() {
            int i = this.getIcon() == null ? 0 : this.getIcon().getIconWidth();
            return new Dimension(i, super.getMinimumSize().height);
        }

        @Override
        public Color getForeground() {
            return DockingViewTitleBar.this.isActive() ? DockingViewTitleBar.this.getActiveTitleForeground() : DockingViewTitleBar.this.getTitleForeground();
        }

        @Override
        public Font getFont() {
            return DockingViewTitleBar.this.getFont();
        }

        @Override
        public boolean isFocusable() {
            return false;
        }
    }
}

