/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.crossplatform.swing;

import com.macrofocus.timer.AbstractCPTimer;
import com.macrofocus.timer.CPTimerListener;
import com.macrofocus.timer.CoalescingTimer;
import com.macrofocus.timer.Timer;

public class SwingTimer
extends AbstractCPTimer {
    private final String name;
    private CoalescingTimer timer;
    private CoalescingTimer keepAliveTimer;
    private Thread timerThread;
    private Thread keepAliveThread;

    public SwingTimer(String name, int delay, boolean postponing) {
        this.name = name;
        this.timer = new CoalescingTimer(delay, postponing);
        this.keepAliveTimer = null;
        this.timer.addActionListener(new Timer.TimerListener(){

            public void timerTriggered() {
                for (CPTimerListener listener : SwingTimer.this.listeners) {
                    listener.timerTriggered();
                }
            }
        });
    }

    public SwingTimer(String name, int delay, int keepAlive, boolean postponing) {
        this.name = name;
        assert (keepAlive > delay);
        this.timer = new CoalescingTimer(delay, postponing);
        this.keepAliveTimer = new CoalescingTimer(keepAlive);
        this.timer.addActionListener(new Timer.TimerListener(){

            public void timerTriggered() {
                for (CPTimerListener listener : SwingTimer.this.listeners) {
                    listener.timerTriggered();
                }
            }
        });
        this.keepAliveTimer.addActionListener(new Timer.TimerListener(){

            public void timerTriggered() {
                SwingTimer.this.timer.stop();
                SwingTimer.this.keepAliveTimer.stop();
                SwingTimer.this.keepAliveThread = null;
                SwingTimer.this.timerThread = null;
            }
        });
    }

    public void restart() {
        if (this.timerThread == null || !this.timerThread.isAlive()) {
            this.timerThread = new Thread((Runnable)this.timer);
            this.timerThread.setName((String)(this.name != null ? this.name + "$Timer" : "Coalescing$Timer"));
            this.timerThread.setDaemon(true);
            this.timerThread.start();
        }
        if (this.keepAliveTimer != null && this.keepAliveThread == null || !this.keepAliveThread.isAlive()) {
            this.keepAliveThread = new Thread((Runnable)this.keepAliveTimer);
            this.keepAliveThread.setName((String)(this.name != null ? this.name + "$KeepAlive" : "Coalescing$KeepAlive"));
            this.keepAliveThread.setDaemon(true);
            this.keepAliveThread.start();
        }
        this.timer.restart();
        if (this.keepAliveTimer != null) {
            this.keepAliveTimer.restart();
        }
    }

    public void stop() {
        this.timer.stop();
        if (this.keepAliveTimer != null) {
            this.keepAliveTimer.stop();
        }
    }

    public String toString() {
        return "SwingTimer{timer=" + String.valueOf(this.timer) + "timerThread=" + (this.timerThread != null && this.timerThread.isAlive()) + "keepAliveThread=" + (this.keepAliveThread != null && this.keepAliveThread.isAlive()) + "}";
    }
}

