/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.cartoplot.swing;

import com.macrofocus.cartoplot.swing.GeometryCollectionShape;
import com.macrofocus.cartoplot.swing.PolygonShape;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;

public class Java2DConverter {
    private static final double POINT_MARKER_SIZE = 3.0;
    private final PointConverter pointConverter;
    private double decimatorResolution = 0.5;

    public Java2DConverter(PointConverter pointConverter) {
        this.pointConverter = pointConverter;
    }

    public Java2DConverter(PointConverter pointConverter, double resolution) {
        this.pointConverter = pointConverter;
        this.decimatorResolution = resolution;
    }

    private Shape toShape(Polygon p) {
        ArrayList<Coordinate[]> holeVertexCollection = new ArrayList<Coordinate[]>();
        for (int j = 0; j < p.getNumInteriorRing(); ++j) {
            holeVertexCollection.add(this.toViewCoordinates(p.getInteriorRingN(j).getCoordinates()));
        }
        return new PolygonShape(this.toViewCoordinates(p.getExteriorRing().getCoordinates()), holeVertexCollection);
    }

    public Coordinate[] toViewCoordinates(Coordinate[] modelCoordinates) {
        Coordinate[] viewCoordinates = new Coordinate[modelCoordinates.length];
        double ps = this.decimatorResolution / this.pointConverter.getScale();
        Coordinate p0 = modelCoordinates[0];
        int npts = 0;
        int mpts = modelCoordinates.length;
        for (int i = 0; i < mpts; ++i) {
            Coordinate pi = modelCoordinates[i];
            if (this.decimatorResolution > 0.0) {
                double xd = Math.abs(p0.getX() - pi.getX());
                double yd = Math.abs(p0.getY() - pi.getY());
                if (!(xd >= ps) && !(yd >= ps) && npts >= 4 && i != mpts - 1) continue;
                Point2D point2D = this.pointConverter.toViewPoint(pi);
                viewCoordinates[npts++] = new Coordinate(point2D.getX(), point2D.getY());
                p0 = pi;
                continue;
            }
            Point2D point2D = this.pointConverter.toViewPoint(pi);
            viewCoordinates[npts++] = new Coordinate(point2D.getX(), point2D.getY());
        }
        if (npts != mpts) {
            Coordinate[] viewCoordinates2 = new Coordinate[npts];
            for (int i = 0; i < npts; ++i) {
                viewCoordinates2[i] = viewCoordinates[i];
            }
            return viewCoordinates2;
        }
        return viewCoordinates;
    }

    private Shape toShape(GeometryCollection gc) {
        GeometryCollectionShape shape = new GeometryCollectionShape();
        for (int i = 0; i < gc.getNumGeometries(); ++i) {
            Geometry g = gc.getGeometryN(i);
            shape.add(this.toShape(g));
        }
        return shape;
    }

    private GeneralPath toShape(MultiLineString mls) {
        GeneralPath path = new GeneralPath();
        for (int i = 0; i < mls.getNumGeometries(); ++i) {
            LineString lineString = (LineString)mls.getGeometryN(i);
            path.append(this.toShape(lineString), false);
        }
        return path;
    }

    private GeneralPath toShape(LineString lineString) {
        int numPoints = lineString.getNumPoints();
        GeneralPath shape = new GeneralPath(1, numPoints);
        LineStringPath pi = new LineStringPath(lineString, this);
        shape.append(pi, false);
        return shape;
    }

    private Shape toShape(Point point) {
        Point2D start = this.toViewPoint(new Coordinate(point.getCoordinate().getX() - 2.09E-6, point.getCoordinate().getY() + 2.09E-6));
        Point2D end = this.toViewPoint(new Coordinate(point.getCoordinate().getX() + 2.09E-6, point.getCoordinate().getY() - 2.09E-6));
        Rectangle2D.Double pointMarker = new Rectangle2D.Double(start.getX(), start.getY(), end.getX() - start.getX(), end.getY() - start.getY());
        return pointMarker;
    }

    private Point2D toViewPoint(Coordinate modelCoordinate) {
        Point2D viewPoint = this.pointConverter.toViewPoint(modelCoordinate);
        return viewPoint;
    }

    public Shape toShape(Geometry geometry) {
        if (geometry == null) {
            return null;
        }
        if (geometry.isEmpty()) {
            return new GeneralPath();
        }
        if (geometry instanceof Polygon) {
            return this.toShape((Polygon)geometry);
        }
        if (geometry instanceof MultiPolygon) {
            return this.toShape((GeometryCollection)((MultiPolygon)geometry));
        }
        if (geometry instanceof LineString) {
            return this.toShape((LineString)geometry);
        }
        if (geometry instanceof MultiLineString) {
            return this.toShape((MultiLineString)geometry);
        }
        if (geometry instanceof Point) {
            return this.toShape((Point)geometry);
        }
        if (geometry instanceof GeometryCollection) {
            return this.toShape((GeometryCollection)geometry);
        }
        throw new IllegalArgumentException("Unrecognized Geometry class: " + String.valueOf(geometry.getClass()));
    }

    public static interface PointConverter {
        public Point2D toViewPoint(Coordinate var1);

        public double getScale();
    }

    class LineStringPath
    implements PathIterator {
        private int iterate;
        private final int numPoints;
        private final Coordinate[] points;
        private final boolean closed;

        public LineStringPath(LineString linestring, Java2DConverter j2D) {
            this.points = j2D.toViewCoordinates(linestring.getCoordinates());
            this.numPoints = this.points.length;
            this.iterate = 0;
            this.closed = this.numPoints > 1 && this.points[0].equals2D(this.points[this.numPoints - 1]);
        }

        private int getSegType() {
            if (this.closed && this.iterate == this.numPoints - 1) {
                return 4;
            }
            return this.iterate == 0 ? 0 : 1;
        }

        @Override
        public int currentSegment(double[] coords) {
            coords[0] = this.points[this.iterate].getX();
            coords[1] = this.points[this.iterate].getY();
            return this.getSegType();
        }

        @Override
        public int currentSegment(float[] coords) {
            coords[0] = (float)this.points[this.iterate].getX();
            coords[1] = (float)this.points[this.iterate].getY();
            return this.getSegType();
        }

        @Override
        public int getWindingRule() {
            return 1;
        }

        @Override
        public boolean isDone() {
            return this.iterate >= this.numPoints;
        }

        @Override
        public void next() {
            ++this.iterate;
        }
    }
}

