/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.cartoplot.swing;

import com.macrofocus.cartoplot.swing.ShapeCollectionPathIterator;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.locationtech.jts.geom.Coordinate;

public class PolygonShape
implements Shape {
    private final GeneralPath shell;
    private List<GeneralPath> holes = new ArrayList<GeneralPath>();

    public PolygonShape() {
        this.shell = null;
        this.holes = null;
    }

    public PolygonShape(Coordinate[] shellVertices, Collection<Coordinate[]> holeVerticesCollection) {
        this.shell = this.toPolygon(shellVertices);
        for (Coordinate[] holeVertices : holeVerticesCollection) {
            this.holes.add(this.toPolygon(holeVertices));
        }
    }

    public final GeneralPath toPolygon(Coordinate[] coordinates) {
        int numPoints = coordinates.length;
        GeneralPath shape = new GeneralPath(0, numPoints);
        PolygonPath pi = new PolygonPath(coordinates);
        shape.append(pi, false);
        return shape;
    }

    @Override
    public Rectangle getBounds() {
        return this.shell.getBounds();
    }

    @Override
    public Rectangle2D getBounds2D() {
        return this.shell.getBounds2D();
    }

    @Override
    public boolean contains(double x, double y) {
        throw new UnsupportedOperationException("Method contains() not yet implemented.");
    }

    @Override
    public boolean contains(Point2D p) {
        if (this.shell.contains(p)) {
            for (GeneralPath hole : this.holes) {
                if (!hole.contains(p)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean intersects(double x, double y, double w, double h) {
        return this.shell.intersects(x, y, w, h);
    }

    @Override
    public boolean intersects(Rectangle2D r) {
        throw new UnsupportedOperationException("Method intersects() not yet implemented.");
    }

    @Override
    public boolean contains(double x, double y, double w, double h) {
        throw new UnsupportedOperationException("Method contains() not yet implemented.");
    }

    @Override
    public boolean contains(Rectangle2D r) {
        throw new UnsupportedOperationException("Method contains() not yet implemented.");
    }

    @Override
    public PathIterator getPathIterator(AffineTransform at) {
        ArrayList<GeneralPath> rings = new ArrayList<GeneralPath>();
        rings.add(this.shell);
        rings.addAll(this.holes);
        return new ShapeCollectionPathIterator(rings, at);
    }

    @Override
    public PathIterator getPathIterator(AffineTransform at, double flatness) {
        return this.getPathIterator(at);
    }

    class PolygonPath
    implements PathIterator {
        private int iterate;
        private final int numPoints;
        private final Coordinate[] points;

        public PolygonPath(Coordinate[] coordinates) {
            this.points = coordinates;
            this.numPoints = this.points.length;
            this.iterate = 0;
        }

        private int getSegType() {
            if (this.iterate == this.numPoints - 1) {
                return 4;
            }
            return this.iterate == 0 ? 0 : 1;
        }

        @Override
        public int currentSegment(double[] coords) {
            coords[0] = this.points[this.iterate].getX();
            coords[1] = this.points[this.iterate].getY();
            return this.getSegType();
        }

        @Override
        public int currentSegment(float[] coords) {
            coords[0] = (float)this.points[this.iterate].getX();
            coords[1] = (float)this.points[this.iterate].getY();
            return this.getSegType();
        }

        @Override
        public int getWindingRule() {
            return 0;
        }

        @Override
        public boolean isDone() {
            return this.iterate >= this.numPoints;
        }

        @Override
        public void next() {
            ++this.iterate;
        }
    }
}

