/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.cartoplot.swing.georeferencing;

import com.macrofocus.cartoplot.georeferencing.GeoReferencingService;
import com.macrofocus.cartoplot.swing.georeferencing.LookupGeoReferencingService;
import com.macrofocus.data.dataframe.DefaultDataFrame;
import com.macrofocus.data.source.DataSource;
import com.macrofocus.data.source.DataSourceFactory;
import com.macrofocus.data.table.TableHelper;
import java.io.File;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import org.locationtech.jts.geom.Geometry;

public class GeoReferencing {
    public GeoReferencing(File input, File output) {
        try {
            DataSource dataSource = DataSourceFactory.getDataSource((File)input);
            TableModel inputTableModel = dataSource.load(null);
            TableModel lookupTableModel = DataSourceFactory.getDataSource((File)new File("/Users/luc/macrofocus/dataset/cartorama/stoppkleber/gg25_a-wgs84.shp")).load(null);
            LookupGeoReferencingService service = new LookupGeoReferencingService(new DefaultDataFrame(inputTableModel), "BFS", lookupTableModel, "OBJECTVAL", null);
            GeoreferencedTableModel outputTableModel = new GeoreferencedTableModel(inputTableModel, (GeoReferencingService)service);
            TableHelper.writeTabDelimited((TableModel)outputTableModel, (File)output);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        String input = args[0];
        String output = args[1];
        new GeoReferencing(new File(input), new File(output));
    }

    private class GeoreferencedTableModel
    implements TableModel {
        private TableModel tableModel;
        private GeoReferencingService service;

        private GeoreferencedTableModel(TableModel tableModel, GeoReferencingService service) {
            this.tableModel = tableModel;
            this.service = service;
        }

        @Override
        public int getRowCount() {
            return this.tableModel.getRowCount();
        }

        @Override
        public int getColumnCount() {
            return this.tableModel.getColumnCount();
        }

        @Override
        public String getColumnName(int columnIndex) {
            if (columnIndex < this.getColumnCount() - 1) {
                return this.tableModel.getColumnName(columnIndex);
            }
            return "Geometry";
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            if (columnIndex < this.getColumnCount() - 1) {
                return this.tableModel.getColumnClass(columnIndex);
            }
            return Geometry.class;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (columnIndex < this.getColumnCount() - 1) {
                return this.tableModel.getValueAt(rowIndex, columnIndex);
            }
            return this.service.getGeometry((Object)rowIndex);
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        }

        @Override
        public void addTableModelListener(TableModelListener l) {
        }

        @Override
        public void removeTableModelListener(TableModelListener l) {
        }
    }
}

