/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.cartoplot.swing.georeferencing;

import com.macrofocus.cartoplot.georeferencing.AbstractGeoReferencingService;
import com.macrofocus.data.table.Column;
import com.macrofocus.data.table.ColumnsComboBoxModel;
import com.macrofocus.data.table.VariableComboBox;
import com.macrofocus.molap.dataframe.DataFrame;
import java.awt.Component;
import java.awt.GridLayout;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.table.TableModel;
import org.geotools.geometry.jts.GeometryCoordinateSequenceTransformer;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.locationtech.jts.geom.Geometry;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

public class LookupGeoReferencingService<R, C>
extends AbstractGeoReferencingService<JComponent, R> {
    private DataFrame<R, C, ?> dataFrame;
    private C keyIndex = null;
    private TableModel lookupTableModel;
    private int lookupKeyIndex = -1;
    private int geometryIndex = -1;
    private CoordinateReferenceSystem crs;

    public LookupGeoReferencingService(DataFrame<R, C, ?> dataFrame, String key, TableModel lookupTableModel, String lookupKey, CoordinateReferenceSystem crs) {
        int c;
        this.dataFrame = dataFrame;
        this.lookupTableModel = lookupTableModel;
        this.crs = crs;
        for (Object c2 : dataFrame.columns()) {
            if (!key.equals(dataFrame.getColumnName(c2))) continue;
            this.setKeyIndex(c2);
        }
        for (c = 0; c < lookupTableModel.getColumnCount(); ++c) {
            if (!Geometry.class.isAssignableFrom(lookupTableModel.getColumnClass(c))) continue;
            this.setGeometryIndex(c);
        }
        for (c = 0; c < lookupTableModel.getColumnCount(); ++c) {
            if (!lookupKey.equals(lookupTableModel.getColumnName(c))) continue;
            this.setLookupKeyIndex(c);
        }
    }

    public boolean isValid() {
        return this.geometryIndex >= 0;
    }

    public JComponent getEditor() {
        VariableComboBox latComboBox = new VariableComboBox((ComboBoxModel)new ColumnsComboBoxModel(this.lookupTableModel, false, true));
        latComboBox.setSelectedIndex(this.getGeometryIndex() + 1);
        latComboBox.getModel().addListDataListener(new ListDataListener(){
            final /* synthetic */ JComboBox val$latComboBox;
            {
                this.val$latComboBox = jComboBox;
            }

            @Override
            public void intervalAdded(ListDataEvent e) {
            }

            @Override
            public void intervalRemoved(ListDataEvent e) {
            }

            @Override
            public void contentsChanged(ListDataEvent e) {
                Column column = (Column)this.val$latComboBox.getSelectedItem();
                if (column != null) {
                    LookupGeoReferencingService.this.setGeometryIndex(column.getColumn());
                } else {
                    LookupGeoReferencingService.this.setGeometryIndex(-1);
                }
            }
        });
        JPanel panel = new JPanel();
        panel.setLayout(new GridLayout(1, 1));
        panel.add((Component)latComboBox);
        return panel;
    }

    public boolean isPointGeometry() {
        return false;
    }

    public Geometry getGeometry(R row) {
        if (this.geometryIndex >= 0) {
            Object key = this.dataFrame.getValueAt(row, this.keyIndex);
            for (int r = 0; r < this.lookupTableModel.getRowCount(); ++r) {
                Object lookupKey = this.lookupTableModel.getValueAt(r, this.lookupKeyIndex);
                if (key instanceof String && !(lookupKey instanceof String)) {
                    lookupKey = lookupKey.toString();
                }
                if (key == null || !key.equals(lookupKey)) continue;
                try {
                    Geometry geom = (Geometry)this.lookupTableModel.getValueAt(r, this.geometryIndex);
                    if (this.crs != null) {
                        MathTransform transform = CRS.findMathTransform((CoordinateReferenceSystem)this.crs, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
                        geom = LookupGeoReferencingService.transform(geom, transform);
                        return geom;
                    }
                    return geom;
                }
                catch (FactoryException e) {
                    e.printStackTrace();
                    continue;
                }
                catch (TransformException e) {
                    e.printStackTrace();
                }
            }
            System.err.println(String.valueOf(key) + " not found (" + String.valueOf(key.getClass()) + ")");
        }
        return null;
    }

    public static Geometry transform(Geometry geom, MathTransform transform) throws MismatchedDimensionException, TransformException {
        GeometryCoordinateSequenceTransformer transformer = new GeometryCoordinateSequenceTransformer();
        transformer.setMathTransform(transform);
        return transformer.transform(geom);
    }

    public int getGeometryIndex() {
        return this.geometryIndex;
    }

    public void setGeometryIndex(int geometryIndex) {
        if (this.geometryIndex != geometryIndex) {
            int old = this.geometryIndex;
            this.geometryIndex = geometryIndex;
            this.notififyGeoReferencingServiceChanged();
        }
    }

    public C getKeyIndex() {
        return this.keyIndex;
    }

    public void setKeyIndex(C keyIndex) {
        this.keyIndex = keyIndex;
    }

    public int getLookupKeyIndex() {
        return this.lookupKeyIndex;
    }

    public void setLookupKeyIndex(int lookupKeyIndex) {
        this.lookupKeyIndex = lookupKeyIndex;
    }

    public String toString() {
        return "Lookup";
    }
}

