/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.cartoplot.swing.georeferencing;

import com.macrofocus.cartoplot.georeferencing.GeoReferencingService;
import com.macrofocus.cartoplot.georeferencing.GeoReferencingServiceFactory;
import com.macrofocus.cartoplot.swing.georeferencing.SwingGeometryGeoReferencingService;
import com.macrofocus.cartoplot.swing.georeferencing.SwingLatLonGeoReferencingService;
import com.macrofocus.cartoplot.swing.georeferencing.country.CountryGeoReferencingService;
import com.macrofocus.cartoplot.swing.georeferencing.county.USCountiesGeoReferencingService;
import com.macrofocus.molap.dataframe.DataFrame;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.JComponent;

public class SwingGeoReferencingServiceFactory<R>
implements GeoReferencingServiceFactory<JComponent, R> {
    private static Map<DataFrame, SwingGeoReferencingServiceFactory> ourInstances = new WeakHashMap<DataFrame, SwingGeoReferencingServiceFactory>();
    private final List<GeoReferencingService<JComponent, R>> entries = new ArrayList<GeoReferencingService<JComponent, R>>();

    public static <R> SwingGeoReferencingServiceFactory getInstance(DataFrame<R, ?, ?> dataFrame) {
        if (!ourInstances.containsKey(dataFrame)) {
            SwingGeoReferencingServiceFactory<R> factory = new SwingGeoReferencingServiceFactory<R>(dataFrame);
            ourInstances.put(dataFrame, factory);
        }
        return ourInstances.get(dataFrame);
    }

    protected <C> GeoReferencingService<JComponent, R>[] createServices(DataFrame<R, C, ?> dataFrame) {
        return new GeoReferencingService[]{new SwingLatLonGeoReferencingService<R, C>(dataFrame), new SwingGeometryGeoReferencingService<R, C>(dataFrame), new CountryGeoReferencingService<R, C>(dataFrame), new USCountiesGeoReferencingService<R, C>(dataFrame)};
    }

    protected SwingGeoReferencingServiceFactory(DataFrame<R, ?, ?> dataFrame) {
        this.entries.addAll(Arrays.asList(this.createServices(dataFrame)));
    }

    public GeoReferencingService getDefault() {
        for (GeoReferencingService<JComponent, R> entry : this.entries) {
            if (!entry.isValid()) continue;
            return entry;
        }
        return this.entries.get(0);
    }

    public List<GeoReferencingService<JComponent, R>> getGeoReferencingServices() {
        return this.entries;
    }
}

