/*
 * Decompiled with CFR 0.152.
 */
package com.treemap;

import com.macrofocus.colormap.MutableColorMap;
import com.macrofocus.common.properties.MutableProperties;
import com.macrofocus.common.properties.MutableProperty;
import com.macrofocus.common.selection.MutableSelection;
import com.macrofocus.common.selection.MutableSingleSelection;
import com.macrofocus.filter.MutableFilter;
import com.macrofocus.geom.Point;
import com.macrofocus.geom.Rectangle2D;
import com.macrofocus.geom.Shape;
import com.macrofocus.igraphics.CPColor;
import com.macrofocus.igraphics.CPColorFactory;
import com.macrofocus.igraphics.CPImage;
import com.macrofocus.igraphics.CPImageFactory;
import com.macrofocus.igraphics.ColorProvider;
import com.macrofocus.molap.dataframe.DataFrame;
import com.treemap.TreeMapField;
import com.treemap.TreeMapFieldSettings;
import com.treemap.TreeMapListener;
import com.treemap.TreeMapSettings;
import com.treemap.TreeMapWorker;
import java.util.concurrent.Future;
import jsinterop.annotations.JsIgnore;
import jsinterop.annotations.JsType;

@JsType
public interface TreeMapModel<N, Row, Column, Color, Font> {
    public static final String PROPERTY_PROGRESS = "progress";
    public static final String PROPERTY_CURRENT_ROOT = "currentRoot";

    public DataFrame<Row, Column, ?> getDataFrame();

    public MutableProperties<String> getProperties();

    public Iterable<TreeMapField<N, Column>> getGroupByTreeMapFields();

    public Iterable<TreeMapField<N, Column>> getSizeTreeMapFields();

    public Iterable<TreeMapField<N, Column>> getColorTreeMapFields();

    public Iterable<TreeMapField<N, Column>> getHeightTreeMapFields();

    public Iterable<TreeMapField<N, Column>> getLabelsTreeMapFields();

    public Iterable<TreeMapField<N, Column>> getTooltipTreeMapFields();

    public boolean isNumericType(TreeMapField<N, Column> var1);

    public boolean isTemporalType(TreeMapField<N, Column> var1);

    public boolean isVisualType(TreeMapField<N, Column> var1);

    public MutableColorMap<Color> getColorMap(TreeMapField<N, Column> var1);

    public MutableColorMap<Color> getCategoricalColorMap(Column var1);

    public MutableColorMap<Color> getPredefinedColorMap(Column var1);

    public MutableColorMap<Color> getCustomColorMap(Column var1);

    public MutableColorMap createDefaultColorMap(TreeMapField<N, Column> var1);

    public double getSize(N var1);

    public double getMaximumSize();

    @JsIgnore
    public void setShape(N var1, Shape var2);

    @JsIgnore
    public Shape getShape(N var1);

    @JsIgnore
    public void setNestedShape(N var1, Shape var2);

    @JsIgnore
    public Shape getNestedShape(N var1);

    @JsIgnore
    public Rectangle2D getBounds(N var1);

    public int getLevel(N var1);

    public TreeMapField<N, Column> getGroupByField(N var1);

    public TreeMapField<N, Column> getChildrenGroupByField(N var1);

    public String getLabelName(N var1);

    public ColorProvider<N, Color> getColorProvider();

    public void setColorProvider(ColorProvider<N, Color> var1);

    public void setColor(N var1, CPColor<Color> var2);

    public CPColor<Color> getColor(N var1);

    public boolean hasNoChildren(N var1);

    public boolean isLeaf(N var1);

    public N getParent(N var1);

    public boolean isRoot(N var1);

    @JsIgnore
    public Iterable<N> getChildren(N var1);

    @JsIgnore
    public Iterable<N> getChildrenOfTypeParent(N var1);

    public int getChildCount(N var1);

    @JsIgnore
    public CPImage getCushionImage(N var1);

    public CPColor<Color> getCushionColor(N var1);

    @JsIgnore
    public Iterable<N> parentPreorderEnumeration(N var1);

    @JsIgnore
    public Iterable<N> preorderEnumeration(N var1);

    @JsIgnore
    public Iterable<N> breadthFirstIterator(N var1);

    @JsIgnore
    public Iterable<N> depthFirstIterator(N var1);

    public N getNode(Row var1);

    public TreeMapField<N, Column> getTreeMapField(int var1);

    @JsIgnore
    public TreeMapField getTreeMapField(Column var1);

    public TreeMapField<N, Column> getTreeMapFieldByName(String var1);

    public Double getNumericMax(TreeMapField<N, Column> var1);

    public Double getNumericMin(TreeMapField<N, Column> var1);

    public void setNumericMax(TreeMapField var1, double var2);

    public void setNumericMin(TreeMapField var1, double var2);

    public double getNormalizedLightSourceX();

    public double getNormalizedLightSourceY();

    public double getNormalizedLightSourceZ();

    public int getRowCount();

    public int getColumnCount();

    @JsIgnore
    public Iterable<Column> columns();

    public String getColumnName(Column var1);

    @JsIgnore
    public Class<?> getColumnClass(Column var1);

    public Object getValueAt(N var1, Column var2);

    public boolean isEveryValueUnique(TreeMapField<N, Column> var1);

    public Object getAggregateValue(N var1, TreeMapField<N, Column> var2);

    public String getStringValue(N var1, TreeMapField<N, Column> var2, TreeMapFieldSettings<Color, Font> var3);

    public N getRoot();

    public N getCurrentRoot();

    public void setCurrentRoot(N var1);

    public MutableSingleSelection<N> getProbing();

    public MutableSelection<N> getHighlighting();

    public MutableSelection<N> getSelection();

    public MutableFilter<N> getFilter();

    public MutableFilter<N> getSearch();

    public TreeMapSettings<N, Column, Color, Font> getSettings();

    @JsIgnore
    public TreeMapWorker getWorker();

    @JsIgnore
    public Future<Void> getWorkerFuture();

    @JsIgnore
    public void addListener(TreeMapListener var1);

    @JsIgnore
    public void removeListener(TreeMapListener var1);

    @JsIgnore
    public N getNode(Point var1);

    public boolean isDirty();

    public void waitUntilReady();

    public double getSumSize(N var1);

    public MutableProperty<Integer> progressProperty();

    public String getFormatPattern(int var1);

    public void setFormatPattern(int var1, String var2);

    public CPColorFactory<Color> getColorFactory();

    public CPImageFactory getImageFactory();
}

