/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.application.high_d.data;

import com.macrofocus.data.dataframe.DefaultDataFrame;
import com.macrofocus.molap.aggregates.AggregateDataFrame;
import com.macrofocus.molap.aggregates.aggregation.Aggregation;
import com.macrofocus.molap.dataframe.DataFrame;
import com.macrofocus.molap.dataframe.HeadDataFrame;
import com.macrofocus.molap.dataframe.MutableDataFrame;
import com.macrofocus.molap.dataframe.TailDataFrame;
import com.macrofocus.molap.dataframe.WrappedDataFrame;
import com.macrofocus.molap.dataframe.swing.SwingDataFrameFactory;
import com.macrofocus.molap.exporter.java.SwingDataFrameExporter;
import com.macrofocus.molap.subset.SubsetDataFrame;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;

public class GCRIHighD {
    public static void main(String[] args) {
        String localStore = "/Users/luc/macrofocus/dataset/high-d/";
        String datasetName = "UBS Prices and Earnings 2018";
        try {
            MutableDataFrame input = SwingDataFrameFactory.fromExcel((URL)new File("/Users/luc/macrofocus/dataset/high-d/", "UBS Prices and Earnings 2018.xlsx").toURI().toURL());
            MutableDataFrame old = SwingDataFrameFactory.fromCSV((URL)new File("/Users/luc/macrofocus/dataset/high-d/", "UBS Prices and Earnings 2015/Prices and Earnings around the Globe 2012.csv").toURI().toURL()).reindexRowsUsingColumn((Object)"City");
            HeadDataFrame head = new HeadDataFrame((DataFrame)input, input.getRowCount() - 1);
            SubsetDataFrame latest = new SubsetDataFrame((DataFrame)head);
            latest.getCategoricalDimension((Object)"Year").filterExact(new Object[]{2018});
            latest.print();
            WrappedDataFrame derived = new WrappedDataFrame((DataFrame)latest);
            derived.addOriginalColumns();
            derived.addDerivedColumn(new WrappedDataFrame.Column[]{new WrappedDataFrame.AbstractColumn<Integer, String, Object>(){

                public String getKey() {
                    return "Column";
                }

                public Class getType(WrappedDataFrame<Integer, String, Object> dataFrame) {
                    return String.class;
                }

                public String getColumnName() {
                    return "Column";
                }

                public Object getValue(WrappedDataFrame<Integer, String, Object> dataFrame, Integer row) {
                    Object tableTitle = dataFrame.getValueAt((Object)row, (Object)"Main Section");
                    Object heading = dataFrame.getValueAt((Object)row, (Object)"Sub-Section");
                    Object year = dataFrame.getValueAt((Object)row, (Object)"Year");
                    StringBuilder sb = new StringBuilder();
                    if (tableTitle != null) {
                        sb.append(tableTitle);
                    }
                    if (heading != null) {
                        if (sb.length() > 0) {
                            sb.append(" - ");
                        }
                        sb.append(heading);
                    }
                    sb.append(" (");
                    sb.append(year);
                    sb.append(")");
                    return sb.toString();
                }
            }});
            DefaultDataFrame fixed = new DefaultDataFrame((DataFrame)derived);
            HashMap<String, String> corrections = new HashMap<String, String>();
            corrections.put("n.v.", null);
            corrections.put("-", null);
            corrections.put("10. Mrz", "70");
            for (Integer row : fixed.rows()) {
                for (String column : fixed.columns()) {
                    Object value = fixed.getValueAt(row, column);
                    if (!corrections.containsKey(value)) continue;
                    fixed.setValueAt(row, column, corrections.get(value));
                }
            }
            DefaultDataFrame clean = new DefaultDataFrame((DataFrame)fixed, true);
            new TailDataFrame((DataFrame)clean, 10).print();
            Aggregation value = clean.getFirst((Object)"Value").as("Value");
            AggregateDataFrame aggregate = clean.aggregate(new Aggregation[]{value}).drillDown((Object[])new String[]{"City", "Column"});
            AggregateDataFrame out = aggregate.pivot(value);
            new HeadDataFrame((DataFrame)out, 10).print();
            DefaultDataFrame typed = new DefaultDataFrame((DataFrame)out, true);
            new TailDataFrame((DataFrame)typed, 10).print();
            WrappedDataFrame merged = new WrappedDataFrame((DataFrame)typed);
            merged.addOriginalColumns();
            merged.addDerivedColumn(new WrappedDataFrame.Column[]{new ForeignColumn((DataFrame<Object, String, Object>)old, "Longitude", "City")});
            merged.addDerivedColumn(new WrappedDataFrame.Column[]{new ForeignColumn((DataFrame<Object, String, Object>)old, "Latitude", "City")});
            merged.addDerivedColumn(new WrappedDataFrame.Column[]{new ForeignColumn((DataFrame<Object, String, Object>)old, "City Code", "City")});
            merged.addDerivedColumn(new WrappedDataFrame.Column[]{new ForeignColumn((DataFrame<Object, String, Object>)old, "Country", "City")});
            merged.addDerivedColumn(new WrappedDataFrame.Column[]{new ForeignColumn((DataFrame<Object, String, Object>)old, "Region", "City")});
            merged.addDerivedColumn(new WrappedDataFrame.Column[]{new ForeignColumn((DataFrame<Object, String, Object>)old, "Continent", "City")});
            merged.addDerivedColumn(new WrappedDataFrame.Column[]{new ForeignColumn((DataFrame<Object, String, Object>)old, "Development", "City")});
            SwingDataFrameExporter.exportCSV((DataFrame)merged, (File)new File("/Users/luc/macrofocus/dataset/high-d/UBS Prices and Earnings 2018.csv"));
            SwingDataFrameExporter.exportTSV((DataFrame)merged, (File)new File("/Users/luc/macrofocus/dataset/high-d/UBS Prices and Earnings 2018.txt"));
            SwingDataFrameExporter.exportExcel((DataFrame)merged, (File)new File("/Users/luc/macrofocus/dataset/high-d/UBS Prices and Earnings 2018.xls"));
            SwingDataFrameExporter.exportJSON((DataFrame)merged, (File)new File("/Users/luc/macrofocus/dataset/high-d/UBS Prices and Earnings 2018.json"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static class ForeignColumn
    extends WrappedDataFrame.AbstractColumn<Integer, String, Object> {
        private final DataFrame<Object, String, Object> dataFrame;
        private final String column;
        private final String id;

        public ForeignColumn(DataFrame<Object, String, Object> dataFrame, String column, String id) {
            this.dataFrame = dataFrame;
            this.column = column;
            this.id = id;
        }

        public String getKey() {
            return this.column;
        }

        public Class getType(WrappedDataFrame<Integer, String, Object> dataFrame) {
            return this.dataFrame.getColumnClass((Object)this.column);
        }

        public String getColumnName() {
            return this.column;
        }

        public Object getValue(WrappedDataFrame<Integer, String, Object> dataFrame, Integer row) {
            return this.dataFrame.getValueAt(dataFrame.getValueAt((Object)row, (Object)this.id), (Object)this.column);
        }
    }
}

