/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.application.high_d.data;

import com.macrofocus.molap.aggregates.AggregateDataFrame;
import com.macrofocus.molap.aggregates.aggregation.Aggregation;
import com.macrofocus.molap.dataframe.DataFrame;
import com.macrofocus.molap.dataframe.HeadDataFrame;
import com.macrofocus.molap.dataframe.MutableDataFrame;
import com.macrofocus.molap.dataframe.swing.SwingDataFrameFactory;
import com.macrofocus.molap.exporter.java.SwingDataFrameExporter;
import com.macrofocus.molap.subset.SubsetDataFrame;
import java.io.File;
import java.io.IOException;

public class HumanDevelopment {
    public static void main(String[] args) {
        String localStore = "/Users/luc/macrofocus/dataset/high-d/";
        String datasetName = "UNDP Human Development 2018";
        try {
            MutableDataFrame input = SwingDataFrameFactory.getInstance().fromJSON(new File("/Users/luc/macrofocus/dataset/high-d/UNDP Human Development 2018/", "bars.json").toURI().toURL());
            SubsetDataFrame latest = new SubsetDataFrame((DataFrame)input);
            latest.getCategoricalDimension((Object)"year").filterExact(new Object[]{2017});
            Aggregation value = latest.getFirst((Object)"value").as("value");
            AggregateDataFrame aggregate = latest.aggregate(new Aggregation[]{value}).drillDown((Object[])new String[]{"country", "indicator"});
            AggregateDataFrame out = aggregate.pivot(value);
            new HeadDataFrame((DataFrame)out, 10).print();
            SwingDataFrameExporter.exportCSV((DataFrame)out, (File)new File("/Users/luc/macrofocus/dataset/high-d/UNDP Human Development 2018.csv"));
            SwingDataFrameExporter.exportTSV((DataFrame)out, (File)new File("/Users/luc/macrofocus/dataset/high-d/UNDP Human Development 2018.txt"));
            SwingDataFrameExporter.exportJSON((DataFrame)out, (File)new File("/Users/luc/macrofocus/dataset/high-d/UNDP Human Development 2018.json"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

