/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.application.high_d.data;

import com.macrofocus.application.high_d.document.HighDDocument;
import com.macrofocus.application.high_d.document.persistence.HighDPersistence;
import com.macrofocus.application.high_d.document.swing.SwingHighDApplication;
import com.macrofocus.application.high_d.swing.HighD;
import com.macrofocus.colormap.ColorMapFactory;
import com.macrofocus.colormap.swing.SwingColorMapFactory;
import com.macrofocus.common.file.FileType;
import com.macrofocus.common.file.HighDFileType;
import com.macrofocus.crossplatform.CPFactory;
import com.macrofocus.crossplatform.swing.SwingExecutor;
import com.macrofocus.crossplatform.swing.SwingFactory;
import com.macrofocus.data.dataframe.DefaultDataFrame;
import com.macrofocus.format.FormatFactory;
import com.macrofocus.format.swing.SwingFormatFactory;
import com.macrofocus.high_d.axis.AxisModel;
import com.macrofocus.high_d.axis.group.AxisGroupModel;
import com.macrofocus.high_d.axis.hierarchy.AxisHierarchy;
import com.macrofocus.high_d.mds.tsne.JavaMatrixOperationsFactory;
import com.macrofocus.high_d.mds.tsne.MatrixOperationsFactory;
import com.macrofocus.igraphics.CPColorFactory;
import com.macrofocus.igraphics.CPFontFactory;
import com.macrofocus.molap.aggregates.AggregateDataFrame;
import com.macrofocus.molap.aggregates.aggregation.Aggregation;
import com.macrofocus.molap.dataframe.DataFrame;
import com.macrofocus.molap.dataframe.HeadDataFrame;
import com.macrofocus.molap.dataframe.MutableDataFrame;
import com.macrofocus.molap.dataframe.TailDataFrame;
import com.macrofocus.molap.dataframe.WrappedDataFrame;
import com.macrofocus.molap.dataframe.swing.SwingDataFrameFactory;
import com.macrofocus.molap.exporter.java.SwingDataFrameExporter;
import com.macrofocus.molap.subset.SubsetDataFrame;
import com.macrofocus.palette.PaletteFactory;
import com.macrofocus.palette.swing.SwingPaletteFactory;
import com.macrofocus.persistence.DefaultElementFactory;
import com.macrofocus.persistence.Element;
import com.macrofocus.persistence.ElementFactory;
import com.macrofocus.persistence.xml.XmlElementSerializer;
import com.macrofocus.timer.CPExecutor;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.HashMap;

public class PricesAndEarnings {
    public static void main(String[] args) {
        String localStore = "/Users/luc/macrofocus/dataset/high-d/";
        String datasetName = "UBS Prices and Earnings 2018";
        try {
            MutableDataFrame input = SwingDataFrameFactory.fromExcel((URL)new File("/Users/luc/macrofocus/dataset/high-d/", "UBS Prices and Earnings 2018.xlsx").toURI().toURL());
            int row1 = 95306;
            Object value1 = input.getValueAt((Object)row1, (Object)"Value");
            System.err.println(String.valueOf(input.getValueAt((Object)row1, (Object)"City")) + ": " + String.valueOf(value1) + ": " + String.valueOf(value1.getClass()));
            MutableDataFrame old = SwingDataFrameFactory.fromCSV((URL)new File("/Users/luc/macrofocus/dataset/high-d/", "Cities.csv").toURI().toURL()).reindexRowsUsingColumn((Object)"City");
            HeadDataFrame head = new HeadDataFrame((DataFrame)input, input.getRowCount() - 1);
            SubsetDataFrame latest = new SubsetDataFrame((DataFrame)head);
            latest.getCategoricalDimension((Object)"Year").filterExact(new Object[]{2018});
            WrappedDataFrame derived = new WrappedDataFrame((DataFrame)latest);
            derived.addOriginalColumns();
            derived.addDerivedColumn(new WrappedDataFrame.Column[]{new WrappedDataFrame.AbstractColumn<Integer, String, Object>(){

                public String getKey() {
                    return "Column";
                }

                public Class getType(WrappedDataFrame<Integer, String, Object> dataFrame) {
                    return String.class;
                }

                public String getColumnName() {
                    return "Column";
                }

                public Object getValue(WrappedDataFrame<Integer, String, Object> dataFrame, Integer row) {
                    Object tableTitle = dataFrame.getValueAt((Object)row, (Object)"Main Section");
                    Object heading = dataFrame.getValueAt((Object)row, (Object)"Sub-Section");
                    Object year = dataFrame.getValueAt((Object)row, (Object)"Year");
                    StringBuilder sb = new StringBuilder();
                    if (tableTitle != null) {
                        sb.append(tableTitle);
                    }
                    if (heading != null) {
                        if (sb.length() > 0) {
                            sb.append(" - ");
                        }
                        sb.append(heading);
                    }
                    sb.append(" (");
                    sb.append(year);
                    sb.append(")");
                    return sb.toString();
                }
            }});
            DefaultDataFrame fixed = new DefaultDataFrame((DataFrame)derived);
            HashMap<String, String> corrections = new HashMap<String, String>();
            corrections.put("n.v.", null);
            corrections.put("-", null);
            corrections.put("10. Mrz", "70");
            for (Integer row : fixed.rows()) {
                for (String column : fixed.columns()) {
                    Object value = fixed.getValueAt(row, column);
                    if (!corrections.containsKey(value)) continue;
                    fixed.setValueAt(row, column, corrections.get(value));
                }
            }
            DefaultDataFrame clean = new DefaultDataFrame((DataFrame)fixed, true);
            new TailDataFrame((DataFrame)clean, 10).print();
            Aggregation value = clean.getFirst((Object)"Value").as("Value");
            AggregateDataFrame aggregate = clean.aggregate(new Aggregation[]{value}).drillDown((Object[])new String[]{"City", "Column"});
            AggregateDataFrame out = aggregate.pivot(value);
            new HeadDataFrame((DataFrame)out, 10).print();
            DefaultDataFrame typed = new DefaultDataFrame((DataFrame)out, true);
            new TailDataFrame((DataFrame)typed, 10).print();
            WrappedDataFrame merged = new WrappedDataFrame((DataFrame)typed);
            merged.addOriginalColumns();
            merged.addDerivedColumn(new WrappedDataFrame.Column[]{new ForeignColumn((DataFrame<Object, String, Object>)old, "Longitude", "City")});
            merged.addDerivedColumn(new WrappedDataFrame.Column[]{new ForeignColumn((DataFrame<Object, String, Object>)old, "Latitude", "City")});
            merged.addDerivedColumn(new WrappedDataFrame.Column[]{new ForeignColumn((DataFrame<Object, String, Object>)old, "City Code", "City")});
            merged.addDerivedColumn(new WrappedDataFrame.Column[]{new ForeignColumn((DataFrame<Object, String, Object>)old, "Country", "City")});
            merged.addDerivedColumn(new WrappedDataFrame.Column[]{new ForeignColumn((DataFrame<Object, String, Object>)old, "Region", "City")});
            merged.addDerivedColumn(new WrappedDataFrame.Column[]{new ForeignColumn((DataFrame<Object, String, Object>)old, "Continent", "City")});
            merged.addDerivedColumn(new WrappedDataFrame.Column[]{new ForeignColumn((DataFrame<Object, String, Object>)old, "Development", "City")});
            HashMap<Object, String> labelColumn = new HashMap<Object, String>();
            Object[] labels = new String[merged.getColumnCount()];
            for (int c = 0; c < merged.getColumnCount(); ++c) {
                String column = (String)merged.getColumnKey(c);
                String label = column;
                if (label.contains(":")) {
                    label = label.substring(column.indexOf(":") + 2);
                }
                if (label.endsWith(" (2018)")) {
                    label = label.substring(0, label.lastIndexOf(" (2018)"));
                }
                labels[c] = label;
                labelColumn.put(labels[c], column);
            }
            DataFrame labelled = merged.reindexColumns(labels);
            SwingDataFrameExporter.exportCSV((DataFrame)labelled, (File)new File("/Users/luc/macrofocus/dataset/high-d/UBS Prices and Earnings 2018.csv"));
            SwingDataFrameExporter.exportTSV((DataFrame)labelled, (File)new File("/Users/luc/macrofocus/dataset/high-d/UBS Prices and Earnings 2018.txt"));
            SwingDataFrameExporter.exportExcel((DataFrame)labelled, (File)new File("/Users/luc/macrofocus/dataset/high-d/UBS Prices and Earnings 2018.xls"));
            SwingDataFrameExporter.exportJSON((DataFrame)labelled, (File)new File("/Users/luc/macrofocus/dataset/high-d/UBS Prices and Earnings 2018.json"));
            MutableDataFrame csv = SwingDataFrameFactory.fromCSV((URL)new File("/Users/luc/macrofocus/dataset/high-d/UBS Prices and Earnings 2018.csv").toURI().toURL());
            HighDDocument document = new HighDDocument("UBS Prices and Earnings 2018", "UBS Prices and Earnings 2018", (DataFrame)csv, null, (CPFactory)SwingFactory.getInstance(), (ColorMapFactory)SwingColorMapFactory.getInstance(), (MatrixOperationsFactory)JavaMatrixOperationsFactory.getInstance(), (CPExecutor)new SwingExecutor());
            AxisHierarchy axisHierarchy = document.getAxisHierarchy();
            AxisGroupModel root = (AxisGroupModel)axisHierarchy.getAxisGroupHierarchy().getRoot();
            root.getAxisOrder().hide(root.getAxisModels());
            AxisGroupModel general = axisHierarchy.createGroup(root, "General", new AxisModel[0]);
            general.setCollapsible(true);
            AxisGroupModel prices = axisHierarchy.createGroup(root, "Prices", new AxisModel[0]);
            prices.setCollapsible(true);
            prices.setCollapsed(true);
            AxisGroupModel earnings = axisHierarchy.createGroup(root, "Earnings", new AxisModel[0]);
            earnings.setCollapsible(true);
            earnings.setCollapsed(true);
            for (String label : csv.columns()) {
                String column = (String)labelColumn.get(label);
                Object parent = column.startsWith("General:") ? (column.contains("(minutes)") || column.contains("(hours)") || column.contains("(days)") ? general : (column.contains("Domestic Purchasing Power") ? general : (column.contains("Price Level") ? general : (column.contains("Wage Level") ? general : null)))) : (column.startsWith("Prices:") ? (column.contains(" (New York = 100)") ? prices : null) : (column.startsWith("Earnings:") ? (column.contains("Gross (USD)") ? earnings : (column.contains("(%)") || column.contains("(hours)") || column.contains("(days)") ? earnings : null)) : null));
                AxisModel axisModel = root.getAxisModel(label);
                if (parent != null) {
                    if (axisModel.isNumerical()) {
                        axisHierarchy.moveToGroup(root, parent, axisModel);
                        System.err.println("Showing " + String.valueOf(axisModel) + ", " + String.valueOf(axisModel.getClass()));
                        continue;
                    }
                    System.err.println("Not numeric " + String.valueOf(axisModel) + ", " + String.valueOf(axisModel.getClass()));
                    root.getAxisOrder().setVisible((Object)axisModel, false);
                    continue;
                }
                System.err.println("Excluding column: " + column);
                root.getAxisOrder().setVisible((Object)axisModel, false);
            }
            double max = 0.0;
            double min = Double.MAX_VALUE;
            for (AxisModel axisModel : prices.getAxisModels()) {
                min = Math.min(min, axisModel.getMinimum());
                max = Math.max(max, axisModel.getMaximum());
            }
            for (AxisModel axisModel : prices.getAxisModels()) {
                axisModel.setMinMax(min, max);
            }
            max = 0.0;
            for (AxisModel axisModel : earnings.getAxisModels()) {
                if (!((String)axisModel.getColumn()).contains("Gross (USD)")) continue;
                max = Math.max(max, axisModel.getMaximum());
            }
            for (AxisModel axisModel : earnings.getAxisModels()) {
                if (!((String)axisModel.getColumn()).contains("Gross (USD)")) continue;
                axisModel.setMinMax(0.0, max);
            }
            SwingHighDApplication.saveDocument(new File("/Users/luc/macrofocus/dataset/high-d/UBS Prices and Earnings 2018.mhd"), (FileType)HighDFileType.getInstance(), document);
            DefaultElementFactory elementFactory = new DefaultElementFactory();
            HighDPersistence persistance = new HighDPersistence(document, (CPColorFactory)SwingFactory.getInstance(), (CPFontFactory)SwingFactory.getInstance(), (PaletteFactory)SwingPaletteFactory.getInstance(), (FormatFactory)SwingFormatFactory.getInstance(), (ElementFactory)elementFactory);
            Element root2 = elementFactory.newElement("High-D");
            root2.addAttribute(elementFactory.newAttribute("version", HighD.applicationModel.getVersionModel().toString()));
            persistance.save(root2, null);
            ByteArrayOutputStream baout = new ByteArrayOutputStream();
            new XmlElementSerializer().write((OutputStream)baout, root2);
            System.out.println(baout.toString());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static class ForeignColumn
    extends WrappedDataFrame.AbstractColumn<Integer, String, Object> {
        private final DataFrame<Object, String, Object> dataFrame;
        private final String column;
        private final String id;

        public ForeignColumn(DataFrame<Object, String, Object> dataFrame, String column, String id) {
            this.dataFrame = dataFrame;
            this.column = column;
            this.id = id;
        }

        public String getKey() {
            return this.column;
        }

        public Class getType(WrappedDataFrame<Integer, String, Object> dataFrame) {
            return this.dataFrame.getColumnClass((Object)this.column);
        }

        public String getColumnName() {
            return this.column;
        }

        public Object getValue(WrappedDataFrame<Integer, String, Object> dataFrame, Integer row) {
            return this.dataFrame.getValueAt(dataFrame.getValueAt((Object)row, (Object)this.id), (Object)this.column);
        }
    }
}

