/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.application.high_d.model;

import com.macrofocus.application.ApplicationModelFactory;
import com.macrofocus.application.SimpleVersionModel;
import com.macrofocus.application.high_d.model.AbstractHighDModel;
import com.macrofocus.application.high_d.model.HighDModel;
import com.macrofocus.coloring.MutableColoring;
import com.macrofocus.colormap.ColorMapFactory;
import com.macrofocus.colormap.swing.SwingColorMapFactory;
import com.macrofocus.colormapping.MutableColorMapping;
import com.macrofocus.colormapping.implementation.SimpleColorMapping;
import com.macrofocus.common.logging.Logging;
import com.macrofocus.common.properties.EnumProperties;
import com.macrofocus.common.properties.MutableProperties;
import com.macrofocus.common.properties.MutableProperty;
import com.macrofocus.common.selection.MutableSelection;
import com.macrofocus.common.selection.MutableSingleSelection;
import com.macrofocus.common.selection.Selection;
import com.macrofocus.common.selection.SingleSelection;
import com.macrofocus.crossplatform.CPCanvas;
import com.macrofocus.crossplatform.CPFactory;
import com.macrofocus.crossplatform.swing.SwingFactory;
import com.macrofocus.data.dataframe.DefaultDataFrame;
import com.macrofocus.data.source.DataSource;
import com.macrofocus.filter.Filter;
import com.macrofocus.filter.MutableFilter;
import com.macrofocus.helper.ColorHelper;
import com.macrofocus.high_d.axis.Alignment;
import com.macrofocus.high_d.axis.AxisFactory;
import com.macrofocus.high_d.axis.AxisModel;
import com.macrofocus.high_d.axis.group.AxisGroupModel;
import com.macrofocus.high_d.axis.hierarchy.AxisHierarchy;
import com.macrofocus.high_d.axis.hierarchy.DefaultAxisHierarchy;
import com.macrofocus.high_d.interaction.InteractionMode;
import com.macrofocus.high_d.parallelcoordinates.DefaultParallelCoordinatesModel;
import com.macrofocus.high_d.parallelcoordinates.DefaultParallelCoordinatesSettings;
import com.macrofocus.high_d.parallelcoordinates.ParallelCoordinatesSettings;
import com.macrofocus.high_d.parallelcoordinates.geometry.Geometry;
import com.macrofocus.high_d.statistics.StatisticsDataFrame;
import com.macrofocus.molap.dataframe.DataFrame;
import com.macrofocus.molap.subset.SubsetDataFrame;
import com.macrofocus.util.font.FontHelper;
import com.macrofocus.visual.SimpleVisual;
import com.macrofocus.visual.SimpleVisualObjects;
import com.macrofocus.visual.Visual;
import com.macrofocus.visual.VisualObjects;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import nu.xom.Attribute;
import nu.xom.Element;
import nu.xom.Elements;
import nu.xom.Node;

public class DefaultHighDModel<Row>
extends AbstractHighDModel<Row, String> {
    private final DataSource dataSource;
    private DataFrame<Row, String, Object> dataFrame;
    private DataFrame<?, String, ?> annotationDataFrame;
    private SubsetDataFrame<Row, String, Object> subsetDataFrame;
    private final Visual<Color, Row, String> visual;
    private final AxisHierarchy axisHierarchy;
    private final AxisHierarchy filtersAxisHierarchy;
    protected final MutableProperties<HighDModel.PropertyType> properties = new EnumProperties(HighDModel.PropertyType.class);
    private final MutableProperty<Boolean> showFiltered = this.properties.createProperty((Object)HighDModel.PropertyType.showFiltered, (Object)Boolean.FALSE);
    private final MutableProperty<Boolean> antialiasing = this.properties.createProperty((Object)HighDModel.PropertyType.antialiasing, (Object)Boolean.TRUE);
    private final MutableProperty<CPCanvas.Rendering> rendering = this.properties.createProperty((Object)HighDModel.PropertyType.rendering, (Object)CPCanvas.Rendering.AlphaBlended);
    private final MutableProperty<Geometry> geometry = this.properties.createProperty((Object)HighDModel.PropertyType.geometry, (Object)Geometry.Polylines);
    private final MutableProperty<InteractionMode> interactionMode = this.properties.createProperty((Object)HighDModel.PropertyType.interactionMode, (Object)InteractionMode.Filter);
    private final DefaultParallelCoordinatesModel parallelCoordinatesModel;
    private final Boolean isLogoVisible = Boolean.TRUE;

    public DefaultHighDModel(DataSource dataSource, DataFrame<Row, String, Object> dataFrame, Element defaultSettings) {
        this.dataSource = dataSource;
        this.dataFrame = dataFrame;
        if (dataFrame.getRowCount() >= 500) {
            this.rendering.setValue((Object)CPCanvas.Rendering.Density);
        }
        this.visual = new SimpleVisual((VisualObjects)new SimpleVisualObjects(dataFrame), (MutableColorMapping)new SimpleColorMapping((ColorMapFactory)SwingColorMapFactory.getInstance(), dataFrame));
        this.annotationDataFrame = new StatisticsDataFrame((CPFactory)SwingFactory.getInstance(), dataFrame, this.visual.getProbing(), this.visual.getSelection(), (Filter)this.visual.getFilter(), this.visual.getColorMapping(), this.visual.getColoring());
        this.subsetDataFrame = new SubsetDataFrame(dataFrame, this.visual.getFilter(), this.visual.getSelection());
        AxisFactory axisFactory = new AxisFactory((CPFactory)SwingFactory.getInstance(), dataFrame, this.subsetDataFrame, this.annotationDataFrame, (SingleSelection)this.visual.getProbing(), (Selection)this.visual.getSelection(), (MutableFilter)this.visual.getFilter());
        this.axisHierarchy = new DefaultAxisHierarchy(axisFactory, (CPFactory)SwingFactory.getInstance(), dataFrame, true, 10);
        this.filtersAxisHierarchy = new DefaultAxisHierarchy(axisFactory, (CPFactory)SwingFactory.getInstance(), dataFrame, false, 10);
        this.parallelCoordinatesModel = new DefaultParallelCoordinatesModel(dataFrame, this.visual, this.axisHierarchy, (ParallelCoordinatesSettings)new DefaultParallelCoordinatesSettings());
        if (defaultSettings != null) {
            this.load(defaultSettings);
        }
        if (dataSource != null && dataSource.getDocument(ApplicationModelFactory.HIGHD_V1) != null) {
            this.load(dataSource.getDocument(ApplicationModelFactory.HIGHD_V1).getRootElement());
        }
    }

    @Override
    public DataSource getDataSource() {
        return this.dataSource;
    }

    @Override
    public DataFrame<Row, String, Object> getDataFrame() {
        return this.dataFrame;
    }

    @Override
    public DataFrame<?, String, ?> getAnnotationDataFrame() {
        return this.annotationDataFrame;
    }

    @Override
    public SubsetDataFrame<Row, String, Object> getSubsetDataFrame() {
        return this.subsetDataFrame;
    }

    @Override
    public DefaultParallelCoordinatesModel<Color, Row, String> getParallelCoordinatesModel() {
        return this.parallelCoordinatesModel;
    }

    @Override
    public AxisHierarchy<Row, String> getAxisHierarchy() {
        return this.axisHierarchy;
    }

    @Override
    public AxisHierarchy<Row, String> getFiltersAxisHierarchy() {
        return this.filtersAxisHierarchy;
    }

    @Override
    public Visual<Color, Row, String> getVisual() {
        return this.visual;
    }

    @Override
    public MutableSingleSelection<Row> getProbing() {
        return this.visual.getProbing();
    }

    @Override
    public MutableSelection<Row> getSelection() {
        return this.visual.getSelection();
    }

    @Override
    public MutableFilter<Row> getFilter() {
        return this.visual.getFilter();
    }

    @Override
    public MutableColorMapping<Color, Row, String> getColorMapping() {
        return this.visual.getColorMapping();
    }

    @Override
    public MutableColoring<Color, Row> getColoring() {
        return this.visual.getColoring();
    }

    @Override
    public void load(Element root) {
        if (root.getLocalName().equals("High-D") || root.getLocalName().equals("ProfilePlot") || root.getLocalName().equals("ll-coords")) {
            Attribute versionAttribute = root.getAttribute("version");
            SimpleVersionModel version = versionAttribute != null ? new SimpleVersionModel(versionAttribute.getValue()) : new SimpleVersionModel(Integer.valueOf(1), Integer.valueOf(0), Integer.valueOf(0), Integer.valueOf(0));
            Elements children = root.getChildElements();
            for (int h = 0; h < children.size(); ++h) {
                AxisModel axisModel;
                int index;
                String name;
                String indexString;
                Element variable;
                int i;
                Element child = children.get(h);
                if (child.getLocalName().equals("Options")) {
                    Elements options = child.getChildElements();
                    for (i = 0; i < options.size(); ++i) {
                        Attribute visibleAttribute;
                        Element option = options.get(i);
                        if (!option.getLocalName().equals("Logo") || (visibleAttribute = option.getAttribute("visible")) == null) continue;
                        boolean bl = Boolean.valueOf(visibleAttribute.getValue());
                    }
                }
                if (child.getLocalName().equals("Settings")) {
                    String rendering;
                    String antialiasing;
                    String geometry;
                    String showFiltered = child.getAttributeValue(HighDModel.PropertyType.showFiltered.name());
                    if (showFiltered != null) {
                        this.setShowFiltered(Boolean.parseBoolean(showFiltered));
                    }
                    if ((geometry = child.getAttributeValue(HighDModel.PropertyType.geometry.name())) != null) {
                        this.setGeometry(Geometry.valueOf((String)geometry));
                    }
                    if ((antialiasing = child.getAttributeValue(HighDModel.PropertyType.antialiasing.name())) != null) {
                        this.getAntialiasing().setValue((Object)Boolean.parseBoolean(antialiasing));
                    }
                    if ((rendering = child.getAttributeValue(HighDModel.PropertyType.rendering.name())) != null) {
                        this.getRendering().setValue((Object)CPCanvas.Rendering.valueOf((String)rendering));
                    }
                }
                if (!child.getLocalName().equals("Variables")) continue;
                Elements variables = child.getChildElements();
                for (i = 0; i < variables.size(); ++i) {
                    AxisModel axisModel2;
                    String maximum;
                    AxisModel axisModel3;
                    String minimum;
                    variable = variables.get(i);
                    if (!variable.getLocalName().equals("Variable")) continue;
                    indexString = variable.getAttributeValue("index");
                    name = variable.getAttributeValue("name");
                    index = indexString != null ? Integer.parseInt(indexString) : this.dataFrame.getColumnAddress((Object)name);
                    if (index < 0) {
                        System.err.println("Could not find " + name);
                        continue;
                    }
                    String hidden = variable.getAttributeValue("hidden");
                    if (hidden != null && (axisModel = this.getAxisHierarchy().getAxisModel((Object)name)) != null) {
                        ((AxisGroupModel)this.getAxisHierarchy().getAxisGroupHierarchy().getRoot()).getAxisOrder().setVisible((Object)axisModel, !Boolean.parseBoolean(hidden));
                    }
                    if ((minimum = variable.getAttributeValue("min")) != null && (axisModel3 = this.getAxisHierarchy().getAxisModel((Object)name)) != null) {
                        axisModel3.setMinimum(Double.parseDouble(minimum));
                        axisModel3.getInterval().setValue(axisModel3.getMinimum(), axisModel3.getMaximum() - axisModel3.getMinimum());
                    }
                    if ((maximum = variable.getAttributeValue("max")) == null || (axisModel2 = this.getAxisHierarchy().getAxisModel((Object)name)) == null) continue;
                    axisModel2.setMaximum(Double.parseDouble(maximum));
                    axisModel2.getInterval().setValue(axisModel2.getMinimum(), axisModel2.getMaximum() - axisModel2.getMinimum());
                }
                for (i = 0; i < variables.size(); ++i) {
                    variable = variables.get(i);
                    if (!variable.getLocalName().equals("Variable")) continue;
                    indexString = variable.getAttributeValue("index");
                    name = variable.getAttributeValue("name");
                    index = indexString != null ? Integer.parseInt(indexString) : this.dataFrame.getColumnAddress((Object)name);
                    if (index < 0) {
                        System.err.println("Could not find " + name);
                        continue;
                    }
                    String location = variable.getAttributeValue("location");
                    if (location == null) continue;
                    axisModel = this.getAxisHierarchy().getAxisModel((Object)name);
                    if (axisModel != null) {
                        this.getParallelCoordinatesModel().getAxisLocations(this.getAxisHierarchy().getAxisGroup(axisModel)).setLocation(Alignment.Center, axisModel, Double.parseDouble(location));
                        continue;
                    }
                    System.err.println("Could not find " + name);
                }
            }
        }
    }

    @Override
    public void reload(Component contentPane) {
        try {
            this.dataFrame = new DefaultDataFrame((DataFrame)this.dataSource.getOriginalDataSource().loadDataFrame(contentPane));
            this.getParallelCoordinatesModel().setDataFrame(this.dataFrame);
            if (this.dataSource.getDocument(ApplicationModelFactory.HIGHD_V1) != null) {
                this.load(this.dataSource.getDocument(ApplicationModelFactory.HIGHD_V1).getRootElement());
            }
        }
        catch (IOException e) {
            Logging.getInstance().process((Throwable)e);
        }
        catch (SQLException e) {
            Logging.getInstance().process((Throwable)e);
        }
    }

    @Override
    public void save(File file, Element root) {
        if (this.dataSource != null && this.dataSource.getOriginalDataSource() != null) {
            this.dataSource.getOriginalDataSource().save(file, root);
        }
        Element options = new Element("Options");
        Element logoElement = new Element("Logo");
        logoElement.addAttribute(new Attribute("visible", Boolean.toString(this.isLogoVisible)));
        options.appendChild((Node)logoElement);
        root.appendChild((Node)options);
        Element settings = new Element("Settings");
        this.saveGeneralSettings(settings);
        root.appendChild((Node)settings);
        Element variables = new Element("Variables");
        for (AxisGroupModel axisGroup : this.getAxisHierarchy().getAxisGroupHierarchy().breadthFirstIterator()) {
            for (AxisModel axisModel : axisGroup.getAxisModels()) {
                String c = (String)axisModel.getColumn();
                Element variableElement = new Element("Variable");
                variableElement.addAttribute(new Attribute("index", Integer.toString(this.getDataFrame().getColumnAddress((Object)c))));
                variableElement.addAttribute(new Attribute("name", this.getDataFrame().getColumnName((Object)c)));
                variableElement.addAttribute(new Attribute("hidden", Boolean.toString(this.getParallelCoordinatesModel().isHidden(axisModel))));
                Double location = this.getParallelCoordinatesModel().getAxisLocations(this.getAxisHierarchy().getAxisGroup(axisModel)).getLocation(Alignment.Center, axisModel);
                if (location != null) {
                    variableElement.addAttribute(new Attribute("location", Double.toString(location)));
                }
                variableElement.addAttribute(new Attribute("min", Double.toString(axisModel.getMinimum())));
                variableElement.addAttribute(new Attribute("max", Double.toString(axisModel.getMaximum())));
                variables.appendChild((Node)variableElement);
            }
        }
        root.appendChild((Node)variables);
    }

    private void saveGeneralSettings(Element root) {
        HighDModel.PropertyType[] keys;
        for (HighDModel.PropertyType key : keys = new HighDModel.PropertyType[]{HighDModel.PropertyType.showFiltered, HighDModel.PropertyType.geometry, HighDModel.PropertyType.antialiasing, HighDModel.PropertyType.rendering}) {
            Object value = this.getValue(key);
            if (value == null) continue;
            Object stringValue = null;
            if (value instanceof String) {
                stringValue = (String)value;
            } else if (value instanceof Boolean) {
                stringValue = Boolean.toString((Boolean)value);
            } else if (value instanceof Integer) {
                stringValue = Integer.toString((Integer)value);
            } else if (value instanceof Float) {
                stringValue = Float.toString(((Float)value).floatValue());
            } else if (value instanceof Double) {
                stringValue = Double.toString((Double)value);
            } else if (value instanceof Color) {
                stringValue = ColorHelper.getHTMLColor((Color)((Color)value));
            } else if (value instanceof Font) {
                stringValue = FontHelper.encode((Font)((Font)value));
            } else if (value instanceof Dimension) {
                Dimension dimension = (Dimension)value;
                stringValue = dimension.width + "; " + dimension.height;
            } else {
                stringValue = value.toString();
            }
            if (stringValue == null) continue;
            root.addAttribute(new Attribute(key.name(), (String)stringValue));
        }
    }

    private Object getValue(HighDModel.PropertyType key) {
        if (this.properties.getProperty((Object)key) != null) {
            return this.properties.getValue((Object)key);
        }
        throw new UnsupportedOperationException("Key " + String.valueOf((Object)key) + " unknonw");
    }

    @Override
    public MutableProperties getProperties() {
        return this.properties;
    }

    private void setShowFiltered(boolean show) {
        this.showFiltered.setValue((Object)show);
    }

    private void setGeometry(Geometry geometry) {
        this.geometry.setValue((Object)geometry);
    }

    @Override
    public MutableProperty<Boolean> getShowFiltered() {
        return this.showFiltered;
    }

    @Override
    public MutableProperty<CPCanvas.Rendering> getRendering() {
        return this.rendering;
    }

    @Override
    public MutableProperty<Boolean> getAntialiasing() {
        return this.antialiasing;
    }

    @Override
    public MutableProperty<Geometry> getGeometry() {
        return this.geometry;
    }

    @Override
    public MutableProperty<InteractionMode> getInteractionMode() {
        return this.interactionMode;
    }
}

