/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.application.high_d.settings;

import com.jidesoft.grid.AutoResizePopupMenuCustomizer;
import com.jidesoft.grid.TableColumnChooser;
import com.jidesoft.grid.TableColumnChooserPopupMenuCustomizer;
import com.jidesoft.grid.TableHeaderPopupMenuCustomizer;
import com.jidesoft.grid.TableHeaderPopupMenuInstaller;
import com.macrofocus.application.high_d.view.table.RowStripeTable;
import com.macrofocus.common.scale.Transform;
import com.macrofocus.high_d.HighDFactory;
import com.macrofocus.high_d.axis.AxisListener;
import com.macrofocus.high_d.axis.AxisModel;
import com.macrofocus.high_d.axis.group.AxisGroupModel;
import com.macrofocus.order.OrderEvent;
import com.macrofocus.order.OrderListener;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragSource;
import javax.activation.ActivationDataFlavor;
import javax.activation.DataHandler;
import javax.swing.DropMode;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.TransferHandler;
import javax.swing.table.AbstractTableModel;

public class SwingAxesTable<Row, Column>
extends RowStripeTable {
    private HighDFactory<?, ?, ?, ?, Row, Column, ?> factory;

    public SwingAxesTable() {
        this.setShowGrid(false);
        this.setIntercellSpacing(new Dimension(0, 0));
        this.setAutoResizeMode(4);
        this.setFillsSelection(true);
        this.setCellSelectionEnabled(false);
        this.setColumnSelectionAllowed(false);
        this.setRowSelectionAllowed(true);
        this.setDragEnabled(true);
        this.setDropMode(DropMode.INSERT_ROWS);
        this.setTransferHandler(new TableRowTransferHandler((JTable)((Object)this)));
        this.getSelectionModel().setSelectionMode(2);
        this.setLoadSelectionOnTableDataChanged(true);
        TableHeaderPopupMenuInstaller installer = new TableHeaderPopupMenuInstaller((JTable)((Object)this));
        installer.addTableHeaderPopupMenuCustomizer((TableHeaderPopupMenuCustomizer)new AutoResizePopupMenuCustomizer());
        installer.addTableHeaderPopupMenuCustomizer((TableHeaderPopupMenuCustomizer)new TableColumnChooserPopupMenuCustomizer());
    }

    public void setModel(HighDFactory<?, ?, ?, ?, Row, Column, ?> factory) {
        if (this.factory != null) {
            // empty if block
        }
        this.factory = factory;
        if (this.factory != null) {
            this.setModel(new AxisTableModel(factory));
            this.getColumnModel().getColumn(0).setPreferredWidth(20);
            this.getColumnModel().getColumn(1).setPreferredWidth(20);
            this.getColumnModel().getColumn(2).setPreferredWidth(20);
            TableColumnChooser.hideColumn((JTable)((Object)this), (int)0);
            TableColumnChooser.hideColumn((JTable)((Object)this), (int)2);
            TableColumnChooser.hideColumn((JTable)((Object)this), (int)4);
            TableColumnChooser.hideColumn((JTable)((Object)this), (int)5);
            TableColumnChooser.hideColumn((JTable)((Object)this), (int)6);
            TableColumnChooser.hideColumn((JTable)((Object)this), (int)7);
            TableColumnChooser.hideColumn((JTable)((Object)this), (int)8);
            TableColumnChooser.hideColumn((JTable)((Object)this), (int)9);
            TableColumnChooser.hideColumn((JTable)((Object)this), (int)10);
        }
    }

    public class TableRowTransferHandler
    extends TransferHandler {
        private final DataFlavor localObjectFlavor = new ActivationDataFlavor(Integer.class, "Integer Row Index");
        private JTable table = null;

        public TableRowTransferHandler(JTable table) {
            this.table = table;
        }

        @Override
        protected Transferable createTransferable(JComponent c) {
            assert (c == this.table);
            return new DataHandler((Object)this.table.getSelectedRow(), this.localObjectFlavor.getMimeType());
        }

        @Override
        public boolean canImport(TransferHandler.TransferSupport info) {
            boolean b = info.getComponent() == this.table && info.isDrop() && info.isDataFlavorSupported(this.localObjectFlavor);
            this.table.setCursor(b ? DragSource.DefaultMoveDrop : DragSource.DefaultMoveNoDrop);
            return b;
        }

        @Override
        public int getSourceActions(JComponent c) {
            return 3;
        }

        @Override
        public boolean importData(TransferHandler.TransferSupport info) {
            JTable target = (JTable)info.getComponent();
            JTable.DropLocation dl = (JTable.DropLocation)info.getDropLocation();
            int index = dl.getRow();
            int max = this.table.getModel().getRowCount();
            if (index < 0 || index > max) {
                index = max;
            }
            target.setCursor(Cursor.getPredefinedCursor(0));
            try {
                Integer rowFrom = (Integer)info.getTransferable().getTransferData(this.localObjectFlavor);
                if (rowFrom != -1 && rowFrom != index) {
                    ((Reorderable)((Object)this.table.getModel())).reorder(rowFrom, index);
                    if (index > rowFrom) {
                        --index;
                    }
                    target.getSelectionModel().addSelectionInterval(index, index);
                    return true;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return false;
        }

        @Override
        protected void exportDone(JComponent c, Transferable t, int act) {
            if (act == 2) {
                this.table.setCursor(Cursor.getPredefinedCursor(0));
            }
        }
    }

    private class AxisTableModel
    extends AbstractTableModel
    implements Reorderable {
        private final HighDFactory<?, ?, ?, ?, Row, Column, ?> factory;
        final AxisListener axisListener = new AxisListener(){

            public void axisChanged() {
                AxisTableModel.this.fireTableDataChanged();
            }
        };
        private final OrderListener<AxisModel<Row, Column>> orderListener = new OrderListener<AxisModel<Row, Column>>(){

            public void orderChanged(OrderEvent<AxisModel<Row, Column>> event) {
                AxisTableModel.this.fireTableDataChanged();
            }

            public void orderVisibility(OrderEvent<AxisModel<Row, Column>> event) {
                AxisTableModel.this.fireTableDataChanged();
            }

            public void orderAdded(OrderEvent<AxisModel<Row, Column>> event) {
                AxisTableModel.this.fireTableDataChanged();
            }

            public void orderRemoved(OrderEvent<AxisModel<Row, Column>> event) {
                AxisTableModel.this.fireTableDataChanged();
            }
        };

        private AxisTableModel(HighDFactory<?, ?, ?, ?, Row, Column, ?> factory) {
            this.factory = factory;
            ((AxisGroupModel)factory.getAxisHierarchy().getAxisGroupHierarchy().getRoot()).addAxisListener(this.axisListener);
            ((AxisGroupModel)factory.getAxisHierarchy().getAxisGroupHierarchy().getRoot()).getAxisOrder().addOrderListener(this.orderListener);
            ((AxisGroupModel)factory.getFiltersAxisHierarchy().getAxisGroupHierarchy().getRoot()).addAxisListener(this.axisListener);
            ((AxisGroupModel)factory.getFiltersAxisHierarchy().getAxisGroupHierarchy().getRoot()).getAxisOrder().addOrderListener(this.orderListener);
        }

        @Override
        public int getRowCount() {
            return ((AxisGroupModel)this.factory.getAxisHierarchy().getAxisGroupHierarchy().getRoot()).getAxisOrder().sizeAll();
        }

        @Override
        public int getColumnCount() {
            return 11;
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return "Categories";
                }
                case 1: {
                    return "Visualizations";
                }
                case 2: {
                    return "Table";
                }
                case 3: {
                    return "Variable";
                }
                case 4: {
                    return "Minimum";
                }
                case 5: {
                    return "Maximum";
                }
                case 6: {
                    return "Start";
                }
                case 7: {
                    return "End";
                }
                case 8: {
                    return "Type of binning";
                }
                case 9: {
                    return "Number of bins";
                }
                case 10: {
                    return "Scale transform";
                }
            }
            return null;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return Boolean.class;
                }
                case 1: {
                    return Boolean.class;
                }
                case 2: {
                    return Boolean.class;
                }
                case 3: {
                    return String.class;
                }
                case 4: {
                    return Double.class;
                }
                case 5: {
                    return Double.class;
                }
                case 6: {
                    return Double.class;
                }
                case 7: {
                    return Double.class;
                }
                case 8: {
                    return AxisModel.BinType.class;
                }
                case 9: {
                    return Integer.class;
                }
                case 10: {
                    return Transform.class;
                }
            }
            return null;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            AxisModel axisModel = (AxisModel)((AxisGroupModel)this.factory.getAxisHierarchy().getAxisGroupHierarchy().getRoot()).getAxisOrder().getAll(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return true;
                }
                case 1: {
                    return true;
                }
                case 2: {
                    return false;
                }
                case 3: {
                    return false;
                }
                case 4: {
                    return axisModel.isNumerical();
                }
                case 5: {
                    return axisModel.isNumerical();
                }
                case 6: {
                    return axisModel.isNumerical();
                }
                case 7: {
                    return axisModel.isNumerical();
                }
                case 8: {
                    return axisModel.isNumerical();
                }
                case 9: {
                    return axisModel.isNumerical();
                }
                case 10: {
                    return axisModel.isNumerical();
                }
            }
            return false;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            AxisGroupModel root = (AxisGroupModel)this.factory.getAxisHierarchy().getAxisGroupHierarchy().getRoot();
            AxisModel axisModel = (AxisModel)root.getAxisOrder().getAll(rowIndex);
            switch (columnIndex) {
                case 0: {
                    AxisGroupModel categories = (AxisGroupModel)this.factory.getFiltersAxisHierarchy().getAxisGroupHierarchy().getRoot();
                    categories.getAxisOrder().setVisible((Object)axisModel, ((Boolean)aValue).booleanValue());
                    break;
                }
                case 1: {
                    root.getAxisOrder().setVisible((Object)axisModel, ((Boolean)aValue).booleanValue());
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    axisModel.setMinimum(((Number)aValue).doubleValue());
                    break;
                }
                case 5: {
                    axisModel.setMaximum(((Number)aValue).doubleValue());
                    break;
                }
                case 6: {
                    axisModel.getInterval().setStart(((Number)aValue).doubleValue());
                    break;
                }
                case 7: {
                    axisModel.getInterval().setEnd(((Number)aValue).doubleValue());
                    break;
                }
                case 8: {
                    axisModel.getBinType().setValue((Object)((AxisModel.BinType)aValue));
                    break;
                }
                case 9: {
                    axisModel.getBinCount().setValue((Object)((Number)aValue).intValue());
                    break;
                }
                case 10: {
                    axisModel.getScale().setValue((Object)((Transform)aValue));
                    break;
                }
            }
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            AxisGroupModel visualizations = (AxisGroupModel)this.factory.getAxisHierarchy().getAxisGroupHierarchy().getRoot();
            AxisModel axisModel = (AxisModel)visualizations.getAxisOrder().getAll(rowIndex);
            switch (columnIndex) {
                case 0: {
                    AxisGroupModel categories = (AxisGroupModel)this.factory.getFiltersAxisHierarchy().getAxisGroupHierarchy().getRoot();
                    return categories.getAxisOrder().isVisible((Object)axisModel);
                }
                case 1: {
                    return visualizations.getAxisOrder().isVisible((Object)axisModel);
                }
                case 2: {
                    return true;
                }
                case 3: {
                    return axisModel.getName();
                }
                case 4: {
                    return axisModel.isNumerical() ? Double.valueOf(axisModel.getMinimum()) : null;
                }
                case 5: {
                    return axisModel.isNumerical() ? Double.valueOf(axisModel.getMaximum()) : null;
                }
                case 6: {
                    return axisModel.isNumerical() ? Double.valueOf(axisModel.getInterval().getStart()) : null;
                }
                case 7: {
                    return axisModel.isNumerical() ? Double.valueOf(axisModel.getInterval().getEnd()) : null;
                }
                case 8: {
                    return axisModel.isNumerical() ? axisModel.getBinType().getValue() : null;
                }
                case 9: {
                    return axisModel.isNumerical() ? (Integer)axisModel.getBinCount().getValue() : null;
                }
                case 10: {
                    return axisModel.isNumerical() ? axisModel.getScale().getValue() : null;
                }
            }
            return null;
        }

        @Override
        public void reorder(int fromIndex, int toIndex) {
            System.err.println("Reorder " + fromIndex + " -> " + toIndex);
        }
    }

    private static interface Reorderable {
        public void reorder(int var1, int var2);
    }
}

