/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.application.high_d.swing;

import com.macrofocus.application.document.OpenDocumentException;
import com.macrofocus.application.document.View;
import com.macrofocus.application.high_d.document.HighDView;
import com.macrofocus.application.high_d.document.JavaHighDDocument;
import com.macrofocus.application.high_d.document.swing.SwingHighDApplication;
import com.macrofocus.application.high_d.document.swing.SwingHighDView;
import com.macrofocus.application.window.CPWindow;
import com.macrofocus.util.file.FileHelper;
import com.macrofocus.util.swing.export.format.AbstractRasterExportFormat;
import com.macrofocus.util.swing.export.format.ContentProvider;
import com.macrofocus.util.swing.export.format.DefaultContentProvider;
import com.macrofocus.util.swing.export.format.ExportFormat;
import com.macrofocus.util.swing.export.format.PNGExportFormat;
import com.macrofocus.util.swing.export.format.TIFFExportFormat;
import com.macrofocus.util.swing.export.format.WebPExportFormat;
import com.macrofocus.util.swing.export.format.XMLGraphicsPDFExportFormat;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

public class ScreenShotsHelper {
    private static final AbstractRasterExportFormat[] rasterExportFormats = new AbstractRasterExportFormat[]{new PNGExportFormat(), new TIFFExportFormat(), new WebPExportFormat()};
    private static final ExportFormat[] vectorExportFormats = new ExportFormat[]{new XMLGraphicsPDFExportFormat()};
    static final AbstractRasterExportFormat[] documentationExportFormats = new AbstractRasterExportFormat[]{new PNGExportFormat()};

    public static void takeScreenShot(final File output, final String name, final SwingHighDApplication application, final HighDView view) {
        application.waitUntilReady();
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    for (AbstractRasterExportFormat abstractRasterExportFormat : rasterExportFormats) {
                        ScreenShotsHelper.saveImage(abstractRasterExportFormat, application, view, name, output, 32.4f);
                        ScreenShotsHelper.saveImage(abstractRasterExportFormat, application, view, name, output, abstractRasterExportFormat.getScreenDPI());
                        ScreenShotsHelper.saveImage(abstractRasterExportFormat, application, view, name, output, 300.0f);
                        ScreenShotsHelper.saveImage(abstractRasterExportFormat, application, view, name, output, 600.0f);
                    }
                    for (AbstractRasterExportFormat abstractRasterExportFormat : vectorExportFormats) {
                        ScreenShotsHelper.saveImage((ExportFormat<Component>)abstractRasterExportFormat, application, view, name, output);
                    }
                }
            });
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    private static void saveImage(AbstractRasterExportFormat exportFormat, SwingHighDApplication application, HighDView view, String name, File output, float dpi) {
        File destination;
        exportFormat.setOutputDPI(dpi);
        String dpiString = Integer.toString((int)dpi);
        try {
            destination = new File(output, "application/" + dpiString + "dpi");
            if (!destination.exists()) {
                destination.mkdirs();
            }
            exportFormat.save((ContentProvider)new DefaultContentProvider((Object)((Component)application.getApplicationState().getWindow((View)view).getNativeComponent())), new File(destination, name + "-" + dpiString + "dpi." + exportFormat.getFileFilter().getDefaultExtension()));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            destination = new File(output, "high-d/" + dpiString + "dpi");
            if (!destination.exists()) {
                destination.mkdirs();
            }
            exportFormat.save((ContentProvider)new DefaultContentProvider((Object)((Component)((SwingHighDView)view).getNativeComponent())), new File(destination, name + "-highd-" + dpiString + "dpi." + exportFormat.getFileFilter().getDefaultExtension()));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void saveImage(ExportFormat<Component> exportFormat, SwingHighDApplication application, HighDView view, String name, File output) {
        try {
            File destination = new File(output, "high-d");
            if (!destination.exists()) {
                destination.mkdirs();
            }
            exportFormat.save((ContentProvider)new DefaultContentProvider((Object)((Component)((SwingHighDView)view).getNativeComponent())), new File(destination, name + "-highd." + exportFormat.getFileFilter().getDefaultExtension()));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    static void close(SwingHighDApplication application, HighDView view) {
        application.closeView(view);
    }

    static HighDView open(File dataset, SwingHighDApplication application) {
        try {
            JavaHighDDocument document = application.openLocalDocument(dataset, dataset.getName(), null);
            CPWindow<JFrame, JComponent> window = application.createWindow();
            HighDView<JComponent, JavaHighDDocument> view = application.createView((JFrame)window.getNativeWindow(), document);
            application.setup(window, view);
            view.waitUntilReady();
            return view;
        }
        catch (OpenDocumentException e) {
            e.printStackTrace();
            return null;
        }
    }

    static void saveForDocumentation(SwingHighDApplication application, File file, Component component) {
        application.waitUntilReady();
        for (AbstractRasterExportFormat exportFormat : documentationExportFormats) {
            try {
                System.err.println(component);
                exportFormat.setOutputDPI(exportFormat.getScreenDPI());
                System.out.println("Saving " + String.valueOf(file));
                exportFormat.save((ContentProvider)new DefaultContentProvider((Object)component), FileHelper.replaceSuffix((File)file, (String)exportFormat.getFileFilter().getDefaultExtension()));
                System.out.println(exportFormat.getScreenDPI() + ", " + exportFormat.getOutputDPI());
                exportFormat.setOutputDPI(exportFormat.getScreenDPI() * 2.0f);
                System.out.println(exportFormat.getScreenDPI() + ", " + exportFormat.getOutputDPI());
                exportFormat.save((ContentProvider)new DefaultContentProvider((Object)component), FileHelper.replaceSuffix((File)new File(file.getParentFile(), file.getName() + "@2x"), (String)exportFormat.getFileFilter().getDefaultExtension()));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

