/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.application.high_d.document;

import com.macrofocus.application.document.DocumentBasedApplication;
import com.macrofocus.application.document.View;
import com.macrofocus.application.high_d.document.AbstractHighDView;
import com.macrofocus.application.high_d.document.JavaHighDApplication;
import com.macrofocus.application.high_d.document.JavaHighDDocument;
import com.macrofocus.application.high_d.document.NewFromClipboardCommand;
import com.macrofocus.application.high_d.document.OpenDatabaseCommand;
import com.macrofocus.application.high_d.document.OpenDirectoryCommand;
import com.macrofocus.application.high_d.document.OpenGoogleSpreadsheetCommand;
import com.macrofocus.application.high_d.document.PopulateOpenDatasetCommand;
import com.macrofocus.application.menu.CPMenu;
import com.macrofocus.application.properties.DocumentBasedApplicationProperties;
import com.macrofocus.application.window.CPWindow;
import com.macrofocus.common.command.Command;
import com.macrofocus.common.command.UICommand;
import com.macrofocus.docking.DockingFactory;
import com.macrofocus.high_d.HighDFactory;
import com.macrofocus.table.TableFactory;
import java.util.List;

public abstract class JavaHighDView<Window, Component, Color, Font, Format>
extends AbstractHighDView<Component, Color, Font, Format, JavaHighDDocument> {
    public JavaHighDView(HighDFactory<Component, Color, Font, Format, Integer, String, Object> hdFactory, DockingFactory<Component> dockingFactory, TableFactory<Component, Color> tableFactory, DocumentBasedApplicationProperties properties) {
        super(hdFactory, dockingFactory, tableFactory, properties);
    }

    public abstract JavaHighDApplication<Window, Component, ?, JavaHighDDocument> getApplication();

    public void customizeFileNew(CPMenu<Component> fileMenu) {
        CPWindow window = this.getApplication().getApplicationState().getWindow((View)this);
        fileMenu.addAction(new NewFromClipboardCommand<Window>(this.getApplication(), window));
    }

    public void customizeFileOpen(CPMenu<Component> fileMenu) {
        CPWindow window = this.getApplication().getApplicationState().getWindow((View)this);
        fileMenu.addAction("Open Database...", null, new OpenDatabaseCommand(this.getApplication(), window));
        fileMenu.addAction("Open Directory...", null, new OpenDirectoryCommand<Window, Component>(this.getApplication(), window));
        fileMenu.addAction("Open Google Spreadsheet...", null, new OpenGoogleSpreadsheetCommand(this.getApplication(), window));
        final CPMenu onlineMenu = fileMenu.addMenu("Open Dataset");
        String servers = (String)this.getApplication().getResourcesModel().getPropertiesModel().getValue("high-d.servers");
        if (servers != null) {
            for (final String server : servers.split(",")) {
                this.getApplication().runAsyncBackground(new PopulateOpenDatasetCommand<Window, Component>(this.getApplication(), window, server), new DocumentBasedApplication.Callback<PopulateOpenDatasetCommand<Window, Component>, Object>(){

                    public Object execute(final PopulateOpenDatasetCommand<Window, Component> arg) {
                        JavaHighDView.this.getApplication().runAsyncUIThread(new Command(){

                            public void execute() {
                                List<UICommand> commands = arg.getCommands();
                                if (commands != null && commands.size() > 0) {
                                    CPMenu serverMenu = onlineMenu.addMenu(server);
                                    for (UICommand command : commands) {
                                        serverMenu.addAction(command);
                                    }
                                }
                            }
                        });
                        return null;
                    }
                });
            }
        }
    }
}

