/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.application.high_d.document;

import com.macrofocus.application.document.DocumentOpener;
import com.macrofocus.application.document.OpenDocumentException;
import com.macrofocus.application.high_d.document.HighDDocument;
import com.macrofocus.application.high_d.document.JavaHighDApplication;
import com.macrofocus.application.window.CPWindow;
import com.macrofocus.common.command.Command;
import com.macrofocus.data.db.OpenDatabaseDialog;
import com.macrofocus.data.source.DataSource;
import com.macrofocus.data.source.JDBCDataSource;
import com.macrofocus.molap.dataframe.MutableDataFrame;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class OpenDatabaseCommand<Window, Component>
implements Command {
    private final JavaHighDApplication application;
    private final CPWindow window;
    OpenDatabaseDialog dialog;
    JComponent contentPane = null;

    public OpenDatabaseCommand(JavaHighDApplication application, CPWindow window) {
        this.application = application;
        this.window = window;
    }

    public void execute() {
        if (this.dialog == null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    OpenDatabaseCommand.this.dialog = new OpenDatabaseDialog();
                    AbstractAction action = new AbstractAction(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            new Thread(new Runnable(){

                                @Override
                                public void run() {
                                    if (OpenDatabaseCommand.this.contentPane != null) {
                                        SwingUtilities.invokeLater(new Runnable(){

                                            @Override
                                            public void run() {
                                                OpenDatabaseCommand.this.contentPane.setCursor(new Cursor(3));
                                            }
                                        });
                                    }
                                    char[] chars = OpenDatabaseCommand.this.dialog.getPassword();
                                    String password = new String(chars);
                                    final String url = OpenDatabaseCommand.this.dialog.getURL();
                                    final JDBCDataSource dataSource = new JDBCDataSource(OpenDatabaseCommand.this.dialog.getDatabaseDriver(), url, OpenDatabaseCommand.this.dialog.getUsername(), password, OpenDatabaseCommand.this.dialog.getQuery());
                                    DocumentOpener documentOpener = new DocumentOpener<HighDDocument, Window, Component>(){

                                        public HighDDocument openDocument(CPWindow window) throws OpenDocumentException {
                                            try {
                                                MutableDataFrame dataFrame = dataSource.loadDataFrame(null);
                                                HighDDocument document = OpenDatabaseCommand.this.application.createDocument(url, url, (DataSource)dataSource, (MutableDataFrame<Integer, String, Object>)dataFrame);
                                                return document;
                                            }
                                            catch (Exception e) {
                                                throw new OpenDocumentException("Error", (Throwable)e);
                                            }
                                        }
                                    };
                                    OpenDatabaseCommand.this.application.openAndShowDocument(OpenDatabaseCommand.this.window, documentOpener, null);
                                    OpenDatabaseCommand.this.dialog.setVisible(false);
                                    if (OpenDatabaseCommand.this.contentPane != null) {
                                        SwingUtilities.invokeLater(new Runnable(){

                                            @Override
                                            public void run() {
                                                OpenDatabaseCommand.this.contentPane.setCursor(new Cursor(0));
                                            }
                                        });
                                    }
                                }
                            }).start();
                        }
                    };
                    OpenDatabaseCommand.this.dialog.setAction((Action)action);
                    OpenDatabaseCommand.this.dialog.setModal(true);
                    OpenDatabaseCommand.this.dialog.pack();
                    OpenDatabaseCommand.this.dialog.setLocationRelativeTo((Component)OpenDatabaseCommand.this.contentPane);
                    OpenDatabaseCommand.this.dialog.setVisible(true);
                }
            });
        } else {
            this.dialog.setVisible(true);
        }
    }
}

