/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.application.high_d.document;

import com.macrofocus.application.document.AbstractView;
import com.macrofocus.application.high_d.document.AxesPanel;
import com.macrofocus.application.high_d.document.HighDConfigurationPanel;
import com.macrofocus.application.high_d.document.HighDDocument;
import com.macrofocus.application.high_d.document.HighDView;
import com.macrofocus.application.menu.CPMenu;
import com.macrofocus.application.menu.CPMenuBar;
import com.macrofocus.application.properties.DocumentBasedApplicationProperties;
import com.macrofocus.application.status.CPStatusBar;
import com.macrofocus.application.window.CPWindow;
import com.macrofocus.cartoplot.CartoPlot;
import com.macrofocus.common.command.Command;
import com.macrofocus.common.properties.MutableProperty;
import com.macrofocus.common.properties.Property;
import com.macrofocus.common.properties.PropertyEvent;
import com.macrofocus.common.properties.PropertyListener;
import com.macrofocus.common.properties.SimpleProperty;
import com.macrofocus.common.selection.SelectionEvent;
import com.macrofocus.common.selection.SelectionListener;
import com.macrofocus.common.selection.SingleSelectionEvent;
import com.macrofocus.common.selection.SingleSelectionListener;
import com.macrofocus.crossplatform.CPButton;
import com.macrofocus.crossplatform.CPCanvas;
import com.macrofocus.crossplatform.CPColorButton;
import com.macrofocus.crossplatform.CPComponent;
import com.macrofocus.crossplatform.CPFactory;
import com.macrofocus.crossplatform.CPHorizontalFlowPanel;
import com.macrofocus.docking.AttachAnchor;
import com.macrofocus.docking.Dockable;
import com.macrofocus.docking.DockingFactory;
import com.macrofocus.docking.DockingPanel;
import com.macrofocus.filter.FilterEvent;
import com.macrofocus.filter.FilterListener;
import com.macrofocus.high_d.HighDFactory;
import com.macrofocus.high_d.axis.Alignment;
import com.macrofocus.high_d.axis.AxisModel;
import com.macrofocus.high_d.axis.group.AxisGroupModel;
import com.macrofocus.high_d.clustering.Clustering;
import com.macrofocus.high_d.command.ResetFiltersCommand;
import com.macrofocus.high_d.filters.Filters;
import com.macrofocus.high_d.interaction.InteractionMode;
import com.macrofocus.high_d.mds.AbstractMDSPanel;
import com.macrofocus.high_d.mds.MDS;
import com.macrofocus.high_d.mds.MDSPanel;
import com.macrofocus.high_d.parallelcoordinates.ParallelCoordinates;
import com.macrofocus.high_d.parallelcoordinates.ParallelCoordinatesModel;
import com.macrofocus.high_d.parallelcoordinates.geometry.Geometry;
import com.macrofocus.high_d.scatterplot.ScatterPlot;
import com.macrofocus.high_d.scatterplot.ScatterPlotPanel;
import com.macrofocus.high_d.tablelens.TableLens;
import com.macrofocus.igraphics.CPColor;
import com.macrofocus.igraphics.colortheme.ColorTheme;
import com.macrofocus.igraphics.colortheme.DarkColorTheme;
import com.macrofocus.igraphics.colortheme.LightColorTheme;
import com.macrofocus.table.TableFactory;
import com.macrofocus.timer.CPTimer;
import com.macrofocus.timer.CPTimerListener;
import com.macrofocus.visual.Visual;
import java.util.ArrayList;

public abstract class AbstractHighDView<Component, Color, Font, Format, D extends HighDDocument>
extends AbstractView<Component, D>
implements HighDView<Component, D> {
    private final ColorTheme<Color> lightColorTheme;
    private final ColorTheme<Color> darkColorTheme;
    private final MutableProperty<ColorTheme<Color>> colorTheme;
    private final DocumentBasedApplicationProperties properties;
    private final Component nativeComponent;
    private D document;
    protected final CPFactory<Component, Font, ?, Color> factory;
    protected final HighDFactory<Component, Color, Font, Format, Integer, String, Object> hdFactory;
    private final DockingFactory<Component> dockingFactory;
    protected final TableFactory<Component, Color> tableFactory;
    private ParallelCoordinates<Component, Color, Integer, String> parallelCoordinates;
    private Filters<Component, Color, Integer, String, ?> filters;
    private DockingPanel<Component> dockingPanel;
    private DockingPanel<Component> innerDockingPanel;
    private DockingPanel<Component> northDockingPanel;
    protected Dockable<Component> scatterPlotDockable;

    public AbstractHighDView(HighDFactory<Component, Color, Font, Format, Integer, String, Object> hdFactory, DockingFactory<Component> dockingFactory, TableFactory<Component, Color> tableFactory, DocumentBasedApplicationProperties properties) {
        this.factory = hdFactory.getCPFactory();
        this.hdFactory = hdFactory;
        this.dockingFactory = dockingFactory;
        this.tableFactory = tableFactory;
        this.properties = properties;
        this.lightColorTheme = new LightColorTheme(this.factory);
        this.darkColorTheme = new DarkColorTheme(this.factory);
        this.colorTheme = new SimpleProperty(this.lightColorTheme);
        this.dockingPanel = dockingFactory.createDockingPanel(false);
        this.dockingPanel.setHorizontalFirstDividerSize(250.0);
        this.innerDockingPanel = dockingFactory.createDockingPanel(false);
        this.innerDockingPanel.setVerticalLastDividerSize(335.0);
        this.dockingPanel.setInnerComponent(this.innerDockingPanel.getNativeComponent());
        this.northDockingPanel = dockingFactory.createDockingPanel(false);
        this.northDockingPanel.setOrientation(false);
        this.northDockingPanel.setHorizontalLastDividerSize(250.0);
        this.innerDockingPanel.setInnerComponent(this.northDockingPanel.getNativeComponent());
        this.nativeComponent = this.dockingPanel.getNativeComponent();
    }

    public void init() {
    }

    public DocumentBasedApplicationProperties getProperties() {
        return this.properties;
    }

    public void setDocument(D document) {
        if (this.document != document) {
            this.document = document;
            try {
                MDS mds;
                this.hdFactory.setSettings(((HighDDocument)((Object)document)).getSettings());
                this.hdFactory.setDataFrame(((HighDDocument)((Object)document)).getDataFrame(), ((HighDDocument)((Object)document)).getSubsetDataFrame(), ((HighDDocument)((Object)document)).getAnnotationDataFrame(), ((HighDDocument)((Object)document)).getVisual(), ((HighDDocument)((Object)document)).getAxisHierarchy(), ((HighDDocument)((Object)document)).getFiltersAxisHierarchy());
                this.hdFactory.setColorTheme(this.colorTheme);
                if (this.hdFactory.getDataFrame().getRowCount() >= 500) {
                    this.hdFactory.getRendering().setValue((Object)CPCanvas.Rendering.Density);
                } else {
                    this.hdFactory.getRendering().setValue((Object)CPCanvas.Rendering.AlphaBlended);
                }
                this.parallelCoordinates = this.hdFactory.createParallelCoordinates();
                this.parallelCoordinates.setModel((ParallelCoordinatesModel)((HighDDocument)((Object)document)).getParallelCoordinatesModel());
                ParallelCoordinatesModel model = this.parallelCoordinates.getModel();
                this.parallelCoordinates.getView().setShowTiming(false);
                this.parallelCoordinates.getView().getAlignment().setValue((Object)Alignment.Center);
                TableLens tableLens = this.hdFactory.createTableLens();
                this.filters = this.hdFactory.createFilters();
                try {
                    this.dockingPanel.attach(this.dockingPanel.createNakedDockable(this.createAxes().getMainComponent().getNativeComponent(), "Axes", "com/macrofocus/application/high_d/icons/axis16x16.png"), AttachAnchor.LEFT);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                Dockable dockableConfiguration = null;
                try {
                    dockableConfiguration = this.dockingPanel.createNakedDockable(this.createConfiguration().getMainComponent().getNativeComponent(), "Configuration", "com/macrofocus/application/high_d/icons/configurableAppearance16.png");
                    this.dockingPanel.attach(dockableConfiguration, AttachAnchor.LEFT);
                }
                catch (Error e) {
                    e.printStackTrace();
                }
                this.dockingPanel.attach(this.dockingPanel.createNakedDockable(this.hdFactory.createDetails().getNativeComponent(), "Details", "com/macrofocus/application/high_d/icons/toolWindowDatabaseConsole.png"), AttachAnchor.LEFT);
                try {
                    Clustering clustering = this.hdFactory.createClustering();
                    clustering.setModel(this.hdFactory, ((HighDDocument)((Object)document)).getClusteringModel());
                    this.dockingPanel.attach(this.dockingPanel.createNakedDockable(clustering.getNativeComponent(), "Clustering", "com/macrofocus/application/high_d/icons/k16x16.png"), AttachAnchor.LEFT);
                    if (dockableConfiguration != null) {
                        this.dockingPanel.getWestDockingBar().setActive(dockableConfiguration, false);
                    }
                }
                catch (RuntimeException e) {
                    e.printStackTrace();
                }
                this.northDockingPanel.attach(this.dockingPanel.createNakedDockable(this.filters.getNativeComponent(), "Categories", "com/macrofocus/application/high_d/icons/filters16x16.png"), AttachAnchor.TOP);
                this.northDockingPanel.attach(this.dockingPanel.createNakedDockable(this.hdFactory.createStatistics().getNativeComponent(), "Statistics", "com/macrofocus/application/high_d/icons/variables16x16.png"), AttachAnchor.TOP);
                this.northDockingPanel.attach(this.dockingPanel.createNakedDockable(this.hdFactory.forColumns(this.hdFactory.getDataFrame().columns()).createTable().getNativeComponent(), "Table", "com/macrofocus/application/high_d/icons/table16x16.png"), AttachAnchor.TOP);
                ScatterPlot scatterPlot = this.hdFactory.createScatterPlot();
                if (scatterPlot != null) {
                    ScatterPlotPanel<Component> scatterPlotPanel = this.createScatterPlotPanel(scatterPlot);
                    this.scatterPlotDockable = this.dockingPanel.createNakedDockable(scatterPlotPanel != null ? scatterPlotPanel.getNativeComponent() : scatterPlot.getNativeComponent(), "Scatter Plot", "com/macrofocus/application/high_d/icons/scatterplot16x16.png");
                    this.northDockingPanel.attach(this.scatterPlotDockable, AttachAnchor.RIGHT);
                }
                if ((mds = this.hdFactory.createMDS()) != null) {
                    mds.setModel(((HighDDocument)((Object)document)).getMDSScatterPlotModel());
                    MDSPanel panel = this.createMDSPanel(mds);
                    Dockable mdsDockable = this.getNorthDockingPanel().createNakedDockable(panel != null ? panel.getNativeComponent() : mds.getNativeComponent(), "Multidimensional Scaling", "com/macrofocus/application/high_d/icons/mds16x16.png");
                    this.getNorthDockingPanel().attach(mdsDockable, AttachAnchor.RIGHT);
                }
                this.innerDockingPanel.attach(this.dockingPanel.createNakedDockable(this.parallelCoordinates.getView().getNativeComponent(), "Parallel Coordinates", "com/macrofocus/application/high_d/icons/high-d16x16.png"), AttachAnchor.BOTTOM);
                this.innerDockingPanel.attach(this.dockingPanel.createNakedDockable(tableLens.getView().getNativeComponent(), "TablePlot", "com/macrofocus/application/high_d/icons/tablelens16x16.png"), AttachAnchor.BOTTOM);
                this.innerDockingPanel.attach(this.dockingPanel.createNakedDockable(this.hdFactory.createDistributions().getNativeComponent(), "Distributions", "com/macrofocus/application/high_d/icons/distribution16x16.png"), AttachAnchor.BOTTOM);
                this.innerDockingPanel.attach(this.dockingPanel.createNakedDockable(this.hdFactory.createScatterPlotMatrix().getNativeComponent(), "Scatter Plot Matrix", "com/macrofocus/application/high_d/icons/scatterplotmatrix16x16.png"), AttachAnchor.BOTTOM);
                this.innerDockingPanel.attach(this.dockingPanel.createNakedDockable(this.hdFactory.createParallelCoordinatesMatrix().getNativeComponent(), "Parallel Coordinates Matrix", "com/macrofocus/application/high_d/icons/pcm16x16.png"), AttachAnchor.BOTTOM);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public MDSPanel createMDSPanel(MDS<Component, Color, Font, Integer, String> mds) {
        return new AbstractMDSPanel(this.factory, mds);
    }

    public D getDocument() {
        return this.document;
    }

    @Override
    public HighDFactory<Component, Color, Font, Format, Integer, String, Object> getHighDFactory() {
        return this.hdFactory;
    }

    public void customizeCartoPlot(CartoPlot cartoPlot) {
        if (this.document != null) {
            cartoPlot.getView().setShowFiltered(((HighDDocument)((Object)this.document)).getSettings().getShowFiltered());
            cartoPlot.getView().setAntialiasing(((HighDDocument)((Object)this.document)).getSettings().getAntialiasing());
            cartoPlot.getView().setRendering(((HighDDocument)((Object)this.document)).getSettings().getRendering());
            cartoPlot.getView().setColorTheme(((HighDDocument)((Object)this.document)).getSettings().getColorTheme());
        }
    }

    public void customizeWindow(final CPWindow<?, Component> rootPanel) {
        rootPanel.setStyleClass(new String[]{"root"});
        this.colorTheme.addPropertyListener(new PropertyListener<ColorTheme<Color>>(){

            public void propertyChanged(PropertyEvent<ColorTheme<Color>> event) {
                AbstractHighDView.this.updateStyleClass(rootPanel, (ColorTheme)AbstractHighDView.this.colorTheme.getValue());
            }
        });
        this.updateStyleClass(rootPanel, (ColorTheme)this.colorTheme.getValue());
    }

    private void updateStyleClass(CPWindow<?, Component> rootPanel, ColorTheme<Color> colorTheme) {
        if (colorTheme.isDark()) {
            rootPanel.addStyleClass(new String[]{"dark", "bp3-dark"});
            rootPanel.removeStyleClass(new String[]{"light"});
        } else {
            rootPanel.addStyleClass(new String[]{"light"});
            rootPanel.removeStyleClass(new String[]{"dark", "bp3-dark"});
        }
    }

    public void customizeMenuBar(CPMenuBar<Component> menuBar) {
        CPMenu edit = menuBar.addMenu("Edit");
        this.customizeEditMenu(edit);
        CPMenu select = menuBar.addMenu("Select");
        this.customizeSelectMenu(select);
        CPMenu filter = menuBar.addMenu("Filter");
        this.customizeFilterMenu(filter);
        CPMenu paint = menuBar.addMenu("Paint");
        this.customizePaintMenu(paint);
        CPMenu interaction = menuBar.addMenu("Interaction");
        this.customizeInteractionMenu(interaction);
        CPMenu options = menuBar.addMenu("Options");
        this.customizeOptionsMenu(options);
        this.createCreateMenu(menuBar);
        this.createWindowMenu(menuBar);
        this.createHelpMenu(menuBar);
    }

    protected void createWindowMenu(CPMenuBar<Component> menuBar) {
        CPMenu window = menuBar.addMenu("Window");
        this.customizeWindowMenu(window);
    }

    protected void customizeWindowMenu(CPMenu<Component> options) {
    }

    protected void createCreateMenu(CPMenuBar<Component> menuBar) {
    }

    protected void createHelpMenu(CPMenuBar<Component> menuBar) {
        CPMenu window = menuBar.addMenu("Help");
        this.customizeHelpMenu(window);
    }

    protected void customizeHelpMenu(CPMenu<Component> options) {
    }

    public void customizeStatusBar(final CPStatusBar<Component> statusBar) {
        SimpleProperty status = new SimpleProperty((Object)"Ready");
        final CPTimer timer = this.factory.createTimer("StatusBarUpdater", 50, true, new CPTimerListener(){
            final /* synthetic */ MutableProperty val$status;
            {
                this.val$status = mutableProperty;
            }

            public void timerTriggered() {
                AbstractHighDView.this.updateStatus(statusBar, (MutableProperty<String>)this.val$status);
            }
        });
        this.updateStatus(statusBar, (MutableProperty<String>)status);
        if (this.getDocument() != null) {
            CPHorizontalFlowPanel flowPanel = this.factory.createHorizontalFlowPanel(new CPComponent[0]);
            flowPanel.setStyleClass(new String[]{"statusBarPanel"});
            Visual model = this.hdFactory.getVisual();
            SingleSelectionListener probingListener = new SingleSelectionListener(){

                public void selectionChanged(SingleSelectionEvent event) {
                    AbstractHighDView.this.scheduleUpdatePathPanel(timer);
                }
            };
            SelectionListener selectionListener = new SelectionListener(){

                public void selectionChanged(SelectionEvent event) {
                    AbstractHighDView.this.scheduleUpdatePathPanel(timer);
                }
            };
            FilterListener filterListener = new FilterListener(){

                public void filterChanged(FilterEvent event) {
                    AbstractHighDView.this.scheduleUpdatePathPanel(timer);
                }
            };
            model.getProbing().addSingleSelectionListener(probingListener);
            model.getSelection().addSelectionListener(selectionListener);
            model.getFilter().addFilterListener(filterListener);
            CPHorizontalFlowPanel palettePanel = this.factory.createHorizontalFlowPanel(new CPComponent[0]);
            palettePanel.setStyleClass(new String[]{"palettePanel"});
            palettePanel.add(this.createColorButton(this.factory.createRGBColor(0, 188, 26)));
            palettePanel.add(this.createColorButton(this.factory.createRGBColor(205, 0, 232)));
            palettePanel.add(this.createColorButton(this.factory.createRGBColor(128, 177, 211)));
            palettePanel.add(this.createColorButton(this.factory.createRGBColor(50, 255, 0)));
            palettePanel.add(this.createColorButton(this.factory.createRGBColor(179, 222, 105)));
            palettePanel.add(this.createColorButton(this.factory.createRGBColor(255, 159, 159)));
            palettePanel.add(this.createColorButton(null));
            CPButton reset = this.factory.createButton("Reset Filters");
            reset.setCommand((Command)new ResetFiltersCommand(this.getHighDFactory()));
            palettePanel.add((CPComponent)reset);
            flowPanel.add((CPComponent)palettePanel);
            flowPanel.add((CPComponent)this.factory.createLabel((Property)status));
            CPButton<Component> fullScreenButton = this.getFullScreenButton();
            if (fullScreenButton != null) {
                flowPanel.add(fullScreenButton);
            }
            statusBar.setStatusComponent(flowPanel.getNativeComponent());
        }
        statusBar.setStatus((MutableProperty)status);
    }

    public CPButton<Component> getFullScreenButton() {
        return null;
    }

    public CPColorButton<Component, Color> createColorButton(final CPColor<Color> color) {
        return this.factory.createColorButton(color != null ? color : this.factory.createRGBColor(189, 189, 189), new Command(){

            public void execute() {
                AbstractHighDView.this.colorize(color);
            }
        });
    }

    private void scheduleUpdatePathPanel(CPTimer timer) {
        timer.restart();
    }

    private void updateStatus(CPStatusBar<Component> statusBar, MutableProperty<String> status) {
        if (this.getDocument() != null) {
            int visibleCount;
            Visual model = this.hdFactory.getVisual();
            Object visible = model.getFilter().getFilteredCount() > 0 ? visibleCount + " " + ((visibleCount = model.getVisualObjects().getObjectCount() - model.getFilter().getFilteredCount()) > 1 ? "are" : "is") : "all are";
            status.setValue((Object)("Of " + model.getVisualObjects().getObjectCount() + " items, " + (String)visible + " visible, and " + model.getSelection().getSelectedCount() + " " + (model.getSelection().getSelectedCount() > 1 ? "are" : "is") + " selected"));
        } else {
            status.setValue((Object)"");
        }
    }

    protected void customizeEditMenu(CPMenu<Component> edit) {
        edit.addAction("Reset", null, (Command)(this.getDocument() != null ? new ResetCommand() : null));
    }

    protected void customizeIsolateMenu(CPMenu<Component> edit) {
        edit.addAction("Selected", "Ctrl-I", new Command(){

            public void execute() {
                ArrayList<Integer> toFilter = new ArrayList<Integer>();
                for (Integer row : AbstractHighDView.this.hdFactory.getDataFrame().rows()) {
                    if (AbstractHighDView.this.hdFactory.getVisual().getFilter().isFiltered((Object)row) || !AbstractHighDView.this.hdFactory.getVisual().getSelection().isSelected((Object)row)) continue;
                    toFilter.add(row);
                }
                AbstractHighDView.this.hdFactory.getSubsetDataFrame().getItemsDimension().getFilter().setFilteredIterable((Iterable)AbstractHighDView.this.hdFactory.getVisual().getSelection(), true, (Object)AbstractHighDView.this.hdFactory.getVisual().getSelection());
            }
        });
        edit.addAction("Inverse", null, new Command(){

            public void execute() {
                ArrayList<Integer> toSelect = new ArrayList<Integer>();
                for (Integer row : AbstractHighDView.this.hdFactory.getDataFrame().rows()) {
                    if (AbstractHighDView.this.hdFactory.getVisual().getFilter().isFiltered((Object)row) || AbstractHighDView.this.hdFactory.getVisual().getSelection().isSelected((Object)row)) continue;
                    toSelect.add(row);
                }
                AbstractHighDView.this.hdFactory.getVisual().getSelection().setSelectedIterable(toSelect);
            }
        });
        edit.addAction("None", null, new Command(){

            public void execute() {
                AbstractHighDView.this.hdFactory.getVisual().getSelection().clearSelection();
            }
        });
    }

    protected void customizeSelectMenu(CPMenu<Component> edit) {
        edit.addAction("All", "Ctrl-A", this.getDocument() != null ? new Command(){

            public void execute() {
                ArrayList<Integer> toSelect = new ArrayList<Integer>();
                for (Integer row : AbstractHighDView.this.hdFactory.getDataFrame().rows()) {
                    if (AbstractHighDView.this.hdFactory.getVisual().getFilter().isFiltered((Object)row)) continue;
                    toSelect.add(row);
                }
                AbstractHighDView.this.hdFactory.getVisual().getSelection().setSelectedIterable(toSelect);
            }
        } : null);
        edit.addAction("Inverse", null, this.getDocument() != null ? new Command(){

            public void execute() {
                ArrayList<Integer> toSelect = new ArrayList<Integer>();
                for (Integer row : AbstractHighDView.this.hdFactory.getDataFrame().rows()) {
                    if (AbstractHighDView.this.hdFactory.getVisual().getFilter().isFiltered((Object)row) || AbstractHighDView.this.hdFactory.getVisual().getSelection().isSelected((Object)row)) continue;
                    toSelect.add(row);
                }
                AbstractHighDView.this.hdFactory.getVisual().getSelection().setSelectedIterable(toSelect);
            }
        } : null);
        edit.addAction("None", null, this.getDocument() != null ? new Command(){

            public void execute() {
                AbstractHighDView.this.hdFactory.getVisual().getSelection().clearSelection();
            }
        } : null);
    }

    protected void customizeFilterMenu(CPMenu<Component> menu) {
        menu.addAction("Selected", null, this.getDocument() != null ? new Command(){

            public void execute() {
                AbstractHighDView.this.hdFactory.getSubsetDataFrame().getItemsDimension().getFilter().setFilteredIterable((Iterable)AbstractHighDView.this.hdFactory.getVisual().getSelection(), true, (Object)AbstractHighDView.this.hdFactory.getVisual().getSelection());
            }
        } : null);
        menu.addAction("None", null, this.getDocument() != null ? new Command(){

            public void execute() {
                AbstractHighDView.this.hdFactory.getSubsetDataFrame().getItemsDimension().getFilter().clearFilterBy((Object)AbstractHighDView.this.hdFactory.getVisual().getSelection());
            }
        } : null);
        menu.addSeparator();
        menu.addAction("Reset", null, this.getDocument() != null ? new Command(){

            public void execute() {
                for (AxisGroupModel axisGroup : AbstractHighDView.this.hdFactory.getAxisHierarchy().getAxisGroupHierarchy().breadthFirstIterator()) {
                    for (AxisModel axisModel : axisGroup.getAxisModels()) {
                        axisModel.getInterval().reset();
                    }
                }
                AbstractHighDView.this.filters.reset();
                AbstractHighDView.this.hdFactory.getSubsetDataFrame().reset();
            }
        } : null);
    }

    protected void customizeInteractionMenu(CPMenu<Component> menu) {
        menu.addRadio("Mode", this.getDocument() != null ? this.hdFactory.getInteractionMode() : null, (Object[])InteractionMode.values());
    }

    protected void customizePaintMenu(CPMenu<Component> menu) {
        menu.addAction("Blue", null, (Command)(this.getDocument() != null ? new ColorCommand(this.hdFactory.getCPFactory().createRGBColor(0, 30, 255)) : null));
        menu.addAction("Green", null, (Command)(this.getDocument() != null ? new ColorCommand(this.hdFactory.getCPFactory().createRGBColor(0, 188, 26)) : null));
        menu.addAction("Purple", null, (Command)(this.getDocument() != null ? new ColorCommand(this.hdFactory.getCPFactory().createRGBColor(205, 0, 232)) : null));
        menu.addAction("Light blue", null, (Command)(this.getDocument() != null ? new ColorCommand(this.hdFactory.getCPFactory().createRGBColor(128, 177, 211)) : null));
        menu.addAction("Bright green", null, (Command)(this.getDocument() != null ? new ColorCommand(this.hdFactory.getCPFactory().createRGBColor(50, 255, 0)) : null));
        menu.addAction("Light green", null, (Command)(this.getDocument() != null ? new ColorCommand(this.hdFactory.getCPFactory().createRGBColor(179, 222, 105)) : null));
        menu.addAction("Light violet", null, (Command)(this.getDocument() != null ? new ColorCommand(this.hdFactory.getCPFactory().createRGBColor(228, 167, 242)) : null));
        menu.addAction("Pink", null, (Command)(this.getDocument() != null ? new ColorCommand(this.hdFactory.getCPFactory().createRGBColor(255, 159, 159)) : null));
        menu.addSeparator();
        menu.addAction("Reset", null, this.getDocument() != null ? new Command(){

            public void execute() {
                AbstractHighDView.this.hdFactory.getVisual().getSelection().clearSelection();
                AbstractHighDView.this.hdFactory.getVisual().getColoring().clearColoring();
            }
        } : null);
    }

    protected void customizeOptionsMenu(CPMenu<Component> options) {
        options.addRadio("Rendering", this.getDocument() != null ? ((HighDDocument)((Object)this.getDocument())).getSettings().getRendering() : null, (Object[])CPCanvas.Rendering.values());
        options.addCheckBox("Antialiasing", "F7", this.getDocument() != null ? ((HighDDocument)((Object)this.getDocument())).getSettings().getAntialiasing() : null);
        options.addCheckBox("Show Filtered", "F8", this.getDocument() != null ? ((HighDDocument)((Object)this.getDocument())).getSettings().getShowFiltered() : null);
        options.addRadio("Geometry", this.getDocument() != null ? ((HighDDocument)((Object)this.getDocument())).getSettings().getGeometry() : null, (Object[])Geometry.values());
        options.addCheckBox("Allow Scrolling", null, this.getDocument() != null ? ((HighDDocument)((Object)this.getDocument())).getSettings().getAllowScrolling() : null);
        options.addSeparator();
        this.addColorThemeMenuItem(options);
    }

    protected void addColorThemeMenuItem(CPMenu<Component> options) {
        options.addRadio("Color Theme", this.colorTheme, (Object[])new ColorTheme[]{this.lightColorTheme, this.darkColorTheme});
    }

    private void colorize(CPColor color) {
        ArrayList<Integer> toColor = new ArrayList<Integer>();
        if (this.hdFactory.getVisual().getSelection().isActive()) {
            for (Integer row : this.hdFactory.getVisual().getSelection()) {
                toColor.add(row);
            }
            this.hdFactory.getVisual().getSelection().clearSelection();
        } else {
            for (Integer row : this.hdFactory.getDataFrame().rows()) {
                if (this.hdFactory.getVisual().getFilter().isFiltered((Object)row)) continue;
                toColor.add(row);
            }
        }
        this.hdFactory.getVisual().getColoring().setColorElements(toColor, color);
    }

    public DockingPanel<Component> getDockingPanel() {
        return this.dockingPanel;
    }

    public DockingPanel<Component> getNorthDockingPanel() {
        return this.northDockingPanel;
    }

    public abstract AxesPanel<Component> createAxes();

    public abstract ScatterPlotPanel<Component> createScatterPlotPanel(ScatterPlot<Component, Color, Font, Integer, String> var1);

    public abstract HighDConfigurationPanel<Component> createConfiguration();

    public void close() {
        this.dockingPanel.dispose();
        this.innerDockingPanel.dispose();
        this.northDockingPanel.dispose();
        this.properties.dispose();
    }

    public Component getNativeComponent() {
        return this.nativeComponent;
    }

    @Override
    public void waitUntilReady() {
    }

    private class ResetCommand
    implements Command {
        private ResetCommand() {
        }

        public void execute() {
            for (AxisGroupModel axisGroup : AbstractHighDView.this.hdFactory.getAxisHierarchy().getAxisGroupHierarchy().breadthFirstIterator()) {
                for (AxisModel axisModel : axisGroup.getAxisModels()) {
                    axisModel.getInterval().reset();
                }
            }
            AbstractHighDView.this.filters.reset();
            AbstractHighDView.this.hdFactory.getSubsetDataFrame().reset();
            AbstractHighDView.this.hdFactory.getVisual().getSelection().clearSelection();
            AbstractHighDView.this.hdFactory.getVisual().getColoring().clearColoring();
        }
    }

    private class ColorCommand
    implements Command {
        CPColor<Color> color;

        public ColorCommand(CPColor<Color> color) {
            this.color = color;
        }

        public void execute() {
            AbstractHighDView.this.colorize(this.color);
        }
    }
}

