/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.application.high_d.document;

import com.macrofocus.application.high_d.document.AxesDataFrame;
import com.macrofocus.common.collection.Iterables;
import com.macrofocus.common.command.AbstractUICommand;
import com.macrofocus.common.command.UICommand;
import com.macrofocus.common.properties.MutableProperty;
import com.macrofocus.common.properties.PropertyEvent;
import com.macrofocus.common.properties.PropertyListener;
import com.macrofocus.common.properties.SimpleProperty;
import com.macrofocus.common.scale.NumericTransform;
import com.macrofocus.common.scale.Transform;
import com.macrofocus.common.selection.Selection;
import com.macrofocus.common.selection.SelectionEvent;
import com.macrofocus.common.selection.SelectionListener;
import com.macrofocus.crossplatform.CPCheckBox;
import com.macrofocus.crossplatform.CPComboBox;
import com.macrofocus.crossplatform.CPComponent;
import com.macrofocus.crossplatform.CPFactory;
import com.macrofocus.crossplatform.CPFormPanel;
import com.macrofocus.crossplatform.CPSpinner;
import com.macrofocus.crossplatform.CPSplitMenuButton;
import com.macrofocus.filter.Filter;
import com.macrofocus.high_d.axis.AxisModel;
import com.macrofocus.molap.dataframe.DataFrameEvent;
import com.macrofocus.molap.dataframe.DataFrameHelper;
import com.macrofocus.molap.dataframe.DataFrameListener;
import com.macrofocus.order.MutableVisibleOrder;
import java.util.Collections;
import java.util.Date;
import java.util.List;

public class AxisPropertyPanel<Component, Color, R, C>
implements CPComponent<Component> {
    private final CPFormPanel<Component> nativeComponent;
    private CPFactory<Component, ?, ?, Color> factory;
    private MutableVisibleOrder<AxisModel<R, C>> axisOrder;
    private MutableVisibleOrder<AxisModel<R, C>> filtersAxisOrder;
    private Filter<R> filter;
    private AxesDataFrame<R, C> dataFrame;
    private Selection<C> selectionModel;
    private CPCheckBox categoriesCheckBox;
    private CPCheckBox tableCheckBox;
    private CPCheckBox visualizationsCheckBox;
    private CPSpinner minimumTextField;
    private CPSpinner maximumTextField;
    private CPSplitMenuButton zoomInButton;
    private CPSpinner startTextField;
    private CPSpinner endTextField;
    private CPSpinner numberOfBinsTextField;
    private CPComboBox binningTypeComboBox;
    private CPComboBox scaleTransformComboBox;

    public AxisPropertyPanel(CPFactory<Component, ?, ?, Color> factory) {
        this.factory = factory;
        this.nativeComponent = factory.createFormPanel();
        SimpleProperty categories = new SimpleProperty((Object)Boolean.FALSE);
        this.categoriesCheckBox = factory.createCheckBox("Categories", (MutableProperty)categories);
        categories.addPropertyListener((PropertyListener)new PropertyListener<Boolean>(){

            public void propertyChanged(PropertyEvent<Boolean> event) {
                boolean s = (Boolean)event.getNewValue();
                Object[] array = AxisPropertyPanel.this.getSelectedFilterAxisModels();
                if (s) {
                    AxisPropertyPanel.this.filtersAxisOrder.show(array);
                } else {
                    AxisPropertyPanel.this.filtersAxisOrder.hide(array);
                }
            }
        });
        SimpleProperty table = new SimpleProperty((Object)Boolean.FALSE);
        this.tableCheckBox = factory.createCheckBox("Table", (MutableProperty)table);
        table.addPropertyListener((PropertyListener)new PropertyListener<Boolean>(){

            public void propertyChanged(PropertyEvent<Boolean> event) {
                boolean s = (Boolean)event.getNewValue();
                for (Object r : AxisPropertyPanel.this.getSelected()) {
                    AxisPropertyPanel.this.dataFrame.setValueAt(r, AxesDataFrame.Column.Table, (Object)s);
                }
            }
        });
        SimpleProperty visualizations = new SimpleProperty((Object)Boolean.FALSE);
        this.visualizationsCheckBox = factory.createCheckBox("Visualizations", (MutableProperty)visualizations);
        visualizations.addPropertyListener((PropertyListener)new PropertyListener<Boolean>(){

            public void propertyChanged(PropertyEvent<Boolean> event) {
                boolean s = (Boolean)event.getNewValue();
                Object[] array = AxisPropertyPanel.this.getSelectedFilterAxisModels();
                if (s) {
                    AxisPropertyPanel.this.axisOrder.show(array);
                } else {
                    AxisPropertyPanel.this.axisOrder.hide(array);
                }
            }
        });
        SimpleProperty minimum = new SimpleProperty((Object)0.0);
        this.minimumTextField = factory.createDoubleSpinner((MutableProperty)minimum);
        minimum.addPropertyListener((PropertyListener)new PropertyListener<Double>(){

            public void propertyChanged(PropertyEvent<Double> event) {
                Double value = (Double)event.getNewValue();
                if (value != null) {
                    for (Object r : AxisPropertyPanel.this.getSelected()) {
                        AxisPropertyPanel.this.dataFrame.setValueAt(r, AxesDataFrame.Column.Minimum, (Object)value);
                    }
                }
            }
        });
        SimpleProperty maximum = new SimpleProperty((Object)1.0);
        this.maximumTextField = factory.createDoubleSpinner((MutableProperty)maximum);
        maximum.addPropertyListener((PropertyListener)new PropertyListener<Double>(){

            public void propertyChanged(PropertyEvent<Double> event) {
                Double value = (Double)event.getNewValue();
                if (value != null) {
                    for (Object r : AxisPropertyPanel.this.getSelected()) {
                        AxisPropertyPanel.this.dataFrame.setValueAt(r, AxesDataFrame.Column.Maximum, (Object)value);
                    }
                }
            }
        });
        Iterable scaleTransforms = Iterables.conditional((Iterable)Iterables.forArray((Object[])NumericTransform.values()), x -> x.getInverse() != null && x != NumericTransform.RECIPROCAL && x != NumericTransform.REVERSE);
        SimpleProperty scaleTransform = new SimpleProperty((Object)NumericTransform.IDENTITY);
        this.scaleTransformComboBox = factory.createComboBox((MutableProperty)scaleTransform, scaleTransforms);
        scaleTransform.addPropertyListener((PropertyListener)new PropertyListener<Transform>(){

            public void propertyChanged(PropertyEvent<Transform> event) {
                Transform value = (Transform)event.getNewValue();
                if (value != null) {
                    for (Object r : AxisPropertyPanel.this.getSelected()) {
                        AxisPropertyPanel.this.dataFrame.setValueAt(r, AxesDataFrame.Column.ScaleTransform, (Object)value);
                    }
                }
            }
        });
        this.zoomInButton = factory.createSplitMenuButton();
        this.zoomInButton.setDefaultCommand((UICommand)new ResetAction());
        this.zoomInButton.addCommand((UICommand)new FilteredRangeResetAction());
        this.zoomInButton.addCommand((UICommand)new SharedRangeResetAction());
        this.zoomInButton.addCommand((UICommand)new MeanRangeResetAction());
        this.zoomInButton.addCommand((UICommand)new SymetricalResetAction());
        this.zoomInButton.addCommand((UICommand)new RoundedResetAction());
        SimpleProperty start = new SimpleProperty((Object)0.0);
        this.startTextField = factory.createDoubleSpinner((MutableProperty)start);
        start.addPropertyListener((PropertyListener)new PropertyListener<Double>(){

            public void propertyChanged(PropertyEvent<Double> event) {
                Double value = (Double)event.getNewValue();
                if (value != null) {
                    for (Object r : AxisPropertyPanel.this.getSelected()) {
                        AxisPropertyPanel.this.dataFrame.setValueAt(r, AxesDataFrame.Column.Start, (Object)value);
                    }
                }
            }
        });
        SimpleProperty end = new SimpleProperty((Object)1.0);
        this.endTextField = factory.createDoubleSpinner((MutableProperty)end);
        end.addPropertyListener((PropertyListener)new PropertyListener<Double>(){

            public void propertyChanged(PropertyEvent<Double> event) {
                Double value = (Double)event.getNewValue();
                if (value != null) {
                    for (Object r : AxisPropertyPanel.this.getSelected()) {
                        AxisPropertyPanel.this.dataFrame.setValueAt(r, AxesDataFrame.Column.End, (Object)value);
                    }
                }
            }
        });
        SimpleProperty binningType = new SimpleProperty((Object)AxisModel.BinType.Fixed);
        this.binningTypeComboBox = factory.createComboBox((MutableProperty)binningType, Iterables.forArray((Object[])new AxisModel.BinType[]{AxisModel.BinType.Fixed, AxisModel.BinType.Sigma}));
        binningType.addPropertyListener((PropertyListener)new PropertyListener<AxisModel.BinType>(){

            public void propertyChanged(PropertyEvent<AxisModel.BinType> event) {
                AxisModel.BinType value = (AxisModel.BinType)event.getNewValue();
                if (value != null) {
                    for (Object r : AxisPropertyPanel.this.getSelected()) {
                        AxisPropertyPanel.this.dataFrame.setValueAt(r, AxesDataFrame.Column.BinType, (Object)value);
                    }
                }
            }
        });
        SimpleProperty binCount = new SimpleProperty((Object)10);
        this.numberOfBinsTextField = factory.createIntegerSpinner((MutableProperty)binCount);
        binCount.addPropertyListener((PropertyListener)new PropertyListener<Integer>(){

            public void propertyChanged(PropertyEvent<Integer> event) {
                Integer value = (Integer)event.getNewValue();
                if (value != null) {
                    for (Object r : AxisPropertyPanel.this.getSelected()) {
                        AxisPropertyPanel.this.dataFrame.setValueAt(r, AxesDataFrame.Column.BinCount, (Object)value);
                    }
                }
            }
        });
        this.nativeComponent.add((CPComponent)this.categoriesCheckBox, null);
        this.nativeComponent.add((CPComponent)this.visualizationsCheckBox, null);
        this.nativeComponent.add((CPComponent)factory.createLabel("Minimum:"), (CPComponent)this.minimumTextField);
        this.nativeComponent.add((CPComponent)factory.createLabel("Maximum:"), (CPComponent)this.maximumTextField);
        this.nativeComponent.add((CPComponent)factory.createLabel("Scale transform:"), (CPComponent)this.scaleTransformComboBox);
        this.nativeComponent.add(null, (CPComponent)this.zoomInButton);
        this.nativeComponent.add((CPComponent)factory.createLabel("Start:"), (CPComponent)this.startTextField);
        this.nativeComponent.add((CPComponent)factory.createLabel("End:"), (CPComponent)this.endTextField);
        this.nativeComponent.add((CPComponent)factory.createLabel("Type of binning:"), (CPComponent)this.binningTypeComboBox);
        this.nativeComponent.add((CPComponent)factory.createLabel("Number of bins:"), (CPComponent)this.numberOfBinsTextField);
        this.refresh();
    }

    public void setModel(MutableVisibleOrder<AxisModel<R, C>> axisOrder, MutableVisibleOrder<AxisModel<R, C>> filtersAxisOrder, Filter<R> filter, AxesDataFrame dataFrame, Selection<C> selectionModel) {
        this.dataFrame = dataFrame;
        this.selectionModel = selectionModel;
        this.filter = filter;
        this.axisOrder = axisOrder;
        this.filtersAxisOrder = filtersAxisOrder;
        selectionModel.addSelectionListener(new SelectionListener<C>(){

            public void selectionChanged(SelectionEvent<C> event) {
                AxisPropertyPanel.this.refresh();
            }
        });
        dataFrame.addDataFrameListener(new DataFrameListener(){

            public void dataFrameChanged(DataFrameEvent event) {
                AxisPropertyPanel.this.refresh();
            }
        });
        this.refresh();
    }

    private void refresh() {
        List<C> selected = this.getSelected();
        boolean isSelected = selected.size() > 0;
        this.setEnabled(this.categoriesCheckBox, isSelected);
        this.setEnabled(this.visualizationsCheckBox, isSelected);
        this.setEnabled(this.tableCheckBox, isSelected);
        switch (selected.size()) {
            case 0: {
                this.setState(this.categoriesCheckBox, CPCheckBox.State.Unchecked);
                this.setState(this.visualizationsCheckBox, CPCheckBox.State.Unchecked);
                this.setState(this.tableCheckBox, CPCheckBox.State.Unchecked);
                this.minimumTextField.setValue(null);
                this.maximumTextField.setValue(null);
                this.minimumTextField.setEnabled(false);
                this.maximumTextField.setEnabled(false);
                this.startTextField.setValue(null);
                this.endTextField.setValue(null);
                this.startTextField.setEnabled(false);
                this.endTextField.setEnabled(false);
                this.numberOfBinsTextField.setEnabled(false);
                this.zoomInButton.setEnabled(false);
                break;
            }
            case 1: {
                C r = selected.get(0);
                this.setState(this.categoriesCheckBox, (Boolean)this.dataFrame.getValueAt(r, AxesDataFrame.Column.Categories) != false ? CPCheckBox.State.Checked : CPCheckBox.State.Unchecked);
                this.setState(this.visualizationsCheckBox, (Boolean)this.dataFrame.getValueAt(r, AxesDataFrame.Column.Visualizations) != false ? CPCheckBox.State.Checked : CPCheckBox.State.Unchecked);
                this.setState(this.tableCheckBox, (Boolean)this.dataFrame.getValueAt(r, AxesDataFrame.Column.Table) != false ? CPCheckBox.State.Checked : CPCheckBox.State.Unchecked);
                this.minimumTextField.setValue((Number)this.dataFrame.getValueAt(r, AxesDataFrame.Column.Minimum));
                this.maximumTextField.setValue((Number)this.dataFrame.getValueAt(r, AxesDataFrame.Column.Maximum));
                this.minimumTextField.setEnabled(this.dataFrame.getValueAt(r, AxesDataFrame.Column.Minimum) != null);
                this.maximumTextField.setEnabled(this.dataFrame.getValueAt(r, AxesDataFrame.Column.Maximum) != null);
                this.startTextField.setValue((Number)this.dataFrame.getValueAt(r, AxesDataFrame.Column.Start));
                this.endTextField.setValue((Number)this.dataFrame.getValueAt(r, AxesDataFrame.Column.End));
                this.numberOfBinsTextField.setValue((Number)this.dataFrame.getValueAt(r, AxesDataFrame.Column.BinCount));
                this.startTextField.setEnabled(this.dataFrame.getValueAt(r, AxesDataFrame.Column.Start) != null);
                this.endTextField.setEnabled(this.dataFrame.getValueAt(r, AxesDataFrame.Column.End) != null);
                this.numberOfBinsTextField.setEnabled(this.dataFrame.getValueAt(r, AxesDataFrame.Column.BinCount) != null);
                this.minimumTextField.setMinimum((Comparable)this.dataFrame.getValueAt(r, AxesDataFrame.Column.Minimum));
                this.minimumTextField.setMaximum((Comparable)this.dataFrame.getValueAt(r, AxesDataFrame.Column.Maximum));
                this.maximumTextField.setMinimum((Comparable)this.dataFrame.getValueAt(r, AxesDataFrame.Column.Minimum));
                this.maximumTextField.setMaximum((Comparable)this.dataFrame.getValueAt(r, AxesDataFrame.Column.Maximum));
                this.startTextField.setMinimum((Comparable)this.dataFrame.getValueAt(r, AxesDataFrame.Column.Minimum));
                this.startTextField.setMaximum((Comparable)this.dataFrame.getValueAt(r, AxesDataFrame.Column.Maximum));
                this.endTextField.setMinimum((Comparable)this.dataFrame.getValueAt(r, AxesDataFrame.Column.Minimum));
                this.endTextField.setMaximum((Comparable)this.dataFrame.getValueAt(r, AxesDataFrame.Column.Maximum));
                this.zoomInButton.setEnabled(this.dataFrame.getValueAt(r, AxesDataFrame.Column.Minimum) != null && this.dataFrame.getValueAt(r, AxesDataFrame.Column.Maximum) != null);
                break;
            }
            default: {
                this.setState(this.categoriesCheckBox, this.getCommonState(selected, AxesDataFrame.Column.Categories));
                this.setState(this.visualizationsCheckBox, this.getCommonState(selected, AxesDataFrame.Column.Visualizations));
                this.setState(this.tableCheckBox, this.getCommonState(selected, AxesDataFrame.Column.Table));
                this.minimumTextField.setValue((Number)this.getCommonValue(selected, AxesDataFrame.Column.Minimum));
                this.maximumTextField.setValue((Number)this.getCommonValue(selected, AxesDataFrame.Column.Maximum));
                this.minimumTextField.setEnabled(this.getCommonClass(selected, AxesDataFrame.Column.Minimum) == Double.class);
                this.maximumTextField.setEnabled(this.getCommonClass(selected, AxesDataFrame.Column.Maximum) == Double.class);
                this.minimumTextField.setMinimum((Comparable)this.getCommonValue(selected, AxesDataFrame.Column.Minimum));
                this.minimumTextField.setMaximum((Comparable)this.getCommonValue(selected, AxesDataFrame.Column.Maximum));
                this.maximumTextField.setMinimum((Comparable)this.getCommonValue(selected, AxesDataFrame.Column.Minimum));
                this.maximumTextField.setMaximum((Comparable)this.getCommonValue(selected, AxesDataFrame.Column.Maximum));
                this.startTextField.setMinimum((Comparable)this.getCommonValue(selected, AxesDataFrame.Column.Minimum));
                this.startTextField.setMaximum((Comparable)this.getCommonValue(selected, AxesDataFrame.Column.Maximum));
                this.endTextField.setMinimum((Comparable)this.getCommonValue(selected, AxesDataFrame.Column.Minimum));
                this.endTextField.setMaximum((Comparable)this.getCommonValue(selected, AxesDataFrame.Column.Maximum));
                this.startTextField.setValue(null);
                this.endTextField.setValue(null);
                this.numberOfBinsTextField.setValue(null);
                this.startTextField.setEnabled(false);
                this.endTextField.setEnabled(false);
                this.zoomInButton.setEnabled(this.getCommonClass(selected, AxesDataFrame.Column.Minimum) == Double.class && this.getCommonClass(selected, AxesDataFrame.Column.Maximum) == Double.class);
            }
        }
    }

    private AxisModel[] getSelectedAxisModels() {
        List<C> selected = this.getSelected();
        AxisModel[] array = new AxisModel[selected.size()];
        for (int i = 0; i < selected.size(); ++i) {
            C index = selected.get(i);
            array[i] = (AxisModel)this.axisOrder.getAll(this.dataFrame.getRowAddress(index));
        }
        return array;
    }

    private AxisModel[] getSelectedFilterAxisModels() {
        List<C> selected = this.getSelected();
        AxisModel[] array = new AxisModel[selected.size()];
        for (int i = 0; i < selected.size(); ++i) {
            C index = selected.get(i);
            array[i] = (AxisModel)this.axisOrder.getAll(this.dataFrame.getRowAddress(index));
        }
        return array;
    }

    private CPCheckBox.State getCommonState(List<C> rows, AxesDataFrame.Column column) {
        CPCheckBox.State value = CPCheckBox.State.Unchecked;
        if (rows.size() > 0) {
            value = (Boolean)this.dataFrame.getValueAt(rows.get(0), column) != false ? CPCheckBox.State.Checked : CPCheckBox.State.Unchecked;
            for (int i = 1; i < rows.size(); ++i) {
                CPCheckBox.State v;
                C r = rows.get(i);
                CPCheckBox.State state = v = (Boolean)this.dataFrame.getValueAt(r, column) != false ? CPCheckBox.State.Checked : CPCheckBox.State.Unchecked;
                if (v == value) continue;
                value = CPCheckBox.State.Undefined;
                break;
            }
        }
        return value;
    }

    private Object getCommonValue(List<C> rows, AxesDataFrame.Column column) {
        Object value = null;
        if (rows.size() > 0) {
            value = this.dataFrame.getValueAt(rows.get(0), column);
            for (int i = 1; i < rows.size(); ++i) {
                C r = rows.get(i);
                Object v = this.dataFrame.getValueAt(r, column);
                if (v != null && v.equals(value)) continue;
                value = null;
                break;
            }
        }
        return value;
    }

    private Object getCommonClass(List<C> rows, AxesDataFrame.Column column) {
        Class<?> cl = null;
        if (rows.size() > 0) {
            cl = this.dataFrame.getValueAt(rows.get(0), column) != null ? this.dataFrame.getValueAt(rows.get(0), column).getClass() : null;
            for (int i = 1; i < rows.size(); ++i) {
                C r = rows.get(i);
                Object v = this.dataFrame.getValueAt(r, column);
                if (v != null && v.getClass().equals(cl)) continue;
                cl = null;
                break;
            }
        }
        return cl;
    }

    private void setEnabled(CPCheckBox checkBox, boolean enabled) {
        checkBox.setEnabled(enabled);
    }

    private void setState(CPCheckBox checkBox, CPCheckBox.State state) {
        if (checkBox.getState() != state) {
            checkBox.setState(state);
        }
    }

    private List<C> getSelected() {
        if (this.dataFrame != null) {
            return Iterables.makeList(this.selectionModel);
        }
        return Collections.EMPTY_LIST;
    }

    public void setStyleClass(String ... styleClasses) {
        this.nativeComponent.setStyleClass(styleClasses);
    }

    public Component getNativeComponent() {
        return (Component)this.nativeComponent.getNativeComponent();
    }

    public DataFrameHelper.ColumnStatistics getColumnStatistics(AxisModel<R, C> axisModel) {
        Number min = null;
        Number max = null;
        double sum = 0.0;
        long count = 0L;
        for (int row = 0; row < axisModel.getRowCount(); ++row) {
            Number value;
            Object r = axisModel.getRow(row);
            if (this.filter.isFiltered(r) || axisModel.getValue(r) == null || (value = axisModel.getValue(r)) == null) continue;
            if (value instanceof Number) {
                Number number = value;
                double d = number.doubleValue();
                if (number instanceof Double) {
                    if (Double.isNaN(d) || Double.isInfinite(d)) continue;
                    if (min == null || d < ((Number)min).doubleValue()) {
                        min = number;
                    }
                    if (max == null || d > ((Number)max).doubleValue()) {
                        max = number;
                    }
                    sum += number.doubleValue();
                    ++count;
                    continue;
                }
                if (number instanceof Float) {
                    float f = number.floatValue();
                    if (Float.isNaN(f) || Float.isInfinite(f)) continue;
                    if (min == null || d < ((Number)min).doubleValue()) {
                        min = number;
                    }
                    if (max != null && !(d > ((Number)max).doubleValue())) continue;
                    max = number;
                    continue;
                }
                if (min == null || d < ((Number)min).doubleValue()) {
                    min = number;
                }
                if (max == null || d > ((Number)max).doubleValue()) {
                    max = number;
                }
                sum += d;
                ++count;
                continue;
            }
            if (!(value instanceof Date)) continue;
            Date date = (Date)((Object)value);
            long time = date.getTime();
            if (min == null || (double)time < ((Number)min).doubleValue()) {
                min = time;
            }
            if (max == null || (double)time > ((Number)max).doubleValue()) {
                max = time;
            }
            sum += (double)time;
            ++count;
        }
        return new DataFrameHelper.ColumnStatistics(min, max, sum, count);
    }

    private class ResetAction
    extends AbstractUICommand {
        public ResetAction() {
            super("Reset to Data Range");
        }

        public void execute(Object source) {
            for (AxisModel axisModel : AxisPropertyPanel.this.getSelectedAxisModels()) {
                DataFrameHelper.ColumnStatistics columnStatistics = AxisPropertyPanel.this.getColumnStatistics(axisModel);
                Number min = columnStatistics.getMin();
                Number max = columnStatistics.getMax();
                if (min == null || max == null) continue;
                axisModel.setMinMax(min.doubleValue(), max.doubleValue());
            }
            AxisPropertyPanel.this.refresh();
        }
    }

    private class FilteredRangeResetAction
    extends AbstractUICommand {
        public FilteredRangeResetAction() {
            super("Set to Range Slider");
        }

        public void execute(Object source) {
            for (AxisModel axisModel : AxisPropertyPanel.this.getSelectedAxisModels()) {
                axisModel.setMinMax(axisModel.getInterval().getStart(), axisModel.getInterval().getEnd());
            }
            AxisPropertyPanel.this.refresh();
        }
    }

    private class SharedRangeResetAction
    extends AbstractUICommand {
        public SharedRangeResetAction() {
            super("Make Common Range");
        }

        public void execute(Object source) {
            Number sharedMin = null;
            Number sharedMax = null;
            for (AxisModel axisModel : AxisPropertyPanel.this.getSelectedAxisModels()) {
                Double min = axisModel.getMinimum();
                Double max = axisModel.getMaximum();
                if (min == null || max == null) continue;
                if (sharedMin == null || sharedMin.doubleValue() > min) {
                    sharedMin = min;
                }
                if (sharedMax != null && !(sharedMax.doubleValue() < max)) continue;
                sharedMax = max;
            }
            if (sharedMin != null && sharedMax != null) {
                for (AxisModel axisModel : AxisPropertyPanel.this.getSelectedAxisModels()) {
                    axisModel.getInterval().setValue(sharedMin.doubleValue(), sharedMax.doubleValue() - sharedMin.doubleValue());
                    axisModel.setMinMax(sharedMin.doubleValue(), sharedMax.doubleValue());
                }
            }
            AxisPropertyPanel.this.refresh();
        }
    }

    private class MeanRangeResetAction
    extends AbstractUICommand {
        public MeanRangeResetAction() {
            super("Make Symmetrical around Mean");
        }

        public void execute(Object source) {
            for (AxisModel axisModel : AxisPropertyPanel.this.getSelectedAxisModels()) {
                DataFrameHelper.ColumnStatistics columnStatistics = AxisPropertyPanel.this.getColumnStatistics(axisModel);
                Number min = columnStatistics.getMin();
                Number max = columnStatistics.getMax();
                Double mean = columnStatistics.getMean();
                if (min == null || max == null || mean == null) continue;
                double maxDeviation = Math.abs(min.doubleValue() - mean) > Math.abs(max.doubleValue() - mean) ? mean - min.doubleValue() : max.doubleValue() - mean;
                axisModel.setMinMax(mean - maxDeviation, mean + maxDeviation);
            }
            AxisPropertyPanel.this.refresh();
        }
    }

    private class SymetricalResetAction
    extends AbstractUICommand {
        public SymetricalResetAction() {
            super("Make Symmetrical Range around 0");
        }

        public void execute(Object source) {
            for (AxisModel axisModel : AxisPropertyPanel.this.getSelectedAxisModels()) {
                Double min = axisModel.getMinimum();
                Double max = axisModel.getMaximum();
                if (min == null || max == null) continue;
                if (min < 0.0 && min > 0.0) {
                    double diffMin = 0.0 - min;
                    double diffMax = max;
                    double maxDiff = Math.max(diffMin, diffMax);
                    axisModel.setMinMax(0.0 - maxDiff, maxDiff);
                    continue;
                }
                axisModel.setMinMax(-((Number)max).doubleValue(), ((Number)max).doubleValue());
            }
            AxisPropertyPanel.this.refresh();
        }
    }

    private class RoundedResetAction
    extends AbstractUICommand {
        public RoundedResetAction() {
            super("Round Range Values");
        }

        public void execute(Object source) {
            for (AxisModel axisModel : AxisPropertyPanel.this.getSelectedAxisModels()) {
                Double min = axisModel.getMinimum();
                Double max = axisModel.getMaximum();
                if (min == null || max == null) continue;
                double s = Math.signum(min) * Math.pow(10.0, Math.floor(Math.log10(Math.abs(min))));
                double e = Math.signum(max) * Math.pow(10.0, Math.ceil(Math.log10(Math.abs(max))));
                axisModel.setMinMax(s, e);
            }
            AxisPropertyPanel.this.refresh();
        }
    }

    private class StandardDeviationAction
    extends AbstractUICommand {
        private final int sigma;

        public StandardDeviationAction(int sigma) {
            super("Set to -" + sigma + "\u03c3 to " + sigma + "\u03c3");
            this.sigma = sigma;
        }

        public void execute(Object source) {
            for (AxisModel axisModel : AxisPropertyPanel.this.getSelectedAxisModels()) {
                DataFrameHelper.ColumnStatistics columnStatistics = AxisPropertyPanel.this.getColumnStatistics(axisModel);
                Number min = columnStatistics.getMin();
                Number max = columnStatistics.getMax();
                Double mean = axisModel.getMean();
                Double stdDev = axisModel.getStdDev();
                if (min == null || max == null || mean == null || stdDev == null) continue;
                double minSigma = mean - (double)this.sigma * stdDev;
                double maxSigma = mean + (double)this.sigma * stdDev;
                if (minSigma < min.doubleValue()) {
                    minSigma = min.doubleValue();
                }
                if (maxSigma > max.doubleValue()) {
                    maxSigma = max.doubleValue();
                }
                axisModel.setMinMax(minSigma, maxSigma);
            }
            AxisPropertyPanel.this.refresh();
        }
    }

    private class VisibleRangeResetAction
    extends AbstractUICommand {
        public VisibleRangeResetAction() {
            super("Set to Visible Range");
        }

        public void execute(Object source) {
            for (AxisModel axisModel : AxisPropertyPanel.this.getSelectedAxisModels()) {
                DataFrameHelper.ColumnStatistics columnStatistics = AxisPropertyPanel.this.getColumnStatistics(axisModel);
                Number min = columnStatistics.getMin();
                Number max = columnStatistics.getMax();
                if (min == null || max == null) continue;
                axisModel.setMinMax(min.doubleValue(), max.doubleValue());
            }
            AxisPropertyPanel.this.refresh();
        }
    }
}

