/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.application.high_d.document;

import com.macrofocus.application.document.AbstractDocument;
import com.macrofocus.colormap.ColorMapFactory;
import com.macrofocus.colormapping.MutableColorMapping;
import com.macrofocus.colormapping.implementation.SimpleColorMapping;
import com.macrofocus.common.properties.PropertiesListener;
import com.macrofocus.common.properties.PropertyEvent;
import com.macrofocus.common.selection.Selection;
import com.macrofocus.common.selection.SingleSelection;
import com.macrofocus.crossplatform.CPCanvas;
import com.macrofocus.crossplatform.CPFactory;
import com.macrofocus.filter.Filter;
import com.macrofocus.filter.MutableFilter;
import com.macrofocus.high_d.HighDSettings;
import com.macrofocus.high_d.axis.AxisFactory;
import com.macrofocus.high_d.axis.hierarchy.AxisHierarchy;
import com.macrofocus.high_d.axis.hierarchy.DefaultAxisHierarchy;
import com.macrofocus.high_d.mds.MDSScatterPlotModel;
import com.macrofocus.high_d.mds.tsne.MatrixOperationsFactory;
import com.macrofocus.high_d.parallelcoordinates.DefaultParallelCoordinatesModel;
import com.macrofocus.high_d.parallelcoordinates.DefaultParallelCoordinatesSettings;
import com.macrofocus.high_d.parallelcoordinates.ParallelCoordinatesSettings;
import com.macrofocus.high_d.statistics.StatisticsDataFrame;
import com.macrofocus.molap.dataframe.DataFrame;
import com.macrofocus.molap.dataframe.WrappedDataFrame;
import com.macrofocus.molap.persistence.DataSourcePersistence;
import com.macrofocus.molap.subset.SingleBinningDimension;
import com.macrofocus.molap.subset.SubsetDataFrame;
import com.macrofocus.timer.CPExecutor;
import com.macrofocus.visual.SimpleVisual;
import com.macrofocus.visual.SimpleVisualObjects;
import com.macrofocus.visual.Visual;
import com.macrofocus.visual.VisualObjects;

public class HighDDocument<Color, Font, File>
extends AbstractDocument {
    private HighDSettings<Color, Font> settings;
    private WrappedDataFrame<Integer, String, Object> dataFrame;
    private final DataSourcePersistence<File> dataSourcePersistence;
    private boolean modified;
    private DataFrame<?, String, ?> annotationDataFrame;
    private SubsetDataFrame<Integer, String, Object> subsetDataFrame;
    private final Visual<Color, Integer, String> visual;
    private final AxisHierarchy axisHierarchy;
    private final AxisHierarchy filtersAxisHierarchy;
    private final DefaultParallelCoordinatesModel parallelCoordinatesModel;
    private final MDSScatterPlotModel<Color, Integer, String> mdsScatterPlotModel;
    private final SingleBinningDimension<Integer, ?> clusteringModel;
    public Boolean isLogoVisible = Boolean.TRUE;

    public HighDDocument(String name, String url, DataFrame<Integer, String, Object> dataFrame, DataSourcePersistence<File> dataSourcePersistence, CPFactory<?, Font, ?, Color> cpFactory, ColorMapFactory<Color> colorMapFactory, MatrixOperationsFactory matrixOperationsFactory, CPExecutor executor) {
        super(name, url);
        this.settings = new HighDSettings(cpFactory);
        if (dataFrame instanceof WrappedDataFrame) {
            this.dataFrame = (WrappedDataFrame)dataFrame;
        } else {
            this.dataFrame = new WrappedDataFrame(dataFrame);
            this.dataFrame.addOriginalColumns();
        }
        this.dataSourcePersistence = dataSourcePersistence;
        if (dataFrame.getRowCount() >= 500) {
            this.getSettings().getRendering().setValue((Object)CPCanvas.Rendering.Density);
        }
        this.visual = new SimpleVisual((VisualObjects)new SimpleVisualObjects(this.dataFrame), (MutableColorMapping)new SimpleColorMapping(colorMapFactory, this.dataFrame));
        this.annotationDataFrame = new StatisticsDataFrame(cpFactory, this.dataFrame, this.visual.getProbing(), this.visual.getSelection(), (Filter)this.visual.getFilter(), this.visual.getColorMapping(), this.visual.getColoring());
        this.subsetDataFrame = new SubsetDataFrame(this.dataFrame, this.visual.getFilter(), this.visual.getSelection());
        AxisFactory axisFactory = new AxisFactory(cpFactory, this.dataFrame, this.getSubsetDataFrame(), this.getAnnotationDataFrame(), (SingleSelection)this.visual.getProbing(), (Selection)this.visual.getSelection(), (MutableFilter)this.visual.getFilter());
        this.axisHierarchy = new DefaultAxisHierarchy(axisFactory, cpFactory, this.dataFrame, true, false, 10);
        this.filtersAxisHierarchy = new DefaultAxisHierarchy(axisFactory, cpFactory, this.dataFrame, false, true, 10);
        this.parallelCoordinatesModel = new DefaultParallelCoordinatesModel(this.dataFrame, this.visual, this.axisHierarchy, (ParallelCoordinatesSettings)new DefaultParallelCoordinatesSettings());
        this.mdsScatterPlotModel = new MDSScatterPlotModel(this.dataFrame, this.visual, this.axisHierarchy.getFlat(), matrixOperationsFactory, executor);
        this.clusteringModel = this.subsetDataFrame.getBinningDimension((Object)"Clusters", null);
        this.settings.getProperties().addPropertiesListener(new PropertiesListener(){

            public void propertyChanged(Object name, PropertyEvent event) {
                HighDDocument.this.setModified(true);
            }
        });
    }

    public HighDSettings<Color, Font> getSettings() {
        return this.settings;
    }

    public DataFrame getDataFrame() {
        return this.dataFrame;
    }

    public DataSourcePersistence<File> getDataSourcePersistence() {
        return this.dataSourcePersistence;
    }

    public DataFrame<?, String, ?> getAnnotationDataFrame() {
        return this.annotationDataFrame;
    }

    public SubsetDataFrame<Integer, String, Object> getSubsetDataFrame() {
        return this.subsetDataFrame;
    }

    public Visual<Color, Integer, String> getVisual() {
        return this.visual;
    }

    public AxisHierarchy<Integer, String> getAxisHierarchy() {
        return this.axisHierarchy;
    }

    public AxisHierarchy getFiltersAxisHierarchy() {
        return this.filtersAxisHierarchy;
    }

    public DefaultParallelCoordinatesModel getParallelCoordinatesModel() {
        return this.parallelCoordinatesModel;
    }

    public MDSScatterPlotModel<Color, Integer, String> getMDSScatterPlotModel() {
        return this.mdsScatterPlotModel;
    }

    public SingleBinningDimension<Integer, ?> getClusteringModel() {
        return this.clusteringModel;
    }

    public void setDataFrame(DataFrame dataFrame) {
        if (this.dataFrame == null) {
            if (dataFrame instanceof WrappedDataFrame) {
                this.dataFrame = (WrappedDataFrame)dataFrame;
            } else {
                this.dataFrame = new WrappedDataFrame(dataFrame);
                this.dataFrame.addOriginalColumns();
            }
        } else {
            this.dataFrame.setDataFrame(dataFrame);
        }
    }

    public boolean isModified() {
        return this.modified;
    }

    public void setModified(boolean modified) {
        this.modified = modified;
    }

    public void save() {
    }
}

