/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.application.high_d.document;

import com.macrofocus.application.ApplicationModelFactory;
import com.macrofocus.application.file.CPDirectoryChooser;
import com.macrofocus.application.high_d.document.HighDApplication;
import com.macrofocus.application.high_d.document.HighDDocument;
import com.macrofocus.application.high_d.document.persistence.HighDPersistence;
import com.macrofocus.data.source.DataSource;
import com.macrofocus.format.FormatFactory;
import com.macrofocus.igraphics.CPColorFactory;
import com.macrofocus.igraphics.CPFontFactory;
import com.macrofocus.molap.dataframe.DataFrame;
import com.macrofocus.molap.dataframe.MutableDataFrame;
import com.macrofocus.molap.exporter.java.SwingDataFrameExporter;
import com.macrofocus.palette.PaletteFactory;
import com.macrofocus.persistence.DefaultElementFactory;
import com.macrofocus.persistence.Element;
import com.macrofocus.persistence.ElementFactory;
import com.macrofocus.persistence.xml.XmlElementSerializer;
import com.macrofocus.resources.ResourcesModel;
import java.awt.Color;
import java.awt.Font;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import org.json.JSONArray;
import org.json.JSONML;
import org.json.JSONObject;
import org.json.JSONTokener;

public interface JavaHighDApplication<Window, Component, F, D extends HighDDocument>
extends HighDApplication<Window, Component, F, D> {
    public HighDDocument createDocument(String var1, String var2, DataSource var3, MutableDataFrame<Integer, String, Object> var4);

    public CPDirectoryChooser<Window, File> getDirectoryChooser();

    public ResourcesModel getResourcesModel();

    public static String saveToJSON(HighDDocument document, CPColorFactory<Color> colorFactory, CPFontFactory<Font> fontFactory, PaletteFactory<Color> paletteFactory, FormatFactory formatFactory) throws IOException {
        Element root = JavaHighDApplication.save(document, null, colorFactory, fontFactory, paletteFactory, formatFactory);
        String jsonDataFrame = SwingDataFrameExporter.exportJSON((DataFrame)document.getDataFrame());
        JSONObject xxx = new JSONObject(new JSONTokener(jsonDataFrame));
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        new XmlElementSerializer().write((OutputStream)out, root);
        JSONObject json = JSONML.toJSONObject((String)out.toString());
        JSONArray Obj1 = (JSONArray)xxx.get("data");
        JSONObject combined = new JSONObject();
        combined.put("data", (Object)Obj1);
        combined.put("High-D", (Object)json);
        return combined.toString();
    }

    public static <Color, Font> Element save(HighDDocument document, File file, CPColorFactory<Color> colorFactory, CPFontFactory<Font> fontFactory, PaletteFactory<Color> paletteFactory, FormatFactory formatFactory) {
        DefaultElementFactory elementFactory = new DefaultElementFactory();
        HighDPersistence persistence = new HighDPersistence(document, colorFactory, fontFactory, paletteFactory, formatFactory, (ElementFactory)elementFactory);
        Element root = elementFactory.newElement("High-D");
        root.addAttribute(elementFactory.newAttribute("version", ApplicationModelFactory.HIGHD_APP.getVersionModel().toString()));
        persistence.save(root, (Object)file);
        return root;
    }
}

