/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.application.high_d.document;

import com.macrofocus.application.document.DocumentOpener;
import com.macrofocus.application.document.OpenDocumentException;
import com.macrofocus.application.file.CPDirectoryChooser;
import com.macrofocus.application.high_d.document.HighDDocument;
import com.macrofocus.application.high_d.document.JavaHighDApplication;
import com.macrofocus.application.window.CPWindow;
import com.macrofocus.common.command.Command;
import com.macrofocus.data.source.DataSource;
import com.macrofocus.data.source.DirectoryDataSource;
import com.macrofocus.molap.dataframe.MutableDataFrame;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;

public class OpenDirectoryCommand<Window, Component>
implements Command {
    private final JavaHighDApplication<Window, Component, ?, ?> application;
    private final CPWindow window;

    public OpenDirectoryCommand(JavaHighDApplication<Window, Component, ?, ?> application, CPWindow window) {
        this.application = application;
        this.window = window;
    }

    public void execute() {
        CPDirectoryChooser<Window, File> fileChooser = this.application.getDirectoryChooser();
        fileChooser.setTitle("Open Directory");
        final File selectedFile = (File)fileChooser.showDialog(this.window);
        if (selectedFile != null) {
            DocumentOpener documentOpener = new DocumentOpener(){

                public HighDDocument openDocument(CPWindow window) throws OpenDocumentException {
                    try {
                        HighDDocument document = OpenDirectoryCommand.this.processDirectory(selectedFile);
                        return document;
                    }
                    catch (Exception e) {
                        throw new OpenDocumentException("Error", (Throwable)e);
                    }
                }
            };
            this.application.openAndShowDocument(this.window, documentOpener, null);
        }
    }

    public HighDDocument processDirectory(File file) {
        try {
            DirectoryDataSource dataSource = new DirectoryDataSource(file);
            MutableDataFrame dataFrame = dataSource.loadDataFrame(null);
            HighDDocument document = this.application.createDocument(file.getName(), file.toURI().toURL().toExternalForm(), (DataSource)dataSource, (MutableDataFrame<Integer, String, Object>)dataFrame);
            return document;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return null;
    }
}

