/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.application.high_d.document;

import com.macrofocus.application.document.DocumentOpener;
import com.macrofocus.application.document.OpenDocumentException;
import com.macrofocus.application.high_d.document.HighDDocument;
import com.macrofocus.application.high_d.document.JavaHighDApplication;
import com.macrofocus.application.window.CPWindow;
import com.macrofocus.common.command.Command;
import com.macrofocus.data.db.OpenGoogleSpreadsheetDialog;
import com.macrofocus.data.source.DataSource;
import com.macrofocus.data.source.GoogleSpreadsheetDataSource;
import com.macrofocus.molap.dataframe.MutableDataFrame;
import com.macrofocus.util.logging.SwingLogging;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.ProgressMonitor;
import javax.swing.SwingUtilities;

public class OpenGoogleSpreadsheetCommand<Window, Component>
implements Command {
    private final JavaHighDApplication application;
    private final CPWindow window;
    private OpenGoogleSpreadsheetDialog dialog;
    JComponent contentPane = null;

    public OpenGoogleSpreadsheetCommand(JavaHighDApplication application, CPWindow window) {
        this.application = application;
        this.window = window;
    }

    public void execute() {
        if (this.dialog == null) {
            this.dialog = new OpenGoogleSpreadsheetDialog();
            AbstractAction action = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ProgressMonitor progressMonitor = new ProgressMonitor(OpenGoogleSpreadsheetCommand.this.contentPane, "Retrieving dataset", "", 0, Integer.MAX_VALUE);
                    progressMonitor.setMillisToDecideToPopup(50);
                    progressMonitor.setMillisToPopup(50);
                    new Thread(new Runnable(){

                        @Override
                        public void run() {
                            if (OpenGoogleSpreadsheetCommand.this.contentPane != null) {
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        OpenGoogleSpreadsheetCommand.this.contentPane.setCursor(new Cursor(3));
                                    }
                                });
                            }
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    try {
                                        char[] chars = OpenGoogleSpreadsheetCommand.this.dialog.getPassword();
                                        String password = new String(chars);
                                        for (int i = 0; i < chars.length; ++i) {
                                            chars[i] = '\u0000';
                                        }
                                        final GoogleSpreadsheetDataSource dataSource = new GoogleSpreadsheetDataSource(OpenGoogleSpreadsheetCommand.this.dialog.getUsername(), password, OpenGoogleSpreadsheetCommand.this.dialog.getSpreadsheet());
                                        DocumentOpener documentOpener = new DocumentOpener<HighDDocument, Window, Component>(){

                                            public HighDDocument openDocument(CPWindow window) throws OpenDocumentException {
                                                try {
                                                    MutableDataFrame dataFrame = dataSource.loadDataFrame(null);
                                                    HighDDocument document = OpenGoogleSpreadsheetCommand.this.application.createDocument(OpenGoogleSpreadsheetCommand.this.dialog.getSpreadsheet(), "googlespreadsheet://" + OpenGoogleSpreadsheetCommand.this.dialog.getSpreadsheet(), (DataSource)dataSource, (MutableDataFrame<Integer, String, Object>)dataFrame);
                                                    return document;
                                                }
                                                catch (Exception e) {
                                                    throw new OpenDocumentException("Error", (Throwable)e);
                                                }
                                            }
                                        };
                                        OpenGoogleSpreadsheetCommand.this.application.openAndShowDocument(OpenGoogleSpreadsheetCommand.this.window, documentOpener, null);
                                    }
                                    catch (Exception e) {
                                        SwingLogging.getInstance().process((Component)OpenGoogleSpreadsheetCommand.this.contentPane, (Throwable)e);
                                    }
                                }
                            });
                            if (OpenGoogleSpreadsheetCommand.this.contentPane != null) {
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        OpenGoogleSpreadsheetCommand.this.contentPane.setCursor(new Cursor(0));
                                    }
                                });
                            }
                        }
                    }).start();
                }
            };
            this.dialog.setAction((Action)action);
        }
        this.dialog.setModal(true);
        this.dialog.pack();
        this.dialog.setLocationRelativeTo(null);
        this.dialog.setVisible(true);
    }
}

