/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.logging.Logger;
import org.geotools.data.DataSourceException;
import org.geotools.data.DataUtilities;
import org.geotools.data.FeatureReader;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.collection.FeatureIteratorImpl;
import org.geotools.feature.collection.SimpleFeatureIteratorImpl;
import org.geotools.feature.collection.SubFeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.util.logging.Logging;
import org.opengis.feature.FeatureVisitor;
import org.opengis.feature.IllegalAttributeException;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.sort.SortBy;
import org.opengis.geometry.BoundingBox;
import org.opengis.util.ProgressListener;

public class DefaultFeatureCollection
implements SimpleFeatureCollection,
Collection<SimpleFeature> {
    protected static Logger LOGGER = Logging.getLogger(DefaultFeatureCollection.class);
    private SortedMap<String, SimpleFeature> contents = new TreeMap<String, SimpleFeature>();
    private ReferencedEnvelope bounds = null;
    protected String id;
    protected SimpleFeatureType schema;

    public DefaultFeatureCollection() {
        this(null, null);
    }

    public DefaultFeatureCollection(FeatureCollection<SimpleFeatureType, SimpleFeature> collection) {
        this(collection.getID(), collection.getSchema());
        this.addAll(collection);
    }

    public DefaultFeatureCollection(String id) {
        this(id, null);
    }

    public DefaultFeatureCollection(String id, SimpleFeatureType memberType) {
        this.id = id == null ? "featureCollection" : id;
        this.schema = memberType;
    }

    @Override
    public ReferencedEnvelope getBounds() {
        if (this.bounds == null) {
            this.bounds = new ReferencedEnvelope();
            for (SimpleFeature simpleFeature : this.contents.values()) {
                BoundingBox geomBounds = simpleFeature.getBounds();
                if (geomBounds.isEmpty()) continue;
                this.bounds.include(geomBounds);
            }
        }
        return this.bounds;
    }

    @Override
    public boolean add(SimpleFeature o) {
        return this.add(o, true);
    }

    protected boolean add(SimpleFeature feature, boolean fire) {
        if (feature == null) {
            return false;
        }
        String ID = feature.getID();
        if (ID == null) {
            return false;
        }
        if (this.contents.containsKey(ID)) {
            return false;
        }
        if (this.schema == null) {
            this.schema = feature.getFeatureType();
        }
        SimpleFeatureType childType = this.getSchema();
        if (!feature.getFeatureType().equals(childType)) {
            LOGGER.warning("Feature Collection contains a heterogeneous mix of features");
        }
        this.contents.put(ID, feature);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addAll(Collection<? extends SimpleFeature> collection) {
        boolean changed = false;
        Iterator<? extends SimpleFeature> iterator = collection.iterator();
        try {
            while (iterator.hasNext()) {
                SimpleFeature f = iterator.next();
                boolean added = this.add(f, false);
                changed |= added;
            }
            boolean bl = changed;
            return bl;
        }
        finally {
            if (iterator instanceof FeatureIterator) {
                ((FeatureIterator)((Object)iterator)).close();
            }
        }
    }

    public boolean addAll(FeatureCollection<?, ?> collection) {
        boolean changed = false;
        try (FeatureIterator<?> iterator = collection.features();){
            while (iterator.hasNext()) {
                SimpleFeature f = (SimpleFeature)iterator.next();
                boolean added = this.add(f, false);
                changed |= added;
            }
            boolean bl = changed;
            return bl;
        }
    }

    @Override
    public void clear() {
        this.contents.clear();
    }

    @Override
    public boolean contains(Object o) {
        if (!(o instanceof SimpleFeature)) {
            return false;
        }
        SimpleFeature feature = (SimpleFeature)o;
        String ID = feature.getID();
        return this.contents.containsKey(ID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsAll(Collection<?> collection) {
        Iterator<?> iterator = collection.iterator();
        try {
            while (iterator.hasNext()) {
                SimpleFeature feature = (SimpleFeature)iterator.next();
                if (this.contents.containsKey(feature.getID())) continue;
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            if (iterator instanceof FeatureIterator) {
                ((FeatureIterator)((Object)iterator)).close();
            }
        }
    }

    @Override
    public boolean isEmpty() {
        return this.contents.isEmpty();
    }

    @Override
    public Iterator<SimpleFeature> iterator() {
        final Iterator<SimpleFeature> iterator = this.contents.values().iterator();
        return new Iterator<SimpleFeature>(){
            SimpleFeature currFeature = null;

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public SimpleFeature next() {
                this.currFeature = (SimpleFeature)iterator.next();
                return this.currFeature;
            }

            @Override
            public void remove() {
                iterator.remove();
                DefaultFeatureCollection.this.bounds = null;
            }
        };
    }

    @Override
    public SimpleFeatureIterator features() {
        return new SimpleFeatureIteratorImpl(this.contents.values());
    }

    @Override
    public boolean remove(Object o) {
        if (!(o instanceof SimpleFeature)) {
            return false;
        }
        SimpleFeature f = (SimpleFeature)o;
        boolean changed = this.contents.values().remove(f);
        return changed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeAll(Collection<?> collection) {
        boolean changed = false;
        Iterator<?> iterator = collection.iterator();
        try {
            while (iterator.hasNext()) {
                SimpleFeature f = (SimpleFeature)iterator.next();
                boolean removed = this.contents.values().remove(f);
                if (!removed) continue;
                changed = true;
            }
            boolean bl = changed;
            return bl;
        }
        finally {
            if (iterator instanceof FeatureIterator) {
                ((FeatureIterator)((Object)iterator)).close();
            }
        }
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        boolean modified = false;
        Iterator<SimpleFeature> it = this.contents.values().iterator();
        while (it.hasNext()) {
            SimpleFeature f = it.next();
            if (collection.contains(f)) continue;
            it.remove();
            modified = true;
        }
        return modified;
    }

    @Override
    public int size() {
        return this.contents.size();
    }

    @Override
    public Object[] toArray() {
        return this.contents.values().toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.contents.values().toArray(a);
    }

    public void close(FeatureIterator<SimpleFeature> close) {
        if (close instanceof FeatureIteratorImpl) {
            FeatureIteratorImpl wrapper = (FeatureIteratorImpl)close;
            wrapper.close();
        }
    }

    public FeatureReader<SimpleFeatureType, SimpleFeature> reader() throws IOException {
        final SimpleFeatureIterator iterator = this.features();
        return new FeatureReader<SimpleFeatureType, SimpleFeature>(){

            @Override
            public SimpleFeatureType getFeatureType() {
                return DefaultFeatureCollection.this.getSchema();
            }

            @Override
            public SimpleFeature next() throws IOException, IllegalAttributeException, NoSuchElementException {
                return (SimpleFeature)iterator.next();
            }

            @Override
            public boolean hasNext() throws IOException {
                return iterator.hasNext();
            }

            @Override
            public void close() throws IOException {
                DefaultFeatureCollection.this.close(iterator);
            }
        };
    }

    public int getCount() throws IOException {
        return this.contents.size();
    }

    public SimpleFeatureCollection collection() throws IOException {
        DefaultFeatureCollection copy = new DefaultFeatureCollection(null, this.getSchema());
        ArrayList<SimpleFeature> list = new ArrayList<SimpleFeature>(this.contents.size());
        try (SimpleFeatureIterator iterator = this.features();){
            while (iterator.hasNext()) {
                SimpleFeature duplicate;
                SimpleFeature feature = (SimpleFeature)iterator.next();
                try {
                    duplicate = SimpleFeatureBuilder.copy(feature);
                }
                catch (IllegalAttributeException e) {
                    throw new DataSourceException("Unable to copy " + feature.getID(), e);
                }
                list.add(duplicate);
            }
        }
        copy.addAll((Collection<? extends SimpleFeature>)list);
        return copy;
    }

    public Set fids() {
        return Collections.unmodifiableSet(this.contents.keySet());
    }

    @Override
    public void accepts(FeatureVisitor visitor, ProgressListener progress) throws IOException {
        DataUtilities.visit(this, visitor, progress);
    }

    @Override
    public SimpleFeatureCollection subCollection(Filter filter) {
        if (filter == Filter.INCLUDE) {
            return this;
        }
        return new SubFeatureCollection(this, filter);
    }

    @Override
    public SimpleFeatureCollection sort(SortBy order) {
        if (order == SortBy.NATURAL_ORDER) {
            return this;
        }
        return null;
    }

    public void purge() {
    }

    public void validate() {
    }

    @Override
    public String getID() {
        return this.id;
    }

    @Override
    public SimpleFeatureType getSchema() {
        return this.schema;
    }
}

