/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.swing.fastvoronoi.originalconvexhull;

import com.macrofocus.geom.Rectangle2D;
import com.treemap.swing.fastvoronoi.originalconvexhull.ConvexHull;
import com.treemap.swing.fastvoronoi.originalconvexhull.Edge;
import com.treemap.swing.fastvoronoi.originalconvexhull.Facet;
import com.treemap.swing.fastvoronoi.originalconvexhull.OpenList;
import com.treemap.swing.fastvoronoi.originalconvexhull.Site;
import com.treemap.swing.fastvoronoi.originalconvexhull.Vertex;
import com.treemap.swing.fastvoronoi.polygon.Point2D;
import com.treemap.swing.fastvoronoi.polygon.PolygonSimple;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class PowerDiagram {
    public static Random rand = new Random(99L);
    public static final int halfLineScalingFactor = 10000;
    private static final double numericError = 1.0E-10;
    public static boolean debug = true;
    public ConvexHull hull = null;
    protected OpenList sites;
    protected PolygonSimple clipPoly;
    private int amountPolygons;
    private Rectangle2D bb;
    protected List<Facet> facets = null;
    Site s1;
    Site s2;
    Site s3;
    Site s4;

    public PowerDiagram() {
        this.sites = null;
        this.clipPoly = null;
    }

    public PowerDiagram(OpenList sites, PolygonSimple clipPoly) {
        this.setSites(sites);
        this.setClipPoly(clipPoly);
    }

    public void setSites(OpenList sites) {
        this.sites = sites;
        this.hull = null;
    }

    public void setClipPoly(PolygonSimple polygon) {
        this.clipPoly = polygon;
        this.bb = polygon.getBounds2D();
        double minX = this.bb.getMinX();
        double minY = this.bb.getMinY();
        double width = this.bb.getWidth();
        double height = this.bb.getHeight();
        this.s1 = new Site(minX - width, minY - height);
        this.s2 = new Site(minX + 2.0 * width, minY - height);
        this.s3 = new Site(minX + 2.0 * width, minY + 2.0 * height);
        this.s4 = new Site(minX - width, minY + 2.0 * height);
        this.s1.setAsDummy();
        this.s2.setAsDummy();
        this.s3.setAsDummy();
        this.s4.setAsDummy();
    }

    public PolygonSimple getClipPoly() {
        return this.clipPoly;
    }

    public void computeDiagram() {
        if (this.sites.size > 0) {
            this.sites.permutate();
            this.hull = new ConvexHull();
            Site[] array = this.sites.array;
            int size = this.sites.size;
            for (int z = 0; z < size; ++z) {
                Site s = array[z];
                if (Double.isNaN(s.getWeight())) {
                    throw new RuntimeException("Weight of a Site may not be NaN.");
                }
                if (Double.isInfinite(s.getWeight())) {
                    throw new RuntimeException("Weight of a Site may not be infinite.");
                }
                this.hull.addPoint(s);
            }
            this.s1.clear();
            this.s2.clear();
            this.s3.clear();
            this.s4.clear();
            this.hull.addPoint(this.s1);
            this.hull.addPoint(this.s2);
            this.hull.addPoint(this.s3);
            this.hull.addPoint(this.s4);
            this.facets = this.hull.compute();
            this.computeData();
        }
    }

    public void writeHullTestCodeOut(Site s) {
        System.out.println("hull.addPoint(" + s.x + "," + s.y + "," + s.z + ");");
    }

    private void computeData() {
        int vertexCount = this.hull.getVertexCount();
        boolean[] verticesVisited = new boolean[vertexCount];
        int facetCount = this.facets.size();
        for (int i = 0; i < facetCount; ++i) {
            Facet facet = this.facets.get(i);
            if (!facet.isVisibleFromBelow()) continue;
            for (int e = 0; e < 3; ++e) {
                Edge edge = facet.getEdge(e);
                Vertex destVertex = edge.getDest();
                Site site = (Site)destVertex.originalObject;
                if (verticesVisited[destVertex.getIndex()]) continue;
                verticesVisited[destVertex.getIndex()] = true;
                if (site.isDummy) continue;
                ArrayList<Facet> faces = this.getFacesOfDestVertex(edge);
                PolygonSimple poly = new PolygonSimple();
                double lastX = Double.NaN;
                double lastY = Double.NaN;
                double dx = 1.0;
                double dy = 1.0;
                for (Facet face : faces) {
                    Point2D point = face.getDualPoint();
                    double x1 = point.getX();
                    double y1 = point.getY();
                    if (!Double.isNaN(lastX)) {
                        dx = lastX - x1;
                        dy = lastY - y1;
                        if (dx < 0.0) {
                            dx = -dx;
                        }
                        if (dy < 0.0) {
                            dy = -dy;
                        }
                    }
                    if (!(dx > 1.0E-10) && !(dy > 1.0E-10)) continue;
                    poly.add(x1, y1);
                    lastX = x1;
                    lastY = y1;
                }
                site.nonClippedPolyon = poly;
                if (site.isDummy) continue;
                try {
                    site.setPolygon(this.clipPoly.convexClip(poly));
                    continue;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    private ArrayList<Facet> getFacesOfDestVertex(Edge edge) {
        ArrayList<Facet> faces = new ArrayList<Facet>();
        Edge previous = edge;
        Vertex first = edge.getDest();
        Site site = (Site)first.originalObject;
        ArrayList<Site> neighbours = new ArrayList<Site>();
        do {
            Facet iFace;
            previous = previous.getTwin().getPrev();
            Site siteOrigin = (Site)previous.getSource().originalObject;
            if (!siteOrigin.isDummy) {
                neighbours.add(siteOrigin);
            }
            if (!(iFace = previous.getFacet()).isVisibleFromBelow()) continue;
            faces.add(iFace);
        } while (previous != edge);
        site.setNeighbours(neighbours);
        return faces;
    }

    public void setAmountPolygons(int amountPolygons) {
        this.amountPolygons = amountPolygons;
    }

    public int getAmountPolygons() {
        return this.amountPolygons;
    }

    public static void main(String[] args) {
        Site site;
        int i;
        PowerDiagram diagram = new PowerDiagram();
        OpenList sites = new OpenList();
        Random rand = new Random(100L);
        PolygonSimple rootPolygon = new PolygonSimple();
        int width = 1000;
        int height = 1000;
        rootPolygon.add(0.0, 0.0);
        rootPolygon.add(width, 0.0);
        rootPolygon.add(width, height);
        rootPolygon.add(0.0, height);
        for (i = 0; i < 100; ++i) {
            site = new Site(rand.nextInt(width), rand.nextInt(width));
            sites.add(site);
        }
        diagram.setSites(sites);
        diagram.setClipPoly(rootPolygon);
        diagram.computeDiagram();
        for (i = 0; i < sites.size; ++i) {
            site = sites.array[i];
            PolygonSimple polygonSimple = site.getPolygon();
        }
    }
}

