/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.swing.originalfastvoronoi.pd.gui;

import com.treemap.swing.originalfastvoronoi.j2d.Point2D;
import com.treemap.swing.originalfastvoronoi.j2d.Site;
import com.treemap.swing.originalfastvoronoi.pd.gui.JPolygon;
import com.treemap.swing.originalfastvoronoi.pd.gui.PowerBox;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Random;

public class JSite
extends JPolygon {
    private static Random rand = new Random();
    private Site site;
    boolean pressed = false;
    private static final long serialVersionUID = 1L;

    public JSite(final Site site) {
        this(rand.nextInt());
        this.site = site;
        this.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseMoved(MouseEvent e) {
            }

            @Override
            public synchronized void mouseDragged(MouseEvent e) {
                Point point = e.getPoint();
                double dx = JSite.this.getLocation().getX();
                double dy = JSite.this.getLocation().getY();
                double x = point.getX() + dx;
                double y = point.getY() + dy;
                site.setXY(x, y);
                PowerBox.powerBox.computeDiagram();
            }
        });
        this.addMouseListener(new MouseListener(){

            @Override
            public synchronized void mouseReleased(MouseEvent e) {
                if (JSite.this.pressed) {
                    Point point = e.getPoint();
                    double dx = JSite.this.getLocation().getX();
                    double dy = JSite.this.getLocation().getY();
                    double x = point.getX() + dx;
                    double y = point.getY() + dy;
                    site.setXY(x, y);
                }
                PowerBox.powerBox.computeDiagram();
                JSite.this.pressed = false;
            }

            @Override
            public void mousePressed(MouseEvent e) {
                Point point = e.getPoint();
                double currentX = point.getX();
                double currentY = point.getY();
                Site site2 = new Site(currentX, currentY);
                if (site.distance(site2) < 10.0) {
                    JSite.this.pressed = true;
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                int modifiers = mouseEvent.getModifiers();
                if ((modifiers & 0x10) == 16) {
                    System.out.println("Left button pressed.");
                    site.setWeight(Math.pow(Math.sqrt(site.getWeight()) + 10.0, 2.0));
                }
                if ((modifiers & 8) == 8) {
                    System.out.println("Middle button pressed.");
                }
                if ((modifiers & 4) == 4) {
                    site.setWeight(Math.pow(Math.sqrt(site.getWeight()) - 10.0, 2.0));
                }
            }
        });
    }

    public JSite(Integer id) {
        super(id);
    }

    protected void setSite(Site site) {
        this.site = site;
    }

    protected Site getSite() {
        return this.site;
    }

    @Override
    public void paintComponent(Graphics g) {
    }

    @Override
    public boolean contains(int x, int y) {
        double distance = new Point2D(x + this.getLocation().x, y + this.getLocation().y).distance(this.site.getX(), this.site.getY());
        return distance < 10.0;
    }

    @Override
    public boolean contains(Point p) {
        return this.contains((int)p.getX(), (int)p.getY());
    }
}

