/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.swing.tagcloud;

import com.macrofocus.common.properties.MutableProperties;
import com.macrofocus.common.properties.MutableProperty;
import com.macrofocus.common.properties.SimpleProperties;
import com.macrofocus.crossplatform.swing.SwingFactory;
import com.macrofocus.geom.AffineTransform;
import com.macrofocus.geom.Rectangle2D;
import com.macrofocus.geom.Shape;
import com.macrofocus.igraphics.CPFont;
import com.macrofocus.igraphics.CPFontFactory;
import com.macrofocus.igraphics.swing.SwingFont;
import com.treemap.AbstractAlgorithm;
import com.treemap.DefaultTreeMapFieldSettings;
import com.treemap.MutableTreeMapNode;
import com.treemap.TreeMapWorker;
import com.treemap.swing.tagcloud.SwingWord;
import com.treemap.tagcloud.ArchimedeanSpiral;
import com.treemap.tagcloud.Orientation;
import com.treemap.tagcloud.Point2d;
import com.treemap.tagcloud.PositionIterator;
import com.treemap.tagcloud.TagCloudAlgorithm;
import com.treemap.tagcloud.TextShape;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;

public class LegacySwingTagCloudAlgorithm
extends AbstractAlgorithm
implements TagCloudAlgorithm {
    private final List<SwingWord> words = new ArrayList<SwingWord>();
    private SwingWord lastIntersectedWord;
    private BufferedImage imageToHaveGraphics = new BufferedImage(1, 1, 10);
    private int maxTags = 500;
    private int nSubdivisions = 6;
    private final MutableProperties properties = new SimpleProperties();
    private final MutableProperty<CPFont<Font>> font = this.properties.createProperty((Object)"font", (Object)DefaultTreeMapFieldSettings.getDefaultLabelingFont((CPFontFactory)SwingFactory.getInstance()));
    private final MutableProperty<TagCloudAlgorithm.OrientationMode> orientationMode = this.properties.createProperty((Object)"orientationMode", (Object)TagCloudAlgorithm.OrientationMode.AllHorizontal);
    private final MutableProperty<TagCloudAlgorithm.Spiral> spiral = this.properties.createProperty((Object)"spiral", (Object)TagCloudAlgorithm.Spiral.Rectangular);

    public LegacySwingTagCloudAlgorithm() {
    }

    public LegacySwingTagCloudAlgorithm(TagCloudAlgorithm.OrientationMode orientationMode, TagCloudAlgorithm.Spiral spiral, Font font) {
        this.orientationMode.setValue((Object)orientationMode);
        this.spiral.setValue((Object)spiral);
        this.font.setValue((Object)new SwingFont(font));
    }

    public MutableProperties getProperties() {
        return this.properties;
    }

    public boolean breadthFirstLayout(Shape shape, MutableTreeMapNode parent, MutableTreeMapNode[] children, double sumSizes, int horizontalVanishingPoint, int verticalVanishingPoint, TreeMapWorker worker) {
        long startMillis = System.currentTimeMillis();
        this.words.clear();
        ArrayList<SwingWord> placedWords = new ArrayList<SwingWord>();
        Random random = new Random(1L);
        Graphics2D g = (Graphics2D)this.imageToHaveGraphics.getGraphics();
        if (this.font.getValue() != null) {
            g.setFont((Font)((CPFont)this.font.getValue()).getNativeFont());
        }
        int count = Math.min(this.maxTags, children.length);
        for (int i = 0; i < count; ++i) {
            boolean vertical;
            if (worker != null && worker.isCancelled()) {
                return true;
            }
            MutableTreeMapNode child = children[i];
            String text = child.toString();
            switch ((TagCloudAlgorithm.OrientationMode)this.orientationMode.getValue()) {
                case AllHorizontal: {
                    vertical = false;
                    break;
                }
                case HorizontalAndVertical: {
                    vertical = random.nextBoolean();
                    break;
                }
                default: {
                    vertical = false;
                }
            }
            Orientation orientation = vertical ? Orientation.Vertical : Orientation.Horizontal;
            double p = child.getSize() / sumSizes;
            this.words.add(new SwingWord(g, text, p, child, orientation, this.nSubdivisions));
        }
        if (worker != null && worker.isCancelled()) {
            return true;
        }
        Collections.sort(this.words);
        Collections.reverse(this.words);
        ArchimedeanSpiral spiral = null;
        switch ((TagCloudAlgorithm.Spiral)this.spiral.getValue()) {
            case Archimedean: {
                spiral = new ArchimedeanSpiral(this.words.get(this.words.size() - 1).getShapeForLayout().getBounds2D().getHeight() * 0.05);
                break;
            }
            case Rectangular: {
                spiral = null;
            }
        }
        Point2d position = new Point2d(0.0, 0.0);
        PositionIterator positionIterator = new PositionIterator(shape);
        double totalMaximumSideLength = 0.0;
        this.lastIntersectedWord = null;
        int counter = 0;
        for (SwingWord word : this.words) {
            if (worker != null && worker.isCancelled()) {
                return true;
            }
            double wordWidth = word.getShapeForLayout().getBounds2D().getWidth();
            double wordHeight = word.getShapeForLayout().getBounds2D().getHeight();
            double minSideLength = Math.min(wordWidth, wordHeight);
            double maxSideLength = Math.max(wordWidth, wordHeight);
            totalMaximumSideLength = Math.max(maxSideLength, totalMaximumSideLength);
            double stepSize = maxSideLength / 10.0;
            stepSize = Math.max(stepSize, totalMaximumSideLength / 20.0);
            positionIterator.resetIterator(stepSize);
            double theta = Math.PI * 2;
            int stepIncreaseCounter = 0;
            boolean debug = false;
            while (this.newWordIntersectsPlacedWords(word, placedWords)) {
                if (spiral != null) {
                    spiral.get(theta, position);
                    double d = 2.0 * spiral.getRadius(theta);
                    double dTheta = 0.5 / d * 2.0;
                    theta += dTheta;
                } else {
                    if (stepIncreaseCounter > 100) {
                        positionIterator.doubleStepSize();
                        stepIncreaseCounter = 0;
                    }
                    positionIterator.getNextPosition(position);
                }
                word.setLocation(position);
                ++counter;
            }
            placedWords.add(word);
            ++counter;
        }
        for (MutableTreeMapNode child : children) {
            child.setShape(null);
        }
        this.createDiagramShapes(shape, placedWords);
        return false;
    }

    private void createDiagramShapes(Shape shape, List<SwingWord> placedWords) {
        Rectangle2D.Double diagramBoundsNormed = new Rectangle2D.Double();
        for (SwingWord placedWord : placedWords) {
            Rectangle2D bounds2D = placedWord.getShapeForLayout().getBounds2D();
            diagramBoundsNormed.add(new Rectangle2D.Double(bounds2D.getX(), bounds2D.getY(), bounds2D.getWidth(), bounds2D.getHeight()));
        }
        Rectangle2D domainBoundsAbsolute = shape.getBounds2D();
        double domainAspect = domainBoundsAbsolute.getWidth() / domainBoundsAbsolute.getHeight();
        double diagramAspect = ((RectangularShape)diagramBoundsNormed).getWidth() / ((RectangularShape)diagramBoundsNormed).getHeight();
        double scale = diagramAspect > domainAspect ? domainBoundsAbsolute.getWidth() / ((RectangularShape)diagramBoundsNormed).getWidth() : domainBoundsAbsolute.getHeight() / ((RectangularShape)diagramBoundsNormed).getHeight();
        double widthDiff = domainBoundsAbsolute.getWidth() - ((RectangularShape)diagramBoundsNormed).getWidth() * scale;
        double heightDiff = domainBoundsAbsolute.getHeight() - ((RectangularShape)diagramBoundsNormed).getHeight() * scale;
        Point2d offsetAbsolute = new Point2d(domainBoundsAbsolute.getX() - ((RectangularShape)diagramBoundsNormed).getX() * scale + widthDiff / 2.0, domainBoundsAbsolute.getY() - ((RectangularShape)diagramBoundsNormed).getY() * scale + heightDiff / 2.0);
        for (SwingWord word : placedWords) {
            Shape s = this.getShape(offsetAbsolute, scale, word.getShapeForLayout());
            word.getTreeMapNode().setShape(s);
        }
    }

    public Shape getShape(Point2d offsetAbsolute, double scale, TextShape shape) {
        AffineTransform transform = new AffineTransform(scale, 0.0, 0.0, scale, offsetAbsolute.x, offsetAbsolute.y);
        return shape.createTransformedShape(transform);
    }

    public boolean newWordIntersectsPlacedWords(SwingWord word, List<SwingWord> placedWords) {
        if (this.lastIntersectedWord != null && word.intersects(this.lastIntersectedWord)) {
            return true;
        }
        for (SwingWord placedWord : placedWords) {
            if (placedWord == this.lastIntersectedWord || !word.intersects(placedWord)) continue;
            this.lastIntersectedWord = placedWord;
            return true;
        }
        return false;
    }

    public boolean isCompatible(Shape shape) {
        return shape instanceof Rectangle2D;
    }

    public boolean isRenderingLeafLabelsSupported() {
        return false;
    }

    public boolean isRenderingParentLabelSupported() {
        return false;
    }

    public int getMaxTags() {
        return this.maxTags;
    }

    public void setMaxTags(int maxTags) {
        this.maxTags = maxTags;
    }

    public int getnSubdivisions() {
        return this.nSubdivisions;
    }

    public void setnSubdivisions(int nSubdivisions) {
        this.nSubdivisions = nSubdivisions;
    }

    public Font getFont() {
        return (Font)((CPFont)this.font.getValue()).getNativeFont();
    }

    public TagCloudAlgorithm.Spiral getSpiral() {
        return (TagCloudAlgorithm.Spiral)this.spiral.getValue();
    }

    public TagCloudAlgorithm.OrientationMode getOrientationMode() {
        return (TagCloudAlgorithm.OrientationMode)this.orientationMode.getValue();
    }

    public boolean isSpaceFilling() {
        return false;
    }

    public String toString() {
        return "Tag Cloud";
    }
}

