/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.swing.voronoi;

import com.macrofocus.common.geom.Dimension;
import com.macrofocus.geom.Point2D;
import com.macrofocus.geom.Rectangle2D;
import com.macrofocus.geom.Shape;
import com.treemap.swing.voronoi.Point2i;
import com.treemap.swing.voronoi.VoronoiCell;
import java.awt.Rectangle;

public class VoronoiOutputRaster {
    private VoronoiCell[][] cellRaster;
    private final Rectangle domainBounds = new Rectangle();
    private static Object lock = new Object();

    public void setDomain(Shape shape) {
        Rectangle2D bounds = shape.getBounds2D();
        if (this.cellRaster == null || !this.isLargeEnough(this.cellRaster, new Dimension((int)bounds.getWidth(), (int)bounds.getHeight()))) {
            this.cellRaster = new VoronoiCell[(int)bounds.getWidth()][(int)bounds.getHeight()];
        }
        this.domainBounds.setBounds((int)bounds.getX(), (int)bounds.getY(), (int)bounds.getWidth(), (int)bounds.getHeight());
        for (int x = this.domainBounds.x - 1; x < this.domainBounds.x + this.domainBounds.width + 1; ++x) {
            for (int y = this.domainBounds.y - 1; y < this.domainBounds.y + this.domainBounds.height + 1; ++y) {
                if (shape instanceof Rectangle2D && !bounds.contains((double)x, (double)y) || !shape.contains((Point2D)new Point2D.Double((double)x, (double)y))) {
                    this.set(x, y, VoronoiCell.outsideDomainCell);
                    continue;
                }
                this.set(x, y, null);
            }
        }
    }

    private boolean isLargeEnough(VoronoiCell[][] cellRaster, Dimension size) {
        int width = cellRaster.length;
        int height = cellRaster.length > 0 ? cellRaster[1].length : 0;
        return width >= size.width && height >= size.height;
    }

    public void getCellRasterSize(Dimension size) {
        if (size == null) {
            return;
        }
        boolean cellRasterIsNull = this.cellRaster == null;
        size.width = cellRasterIsNull ? 0 : this.cellRaster.length;
        size.height = !cellRasterIsNull && this.cellRaster.length > 0 ? this.cellRaster[1].length : 0;
    }

    private double[][] createDistanceLookUp(Dimension size) {
        double[][] distanceLookUp = new double[size.width][size.height];
        for (int x = 0; x < distanceLookUp.length; ++x) {
            double[] row = distanceLookUp[x];
            for (int y = 0; y < row.length; ++y) {
                row[y] = Math.sqrt(x * x + y * y);
            }
        }
        return distanceLookUp;
    }

    public int getWidth() {
        return this.domainBounds.width;
    }

    public int getHeight() {
        return this.domainBounds.height;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(int x, int y, VoronoiCell cell) {
        Object object = lock;
        synchronized (object) {
            try {
                this.cellRaster[x - this.domainBounds.x][y - this.domainBounds.y] = cell;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public VoronoiCell get(int x, int y) {
        try {
            return this.cellRaster[x - this.domainBounds.x][y - this.domainBounds.y];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return null;
        }
    }

    public VoronoiCell get(Point2i position) {
        return this.get(position.x, position.y);
    }

    public Rectangle getDomainBounds() {
        return this.domainBounds;
    }

    public VoronoiCell[][] getCellRaster() {
        return this.cellRaster;
    }
}

