/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.docking.controls;

import de.javasoft.docking.controls.ActiveDockableTracker;
import de.javasoft.docking.controls.DockingEvent;
import de.javasoft.docking.controls.DockingManager;
import de.javasoft.docking.controls.DockingUtility;
import de.javasoft.docking.controls.DragOperation;
import de.javasoft.docking.controls.DragPipeline;
import de.javasoft.docking.controls.IDockable;
import de.javasoft.docking.controls.IDockingPort;
import de.javasoft.docking.controls.IDockingStrategy;
import de.javasoft.docking.controls.RootWindow;
import de.javasoft.tabpane.JYTabbedPane;
import de.javasoft.widgets.util.WidgetUtils;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.FocusManager;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;

class DragManager
extends MouseAdapter
implements MouseMotionListener {
    private static final String DRAG_CONTEXT = "DragManager.DRAG_CONTEXT";
    private static DragOperation currentDragOperation;
    private IDockable dockable;
    private DragPipeline pipeline;
    private boolean enabled;
    private Point dragOrigin;
    private HashMap<Object, Object> dragContexts;
    private JRootPane dragStartRootPane;
    private PropertyChangeListener focusOwnerListener;

    public static void prime() {
    }

    public DragManager(IDockable dockable) {
        this.dockable = dockable;
    }

    @Override
    public void mousePressed(MouseEvent evt) {
        this.startDrag(evt);
    }

    @Override
    public void mouseReleased(MouseEvent evt) {
        this.finishDrag(evt);
    }

    @Override
    public void mouseDragged(MouseEvent evt) {
        if (!this.enabled) {
            return;
        }
        if (this.dragOrigin == null) {
            this.dragOrigin = evt.getPoint();
        }
        if (this.pipeline == null || !this.pipeline.isOpen()) {
            if (this.passedDragThreshold(evt)) {
                this.dragStartRootPane = SwingUtilities.getRootPane(this.dockable.getComponent());
                this.dragStartRootPane.setCursor(WidgetUtils.getDragCursor());
                this.openPipeline(evt);
            } else {
                evt.consume();
            }
        } else {
            this.pipeline.processDragEvent(evt);
        }
    }

    @Override
    public void mouseMoved(MouseEvent evt) {
    }

    private boolean passedDragThreshold(MouseEvent evt) {
        float threshold;
        double distance = this.dragOrigin.distance(evt.getPoint());
        return distance > (double)(threshold = this.dockable.getDragThreshold());
    }

    private void openPipeline(MouseEvent evt) {
        DragPipeline pipeline;
        DragOperation dragOp = new DragOperation(this.dockable.getComponent(), this.dragOrigin, evt);
        dragOp.setDragListener(this);
        DragManager.initializeListenerCaching(dragOp);
        this.focusOwnerListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent ev) {
                String name = ev.getPropertyName();
                if ("focusedWindow".equals(name)) {
                    DragManager.cancelCurrentDragOperation();
                }
            }
        };
        FocusManager.getCurrentManager().addPropertyChangeListener(this.focusOwnerListener);
        this.pipeline = pipeline = new DragPipeline();
        pipeline.open(dragOp);
    }

    private void startDrag(MouseEvent evt) {
        if (this.dockable == null || this.dockable.isDockingEnabled() == Boolean.FALSE.booleanValue() || evt.getButton() != 1) {
            this.enabled = false;
        } else {
            this.toggleDragContext(true);
            this.enabled = !DragManager.isDragCanceled(this.dockable, evt);
        }
    }

    private void finishDrag(MouseEvent evt) {
        if (this.pipeline == null || !this.dockable.isDockingEnabled()) {
            return;
        }
        this.drop(this.dockable, this.pipeline.getDragOperation(), evt);
        if (this.pipeline != null) {
            this.pipeline.close();
            RootWindow[] rootWindowArray = RootWindow.getVisibleWindows();
            int n = rootWindowArray.length;
            int n2 = 0;
            while (n2 < n) {
                RootWindow rw = rootWindowArray[n2];
                rw.getRootPane().setCursor(null);
                ++n2;
            }
        }
        this.toggleDragContext(false);
        this.dragOrigin = null;
        this.pipeline = null;
    }

    private void drop(IDockable dockable, DragOperation dragOp, MouseEvent mouseEvt) {
        IDockable maximizedDockable;
        FocusManager.getCurrentManager().removePropertyChangeListener(this.focusOwnerListener);
        if (DockingManager.isMaximized(dockable)) {
            DockingManager.setMaximized(dockable, DockingManager.getPerspectiveManager().getCurrentPerspective(), false);
        }
        if ((maximizedDockable = DockingManager.getMaximizedDockable(dragOp.getTargetPort())) != null) {
            DockingManager.toggleMaximized(maximizedDockable, DockingManager.getPerspectiveManager().getCurrentPerspective());
        }
        IDockingStrategy docker = DockingManager.getDockingStrategy(dockable);
        IDockingPort currentPort = DockingUtility.getParentDockingPort(dockable);
        IDockingPort targetPort = dragOp.getTargetPort();
        String region = dragOp.getTargetRegion();
        boolean overWindow = dragOp.isOverWindow();
        DragManager.restoreCachedListeners(dragOp);
        DockingEvent evt = new DockingEvent(dockable, currentPort, targetPort, 3, mouseEvt, DragManager.getDragContext(this.dockable));
        evt.setRegion(region);
        evt.setOverWindow(overWindow);
        if (!dragOp.isCanceled()) {
            DockingManager.dispatchEvent(evt);
        }
        if (!dragOp.isCanceled() && !evt.isConsumed()) {
            Component oldFocusOwner = SwingUtilities.getWindowAncestor(dockable.getComponent()).getFocusOwner();
            if (dragOp.getDropTabIndex() >= 0 && targetPort != null && targetPort.getDockedComponent() instanceof JYTabbedPane) {
                final JYTabbedPane tabPane = (JYTabbedPane)targetPort.getDockedComponent();
                int selectedIndex = tabPane.getSelectedIndex();
                final int dropTabIndex = dragOp.getDropTabIndex();
                if (tabPane.getComponentAt(selectedIndex) == dockable.getComponent()) {
                    tabPane.moveTab(selectedIndex, dropTabIndex);
                } else {
                    docker.dock(dockable, targetPort, DockingManager.getPerspectiveManager().getCurrentPerspective(), region);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            tabPane.moveTab(tabPane.getSelectedIndex(), dropTabIndex);
                        }
                    });
                }
            } else {
                docker.dock(dockable, targetPort, DockingManager.getPerspectiveManager().getCurrentPerspective(), region);
            }
            ActiveDockableTracker.requestDockableActivation(dockable.getComponent(), oldFocusOwner, true);
        }
    }

    private static void initializeListenerCaching(DragOperation dragOp) {
        Component dragSrc = dragOp.getDragSource();
        EventListener[] cachedListeners = dragSrc.getListeners(MouseMotionListener.class);
        dragOp.setCachedListeners(cachedListeners);
        DragManager dragListener = dragOp.getDragListener();
        int i = 0;
        while (i < cachedListeners.length) {
            dragSrc.removeMouseMotionListener((MouseMotionListener)cachedListeners[i]);
            ++i;
        }
        if (dragListener != null) {
            dragSrc.addMouseMotionListener(dragListener);
        }
    }

    private static void restoreCachedListeners(DragOperation dragOp) {
        Component dragSrc = dragOp.getDragSource();
        EventListener[] cachedListeners = dragOp.getCachedListeners();
        DragManager dragListener = dragOp.getDragListener();
        if (dragListener != null) {
            dragSrc.removeMouseMotionListener(dragListener);
        }
        int i = 0;
        while (i < cachedListeners.length) {
            dragSrc.addMouseMotionListener((MouseMotionListener)cachedListeners[i]);
            ++i;
        }
    }

    private static boolean isDragCanceled(IDockable dockable, MouseEvent trigger) {
        IDockingPort port = DockingUtility.getParentDockingPort(dockable);
        Map<Object, Object> dragContext = DragManager.getDragContext(dockable);
        DockingEvent evt = new DockingEvent(dockable, port, null, 2, trigger, dragContext);
        DockingManager.dispatchEvent(evt);
        return evt.isConsumed();
    }

    private void toggleDragContext(boolean add) {
        if (add) {
            if (this.dragContexts == null) {
                this.dragContexts = new HashMap();
                this.dockable.getComponent().putClientProperty(DRAG_CONTEXT, this.dragContexts);
            }
        } else {
            if (this.dragContexts != null) {
                this.dragContexts.clear();
                this.dragContexts = null;
            }
            this.dockable.getComponent().putClientProperty(DRAG_CONTEXT, null);
        }
    }

    static DragOperation getCurrentDragOperation() {
        return currentDragOperation;
    }

    static void cancelCurrentDragOperation() {
        currentDragOperation.setCanceled(true);
        DragManager m = DockingManager.getDragListener(currentDragOperation.getDockableReference());
        m.finishDrag(null);
    }

    static void setCurrentDragOperation(DragOperation operation) {
        currentDragOperation = operation;
    }

    static Map<Object, Object> getDragContext(IDockable dockable) {
        return dockable == null ? null : (Map)dockable.getComponent().getClientProperty(DRAG_CONTEXT);
    }
}

