/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.docking.ui;

import de.javasoft.docking.controls.Dockbar;
import de.javasoft.docking.controls.DockbarLabel;
import de.javasoft.docking.ui.BasicDockingPainter;
import de.javasoft.docking.ui.DockbarLabelUI;
import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.SyntheticaState;
import de.javasoft.widgets.util.WidgetUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.UIResource;

public class BasicDockbarLabelUI
extends DockbarLabelUI {
    protected DockbarLabel label;

    public static ComponentUI createUI(JComponent c) {
        return new BasicDockbarLabelUI();
    }

    public void installUI(JComponent c) {
        this.label = (DockbarLabel)((Object)c);
        super.installUI(c);
        this.installDefaults();
        this.installListener();
    }

    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
        this.uninstallDefaults();
        this.uninstallListener();
    }

    protected void installDefaults() {
        this.updateDefaults();
    }

    protected void uninstallDefaults() {
    }

    protected void installListener() {
        this.label.addPropertyChangeListener((PropertyChangeListener)((Object)this));
    }

    protected void uninstallListener() {
        this.label.removePropertyChangeListener((PropertyChangeListener)((Object)this));
    }

    private void updateDefaults() {
        Color foreground;
        Font font = this.label.getFont();
        if (font == null || font instanceof UIResource) {
            String fontName;
            float fontSize;
            Font labelFont = UIManager.getFont("Label.font");
            int style = 0;
            String fontStyle = SyntheticaLookAndFeel.getString((String)"JYDocking.dockbarLabel.font.style", (Component)((Object)this.label));
            if (fontStyle != null) {
                if (fontStyle.contains("BOLD")) {
                    style |= 1;
                }
                if (fontStyle.contains("ITALIC")) {
                    style |= 2;
                }
            }
            if ((fontSize = SyntheticaLookAndFeel.getInstance().scaleFontSize((float)SyntheticaLookAndFeel.getInt((String)"JYDocking.dockbarLabel.font.size", (Component)((Object)this.label), (int)0))) == 0.0f) {
                fontSize = labelFont.getSize();
            }
            if ((fontName = SyntheticaLookAndFeel.getString((String)"JYDocking.dockbarLabel.font.name", (Component)((Object)this.label))) == null) {
                fontName = labelFont.getFamily();
            }
            this.label.setFont(new FontUIResource(fontName, style, (int)fontSize));
        }
        if ((foreground = this.label.getForeground()) == null || foreground instanceof UIResource) {
            this.label.setForeground(SyntheticaLookAndFeel.getColor((String)"JYDocking.dockbarLabel.foreground", (Component)((Object)this.label), (Color)foreground));
        }
        this.label.setOpaque(SyntheticaLookAndFeel.getBoolean((String)"JYDocking.dockbarLabel.opaque", (Component)((Object)this.label), (boolean)false));
        this.updateInsets(this.label.getPlacement());
    }

    public void paint(Graphics g, JComponent c) {
        int x = 0;
        int y = 0;
        int w = c.getWidth();
        int h = c.getHeight();
        this.paintBackground(c, g, x, y, w, h, ((DockbarLabel)((Object)c)).getPlacement());
        super.paint(g, c);
    }

    protected void paintBackground(JComponent c, Graphics g, int x, int y, int w, int h, int placement) {
        BasicDockingPainter.getInstance().paintDockingDockbarLabelBackground(c, new SyntheticaState(), g, x, y, w, h, placement);
    }

    protected void updateInsets(int placement) {
        Insets insets = SyntheticaLookAndFeel.getInsets((String)("JYDocking.dockbarLabel." + Dockbar.placementAsString(placement) + ".insets"), (Component)((Object)this.label));
        if (insets == null) {
            insets = placement == 3 ? new Insets(2, 2, 2, 2) : (placement == 4 ? new Insets(2, 2, 2, 2) : new Insets(2, 2, 2, 2));
        }
        this.label.setBorder(SyntheticaLookAndFeel.getInstance().createEmptyBorder(insets, true));
    }

    public void propertyChange(PropertyChangeEvent evt) {
        String name = evt.getPropertyName();
        if (WidgetUtils.shouldUpdateStyle((PropertyChangeEvent)evt)) {
            this.updateDefaults();
        }
        if ("placement".equals(name)) {
            this.updateInsets((Integer)evt.getNewValue());
        }
    }
}

