/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.docking.ui.controls;

import de.javasoft.docking.controls.DockingManager;
import de.javasoft.docking.controls.IDockable;
import de.javasoft.docking.ui.controls.AbstractDockingViewAction;
import de.javasoft.docking.ui.controls.DockingButton;
import java.awt.event.ActionEvent;
import javax.swing.ButtonModel;
import javax.swing.UIManager;

public class DefaultFloatAction
extends AbstractDockingViewAction {
    private static final long serialVersionUID = -955701909596481030L;

    public DefaultFloatAction(IDockable dockable) {
        super(dockable);
        this.putValue("ShortDescription", UIManager.get("JYDocking.titlebar.floatButton.toolTip"));
        this.putValue("ShortDescriptionselected", UIManager.get("JYDocking.titlebar.floatButton.selected.toolTip"));
    }

    @Override
    public void actionPerformed(IDockable dockable, ActionEvent evt) {
        boolean floating = DockingManager.isFloating(dockable);
        DockingManager.setFloating(dockable, !floating);
    }

    @Override
    public ButtonModel createButtonModel() {
        return new DockingButton.DockingButtonModel(){

            @Override
            public boolean isSelected() {
                IDockable d = DefaultFloatAction.this.getDockable();
                return d == null ? false : DockingManager.isFloating(d);
            }
        };
    }
}

