/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.docking.ui.controls;

import de.javasoft.docking.JYDockingView;
import de.javasoft.docking.ui.DockingButtonUI;
import java.awt.event.MouseEvent;
import javax.swing.Action;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import org.jdesktop.swingx.plaf.LookAndFeelAddons;

public class DockingButton
extends JToggleButton {
    private static final long serialVersionUID = -925672904214207928L;
    public static final String uiClassID = "JYDockingButtonUI";

    public DockingButton(Action action) {
        this.setAction(action);
        this.setModel(new DockingButtonModel());
    }

    @Override
    public void setModel(ButtonModel newModel) {
        ButtonModel oldModel = this.getModel();
        if (newModel != null && oldModel != null) {
            newModel.setSelected(oldModel.isSelected());
        }
        super.setModel(newModel);
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    @Override
    public void updateUI() {
        this.setUI(LookAndFeelAddons.getUI((JComponent)this, DockingButtonUI.class));
    }

    @Override
    public String getToolTipText(MouseEvent evt) {
        return (String)this.getAction().getValue("ShortDescription" + (this.isSelected() ? "selected" : ""));
    }

    public JYDockingView getView() {
        return (JYDockingView)SwingUtilities.getAncestorOfClass(JYDockingView.class, this);
    }

    static class DockingButtonModel
    extends JToggleButton.ToggleButtonModel {
        private static final long serialVersionUID = 877449419218567278L;

        DockingButtonModel() {
        }
    }
}

