/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.overlayng;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.locationtech.jts.algorithm.locate.IndexedPointInAreaLocator;
import org.locationtech.jts.algorithm.locate.PointOnGeometryLocator;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateFilter;
import org.locationtech.jts.geom.CoordinateList;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.operation.overlayng.IndexedPointOnLineLocator;
import org.locationtech.jts.operation.overlayng.OverlayNG;
import org.locationtech.jts.operation.overlayng.OverlayUtil;
import org.locationtech.jts.util.Assert;

class OverlayMixedPoints {
    private final int opCode;
    private final PrecisionModel pm;
    private final Geometry geomPoint;
    private final Geometry geomNonPointInput;
    private final GeometryFactory geometryFactory;
    private final boolean isPointRHS;
    private Geometry geomNonPoint;
    private int geomNonPointDim;
    private PointOnGeometryLocator locator;
    private int resultDim;

    public static Geometry overlay(int opCode, Geometry geom0, Geometry geom1, PrecisionModel pm) {
        OverlayMixedPoints overlay = new OverlayMixedPoints(opCode, geom0, geom1, pm);
        return overlay.getResult();
    }

    public OverlayMixedPoints(int opCode, Geometry geom0, Geometry geom1, PrecisionModel pm) {
        this.opCode = opCode;
        this.pm = pm;
        this.geometryFactory = geom0.getFactory();
        this.resultDim = OverlayUtil.resultDimension(opCode, geom0.getDimension(), geom1.getDimension());
        if (geom0.getDimension() == 0) {
            this.geomPoint = geom0;
            this.geomNonPointInput = geom1;
            this.isPointRHS = false;
        } else {
            this.geomPoint = geom1;
            this.geomNonPointInput = geom0;
            this.isPointRHS = true;
        }
    }

    public Geometry getResult() {
        this.geomNonPoint = this.prepareNonPoint(this.geomNonPointInput);
        this.geomNonPointDim = this.geomNonPoint.getDimension();
        this.locator = this.createLocator(this.geomNonPoint);
        Coordinate[] coords = OverlayMixedPoints.extractCoordinates(this.geomPoint, this.pm);
        switch (this.opCode) {
            case 1: {
                return this.computeIntersection(coords);
            }
            case 2: 
            case 4: {
                return this.computeUnion(coords);
            }
            case 3: {
                return this.computeDifference(coords);
            }
        }
        Assert.shouldNeverReachHere("Unknown overlay op code");
        return null;
    }

    private PointOnGeometryLocator createLocator(Geometry geomNonPoint) {
        if (this.geomNonPointDim == 2) {
            return new IndexedPointInAreaLocator(geomNonPoint);
        }
        return new IndexedPointOnLineLocator(geomNonPoint);
    }

    private Geometry prepareNonPoint(Geometry geomInput) {
        if (this.resultDim == 0) {
            return geomInput;
        }
        Geometry geomPrep = OverlayNG.union(this.geomNonPointInput, this.pm);
        return geomPrep;
    }

    private Geometry computeIntersection(Coordinate[] coords) {
        return this.createPointResult(this.findPoints(true, coords));
    }

    private Geometry computeUnion(Coordinate[] coords) {
        List<Point> resultPointList = this.findPoints(false, coords);
        List<LineString> resultLineList = null;
        if (this.geomNonPointDim == 1) {
            resultLineList = OverlayMixedPoints.extractLines(this.geomNonPoint);
        }
        List<Polygon> resultPolyList = null;
        if (this.geomNonPointDim == 2) {
            resultPolyList = OverlayMixedPoints.extractPolygons(this.geomNonPoint);
        }
        return OverlayUtil.createResultGeometry(resultPolyList, resultLineList, resultPointList, this.geometryFactory);
    }

    private Geometry computeDifference(Coordinate[] coords) {
        if (this.isPointRHS) {
            return this.copyNonPoint();
        }
        return this.createPointResult(this.findPoints(false, coords));
    }

    private Geometry createPointResult(List<Point> points) {
        if (points.size() == 0) {
            return this.geometryFactory.createEmpty(0);
        }
        if (points.size() == 1) {
            return points.get(0);
        }
        Point[] pointsArray = GeometryFactory.toPointArray(points);
        return this.geometryFactory.createMultiPoint(pointsArray);
    }

    private List<Point> findPoints(boolean isCovered, Coordinate[] coords) {
        HashSet<Coordinate> resultCoords = new HashSet<Coordinate>();
        for (Coordinate coord : coords) {
            if (!this.hasLocation(isCovered, coord)) continue;
            resultCoords.add(coord.copy());
        }
        return this.createPoints(resultCoords);
    }

    private List<Point> createPoints(Set<Coordinate> coords) {
        ArrayList<Point> points = new ArrayList<Point>();
        for (Coordinate coord : coords) {
            Point point = this.geometryFactory.createPoint(coord);
            points.add(point);
        }
        return points;
    }

    private boolean hasLocation(boolean isCovered, Coordinate coord) {
        boolean isExterior;
        boolean bl = isExterior = 2 == this.locator.locate(coord);
        if (isCovered) {
            return !isExterior;
        }
        return isExterior;
    }

    private Geometry copyNonPoint() {
        if (this.geomNonPointInput != this.geomNonPoint) {
            return this.geomNonPoint;
        }
        return this.geomNonPoint.copy();
    }

    private static Coordinate[] extractCoordinates(Geometry points, final PrecisionModel pm) {
        final CoordinateList coords = new CoordinateList();
        points.apply(new CoordinateFilter(){

            @Override
            public void filter(Coordinate coord) {
                Coordinate p = OverlayUtil.round(coord, pm);
                coords.add(p, false);
            }
        });
        return coords.toCoordinateArray();
    }

    private static List<Polygon> extractPolygons(Geometry geom) {
        ArrayList<Polygon> list = new ArrayList<Polygon>();
        for (int i = 0; i < geom.getNumGeometries(); ++i) {
            Polygon poly = (Polygon)geom.getGeometryN(i);
            if (poly.isEmpty()) continue;
            list.add(poly);
        }
        return list;
    }

    private static List<LineString> extractLines(Geometry geom) {
        ArrayList<LineString> list = new ArrayList<LineString>();
        for (int i = 0; i < geom.getNumGeometries(); ++i) {
            LineString line = (LineString)geom.getGeometryN(i);
            if (line.isEmpty()) continue;
            list.add(line);
        }
        return list;
    }
}

