/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.high_d;

import com.macrofocus.application.ApplicationModelFactory;
import com.macrofocus.colormap.ColorMapFactory;
import com.macrofocus.colormapping.MutableColorMapping;
import com.macrofocus.colormapping.implementation.SimpleColorMapping;
import com.macrofocus.common.collection.Iterables;
import com.macrofocus.common.properties.MutableProperty;
import com.macrofocus.common.selection.Selection;
import com.macrofocus.common.selection.SingleSelection;
import com.macrofocus.crossplatform.CPCanvas;
import com.macrofocus.crossplatform.CPFactory;
import com.macrofocus.filter.MutableFilter;
import com.macrofocus.format.CPFormat;
import com.macrofocus.high_d.HighDSettings;
import com.macrofocus.high_d.axis.AxisFactory;
import com.macrofocus.high_d.axis.hierarchy.AxisHierarchy;
import com.macrofocus.high_d.axis.hierarchy.DefaultAxisHierarchy;
import com.macrofocus.high_d.barchart.BarChart;
import com.macrofocus.high_d.barchart.BarChartModel;
import com.macrofocus.high_d.barchart.DefaultBarChartModel;
import com.macrofocus.high_d.clustering.Clustering;
import com.macrofocus.high_d.controlchart.ControlChart;
import com.macrofocus.high_d.controlchart.ControlChartScatterPlotModel;
import com.macrofocus.high_d.details.Details;
import com.macrofocus.high_d.distributions.AbstractDistributions;
import com.macrofocus.high_d.distributions.DefaultDistributionsModel;
import com.macrofocus.high_d.distributions.Distributions;
import com.macrofocus.high_d.distributions.DistributionsModel;
import com.macrofocus.high_d.filters.CategoricalFilterComponent;
import com.macrofocus.high_d.filters.Filters;
import com.macrofocus.high_d.filters.OrdinalFilterComponent;
import com.macrofocus.high_d.heatmap.DefaultHeatMapModel;
import com.macrofocus.high_d.heatmap.HeatMap;
import com.macrofocus.high_d.heatmap.HeatMapModel;
import com.macrofocus.high_d.interaction.InteractionMode;
import com.macrofocus.high_d.list.ListView;
import com.macrofocus.high_d.mds.MDS;
import com.macrofocus.high_d.mds.MDSScatterPlotModel;
import com.macrofocus.high_d.parallelcoordinates.AbstractParallelCoordinates;
import com.macrofocus.high_d.parallelcoordinates.DefaultParallelCoordinatesSettings;
import com.macrofocus.high_d.parallelcoordinates.ParallelCoordinates;
import com.macrofocus.high_d.parallelcoordinates.geometry.Geometry;
import com.macrofocus.high_d.parallelcoordinatesmatrix.AbstractParallelCoordinatesMatrix;
import com.macrofocus.high_d.parallelcoordinatesmatrix.DefaultParallelCoordinatesMatrixModel;
import com.macrofocus.high_d.parallelcoordinatesmatrix.ParallelCoordinatesMatrix;
import com.macrofocus.high_d.parallelcoordinatesmatrix.ParallelCoordinatesMatrixModel;
import com.macrofocus.high_d.regression.Regression;
import com.macrofocus.high_d.scatterplot.AbstractScatterPlot;
import com.macrofocus.high_d.scatterplot.DefaultScatterPlotModel;
import com.macrofocus.high_d.scatterplot.ScatterPlot;
import com.macrofocus.high_d.scatterplot.ScatterPlotModel;
import com.macrofocus.high_d.scatterplotmatrix.AbstractScatterPlotMatrix;
import com.macrofocus.high_d.scatterplotmatrix.DefaultScatterPlotMatrixModel;
import com.macrofocus.high_d.scatterplotmatrix.ScatterPlotMatrix;
import com.macrofocus.high_d.scatterplotmatrix.ScatterPlotMatrixModel;
import com.macrofocus.high_d.som.DefaultSOMModel;
import com.macrofocus.high_d.som.SOM;
import com.macrofocus.high_d.som.SOMModel;
import com.macrofocus.high_d.statistics.Statistics;
import com.macrofocus.high_d.statistics.StatisticsDataFrame;
import com.macrofocus.high_d.table.Table;
import com.macrofocus.high_d.tablelens.AbstractTableLens;
import com.macrofocus.high_d.tablelens.DefaultTableLensModel;
import com.macrofocus.high_d.tablelens.TableLens;
import com.macrofocus.high_d.tablelens.TableLensModel;
import com.macrofocus.igraphics.colortheme.ColorTheme;
import com.macrofocus.license.LicenseModel;
import com.macrofocus.license.SimpleLicenseModel;
import com.macrofocus.molap.dataframe.DataFrame;
import com.macrofocus.molap.subset.MultiBinningDimension;
import com.macrofocus.molap.subset.Reducer;
import com.macrofocus.molap.subset.SingleBinningDimension;
import com.macrofocus.molap.subset.SubsetDataFrame;
import com.macrofocus.timer.CPExecutor;
import com.macrofocus.visual.SimpleVisual;
import com.macrofocus.visual.SimpleVisualObjects;
import com.macrofocus.visual.Visual;
import com.macrofocus.visual.VisualObjects;

public abstract class HighDFactory<Component, Color, Font, Format, Row, Column, Value> {
    protected HighDSettings<Color, ?> settings;
    protected DataFrame<Row, Column, Value> dataFrame;
    protected SubsetDataFrame<Row, Column, Value> subsetDataFrame;
    protected DataFrame<?, Column, ?> annotationDataFrame;
    protected Visual<Color, Row, Column> visual;
    protected AxisHierarchy<Row, Column> axisHierarchy;
    protected AxisHierarchy<Row, Column> filtersAxisHierarchy;
    private static LicenseModel licenseModel;
    private final ColorMapFactory<Color> colorMapFactory;
    private final CPFactory<Component, Font, ?, Color> cpFactory;

    protected HighDFactory(HighDSettings<Color, Font> settings, ColorMapFactory<Color> colorMapFactory, CPFactory cpFactory) {
        this.settings = settings != null ? settings : new HighDSettings(cpFactory);
        this.colorMapFactory = colorMapFactory;
        this.cpFactory = cpFactory;
        this.dataFrame = null;
        this.visual = null;
        this.axisHierarchy = null;
        this.filtersAxisHierarchy = null;
    }

    protected HighDFactory(ColorMapFactory<Color> colorMapFactory, CPFactory factory, DataFrame<Row, Column, Value> dataFrame) {
        this(new HighDSettings(factory), colorMapFactory, factory);
        this.setDataFrame(dataFrame);
    }

    protected HighDFactory(ColorMapFactory<Color> colorMapFactory, CPFactory factory, DataFrame<Row, Column, Value> dataFrame, Visual<Color, Row, Column> visual) {
        this(new HighDSettings(factory), colorMapFactory, factory);
        this.setDataFrame(dataFrame, visual);
        AxisFactory axisFactory = new AxisFactory(factory, dataFrame, this.getSubsetDataFrame(), this.getAnnotationDataFrame(), (SingleSelection)visual.getProbing(), (Selection)visual.getSelection(), (MutableFilter)visual.getFilter());
        this.setAxisHierarchy((AxisHierarchy<Row, Column>)new DefaultAxisHierarchy(axisFactory, factory, dataFrame, true, false, 10));
        this.setFiltersAxisHierarchy((AxisHierarchy<Row, Column>)new DefaultAxisHierarchy(axisFactory, factory, dataFrame, false, true, 10));
    }

    protected HighDFactory(ColorMapFactory<Color> colorMapFactory, CPFactory factory, DataFrame<Row, Column, Value> dataFrame, SubsetDataFrame<Row, Column, Value> subsetDataFrame, DataFrame<?, Column, ?> annotationDataFrame, Visual<Color, Row, Column> visual, AxisHierarchy<Row, Column> axisHierarchy, AxisHierarchy<Row, Column> filtersAxisHierarchy, HighDSettings settings) {
        this(settings, colorMapFactory, factory);
        this.dataFrame = dataFrame;
        this.annotationDataFrame = annotationDataFrame;
        this.subsetDataFrame = subsetDataFrame;
        this.visual = visual;
        this.axisHierarchy = axisHierarchy;
        this.filtersAxisHierarchy = filtersAxisHierarchy;
    }

    public MutableProperty<Boolean> getShowFiltered() {
        return this.settings.getProperties().getProperty((Object)HighDSettings.PropertyType.showFiltered);
    }

    public MutableProperty<Boolean> getAntialiasing() {
        return this.settings.getProperties().getProperty((Object)HighDSettings.PropertyType.antialiasing);
    }

    public MutableProperty<CPCanvas.Rendering> getRendering() {
        return this.settings.getProperties().getProperty((Object)HighDSettings.PropertyType.rendering);
    }

    public MutableProperty<ColorTheme<Color>> getColorTheme() {
        return this.settings.getProperties().getProperty((Object)HighDSettings.PropertyType.ColorTheme);
    }

    public MutableProperty<Geometry> getGeometry() {
        return this.settings.getProperties().getProperty((Object)HighDSettings.PropertyType.geometry);
    }

    public void setColorTheme(MutableProperty<ColorTheme<Color>> colorTheme) {
        this.settings.getProperties().replaceProperty((Object)HighDSettings.PropertyType.ColorTheme, colorTheme);
    }

    public MutableProperty<InteractionMode> getInteractionMode() {
        return this.settings.getProperties().getProperty((Object)HighDSettings.PropertyType.InteractionMode);
    }

    public void setInteractionMode(MutableProperty<InteractionMode> interactionMode) {
        this.settings.getProperties().replaceProperty((Object)HighDSettings.PropertyType.InteractionMode, interactionMode);
    }

    public MutableProperty<Boolean> getAllowScrolling() {
        return this.settings.getProperties().getProperty((Object)HighDSettings.PropertyType.allowScrolling);
    }

    public abstract <Row, Column, Value> HighDFactory<Component, Color, Font, Format, Row, Column, Value> createHighDFactory(DataFrame<Row, Column, Value> var1);

    public abstract HighDFactory<Component, Color, Font, Format, Row, Column, Value> createHighDFactory(DataFrame<Row, Column, Value> var1, SubsetDataFrame<Row, Column, Value> var2, DataFrame<?, Column, ?> var3, Visual<Color, Row, Column> var4, AxisHierarchy<Row, Column> var5, AxisHierarchy<Row, Column> var6, HighDSettings var7);

    public HighDFactory<Component, Color, ?, Format, Row, Column, Value> forColumns(Column ... columns) {
        DefaultAxisHierarchy axisHierarchy = new DefaultAxisHierarchy(this.getAxisHierarchy().getAxisFactory(), Iterables.forArray((Object[])columns));
        return this.createHighDFactory(this.getDataFrame(), this.getSubsetDataFrame(), this.getAnnotationDataFrame(), this.getVisual(), (AxisHierarchy<Row, Column>)axisHierarchy, this.getFiltersAxisHierarchy(), this.settings);
    }

    public HighDFactory<Component, Color, Font, Format, Row, Column, Value> forColumns(Iterable<Column> columns) {
        DefaultAxisHierarchy axisHierarchy = new DefaultAxisHierarchy(this.getAxisHierarchy().getAxisFactory(), columns);
        return this.createHighDFactory(this.getDataFrame(), this.getSubsetDataFrame(), this.getAnnotationDataFrame(), this.getVisual(), (AxisHierarchy<Row, Column>)axisHierarchy, this.getFiltersAxisHierarchy(), this.settings);
    }

    public ColorMapFactory<Color> getColorMapFactory() {
        return this.colorMapFactory;
    }

    public CPFactory<Component, Font, ?, Color> getCPFactory() {
        return this.cpFactory;
    }

    public static void setLicenseKey(String username, String key) {
        licenseModel = new SimpleLicenseModel(ApplicationModelFactory.HIGHD_API, username, key);
        AbstractParallelCoordinates.setLicenseKey(username, key);
        AbstractParallelCoordinatesMatrix.setLicenseKey(username, key);
        AbstractScatterPlot.setLicenseKey(username, key);
        AbstractScatterPlotMatrix.setLicenseKey(username, key);
        AbstractDistributions.setLicenseKey(username, key);
        AbstractTableLens.setLicenseKey(username, key);
    }

    public DataFrame<Row, Column, Value> getDataFrame() {
        return this.dataFrame;
    }

    public Visual<Color, Row, Column> getVisual() {
        return this.visual;
    }

    public AxisHierarchy<Row, Column> getAxisHierarchy() {
        return this.axisHierarchy;
    }

    public AxisHierarchy<Row, Column> getFiltersAxisHierarchy() {
        return this.filtersAxisHierarchy;
    }

    public void setDataFrame(DataFrame<Row, Column, Value> dataFrame) {
        this.setDataFrame(dataFrame, (Visual<Color, Row, Column>)new SimpleVisual((VisualObjects)new SimpleVisualObjects(dataFrame), (MutableColorMapping)new SimpleColorMapping(this.getColorMapFactory(), dataFrame)));
    }

    public void setDataFrame(DataFrame<Row, Column, Value> dataFrame, Visual<Color, Row, Column> visual) {
        this.dataFrame = dataFrame;
        this.visual = visual;
        AxisFactory axisFactory = new AxisFactory(this.getCPFactory(), dataFrame, this.getSubsetDataFrame(), this.getAnnotationDataFrame(), (SingleSelection)visual.getProbing(), (Selection)visual.getSelection(), (MutableFilter)visual.getFilter());
        this.axisHierarchy = new DefaultAxisHierarchy(axisFactory, this.getCPFactory(), dataFrame, true, false, 10);
        this.filtersAxisHierarchy = new DefaultAxisHierarchy(axisFactory, this.getCPFactory(), dataFrame, false, true, 10);
    }

    public void setDataFrame(DataFrame<Row, Column, Value> dataFrame, SubsetDataFrame<Row, Column, Value> subsetDataFrame, DataFrame<?, Column, ?> annotationDataFrame, Visual<Color, Row, Column> visual, AxisHierarchy<Row, Column> axisHierarchy, AxisHierarchy<Row, Column> filtersAxisHierarchy) {
        this.dataFrame = dataFrame;
        this.subsetDataFrame = subsetDataFrame;
        this.annotationDataFrame = annotationDataFrame;
        this.visual = visual;
        this.axisHierarchy = axisHierarchy;
        this.filtersAxisHierarchy = filtersAxisHierarchy;
    }

    public DataFrame<?, Column, ?> getAnnotationDataFrame() {
        if (this.annotationDataFrame == null) {
            this.annotationDataFrame = new StatisticsDataFrame<Row, Column>((CPFactory)this.getCPFactory(), this.dataFrame, this.visual.getProbing(), this.visual.getSelection(), this.visual.getFilter(), this.visual.getColorMapping(), this.visual.getColoring());
        }
        return this.annotationDataFrame;
    }

    public void setAnnotationDataFrame(DataFrame<?, Column, ?> annotationDataFrame) {
        this.annotationDataFrame = annotationDataFrame;
    }

    public SubsetDataFrame<Row, Column, Value> getSubsetDataFrame() {
        if (this.subsetDataFrame == null) {
            this.subsetDataFrame = new SubsetDataFrame(this.dataFrame, this.visual != null ? this.visual.getFilter() : null, this.visual != null ? this.visual.getSelection() : null);
        }
        return this.subsetDataFrame;
    }

    public void setSubsetDataFrame(SubsetDataFrame<Row, Column, Value> subsetDataFrame) {
        this.subsetDataFrame = subsetDataFrame;
    }

    public void setVisual(Visual<Color, Row, Column> visual) {
        this.visual = visual;
    }

    public void setAxisHierarchy(AxisHierarchy<Row, Column> axisHierarchy) {
        this.axisHierarchy = axisHierarchy;
    }

    public void setFiltersAxisHierarchy(AxisHierarchy<Row, Column> axisHierarchy) {
        this.filtersAxisHierarchy = this.filtersAxisHierarchy;
    }

    public abstract ParallelCoordinates<Component, Color, Row, Column> createParallelCoordinates();

    protected void customizeParallelCoordinates(ParallelCoordinates<Component, Color, Row, Column> parallelCoordinates) {
        parallelCoordinates.getView().setShowFiltered(this.settings.getShowFiltered());
        parallelCoordinates.getView().setAntialiasing(this.settings.getAntialiasing());
        parallelCoordinates.getView().setRendering(this.settings.getRendering());
        parallelCoordinates.getView().setColorTheme(this.settings.getColorTheme());
        parallelCoordinates.getView().setGeometry(this.settings.getGeometry());
        parallelCoordinates.getView().setAllowScrolling(this.settings.getAllowScrolling());
    }

    public abstract ParallelCoordinatesMatrix<Component, Color, Row, Column> createParallelCoordinatesMatrix();

    protected void customizeParallelCoordinatesMatrix(ParallelCoordinatesMatrix<Component, Color, Row, Column> parallelCoordinatesMatrix) {
        parallelCoordinatesMatrix.getView().setShowFiltered(this.settings.getShowFiltered());
        parallelCoordinatesMatrix.getView().setAntialiasing(this.settings.getAntialiasing());
        parallelCoordinatesMatrix.getView().setRendering(this.settings.getRendering());
        parallelCoordinatesMatrix.getView().setColorTheme(this.settings.getColorTheme());
    }

    public ParallelCoordinatesMatrixModel<Color, Row, Column> createParallelCoordinatesMatrixModel() {
        if (this.getDataFrame() != null) {
            return new DefaultParallelCoordinatesMatrixModel<Color, Row, Column>(this.getDataFrame(), this.getVisual(), this.getAxisHierarchy().getFlat(), this.getAxisHierarchy(), new DefaultParallelCoordinatesSettings());
        }
        return null;
    }

    public abstract TableLens<Component, Color, Row, Column> createTableLens();

    public TableLensModel<Color, Row, Column> createTableLensModel() {
        if (this.getDataFrame() != null) {
            return new DefaultTableLensModel<Color, Row, Column>(this.cpFactory, this.getDataFrame(), this.getVisual(), this.getAxisHierarchy().getFlat());
        }
        return null;
    }

    protected void customizeTableLens(TableLens<Component, Color, Row, Column> tableLens) {
        if (tableLens.getModel() != null) {
            tableLens.getModel().setShowFiltered(this.settings.getShowFiltered());
        }
        tableLens.getView().setShowFiltered(this.settings.getShowFiltered());
        tableLens.getView().setAntialiasing(this.settings.getAntialiasing());
        tableLens.getView().setRendering(this.settings.getRendering());
        tableLens.getView().setColorTheme(this.settings.getColorTheme());
    }

    public abstract ScatterPlot<Component, Color, Font, Row, Column> createScatterPlot();

    public abstract ScatterPlot<Component, Color, Font, Row, Column> createScatterPlot(ScatterPlotModel<Color, Row, Column> var1);

    protected void customizeScatterPlot(ScatterPlot<Component, Color, Font, Row, Column> scatterPlot) {
        scatterPlot.getView().setShowFiltered(this.settings.getShowFiltered());
        scatterPlot.getView().setAntialiasing(this.settings.getAntialiasing());
        scatterPlot.getView().setRendering(this.settings.getRendering());
        scatterPlot.getView().setColorTheme(this.settings.getColorTheme());
    }

    public ScatterPlotModel<Color, Row, Column> createScatterPlotModel() {
        if (this.getDataFrame() != null) {
            return new DefaultScatterPlotModel<Color, Row, Column>(this.getDataFrame(), this.getAnnotationDataFrame(), this.getVisual(), this.getAxisHierarchy().getFlat());
        }
        return null;
    }

    public abstract MDS<Component, Color, Font, Row, Column> createMDS();

    protected void customizeMDS(MDS<Component, Color, Font, Row, Column> mds) {
        mds.getView().setShowFiltered(this.settings.getShowFiltered());
        mds.getView().setAntialiasing(this.settings.getAntialiasing());
        mds.getView().setRendering(this.settings.getRendering());
        mds.getView().setColorTheme(this.settings.getColorTheme());
    }

    public abstract MDSScatterPlotModel<Color, Row, Column> createMDSModel();

    public abstract ControlChart<Component, Color, Font, Row, Column> createControlChart();

    protected void customizeControlChart(ControlChart<Component, Color, Font, Row, Column> controlChart) {
        controlChart.getView().setShowFiltered(this.settings.getShowFiltered());
        controlChart.getView().setAntialiasing(this.settings.getAntialiasing());
        controlChart.getView().setRendering(this.settings.getRendering());
        controlChart.getView().setColorTheme(this.settings.getColorTheme());
    }

    public ControlChartScatterPlotModel<Color, Row, Column> createControlCharttModel() {
        if (this.getDataFrame() != null) {
            return new ControlChartScatterPlotModel<Color, Row, Column>(this.getDataFrame(), this.getAnnotationDataFrame(), this.getVisual(), this.getAxisHierarchy().getFlat());
        }
        return null;
    }

    public abstract ScatterPlotMatrix<Component, Color, Row, Column> createScatterPlotMatrix();

    protected void customizeScatterPlotMatrix(ScatterPlotMatrix<Component, Color, Row, Column> scatterPlotMatrix) {
        scatterPlotMatrix.getView().setShowFiltered(this.settings.getShowFiltered());
        scatterPlotMatrix.getView().setAntialiasing(this.settings.getAntialiasing());
        scatterPlotMatrix.getView().setRendering(this.settings.getRendering());
        scatterPlotMatrix.getView().setColorTheme(this.settings.getColorTheme());
    }

    public ScatterPlotMatrixModel<Color, Row, Column> createScatterPlotMatrixModel() {
        if (this.getDataFrame() != null) {
            return new DefaultScatterPlotMatrixModel<Color, Row, Column>(this.getDataFrame(), this.getVisual(), this.getAxisHierarchy().getFlat());
        }
        return null;
    }

    public abstract CPExecutor createExecutor();

    public abstract Distributions<Component, Color, Row, Column, Value, ?> createDistributions();

    public <Bin> DistributionsModel<Color, Row, Column, Value, Bin> createDistributionsModel() {
        if (this.getDataFrame() != null) {
            return new DefaultDistributionsModel(this.getDataFrame(), this.getSubsetDataFrame(), this.getVisual(), this.getAxisHierarchy().getFlat());
        }
        return null;
    }

    protected void customizeDistribution(Distributions<Component, Color, Row, Column, Value, ?> distributions) {
        distributions.getView().setShowFiltered(this.settings.getShowFiltered());
        distributions.getView().setAntialiasing(this.settings.getAntialiasing());
        distributions.getView().setRendering(this.settings.getRendering());
        distributions.getView().setColorTheme(this.settings.getColorTheme());
        distributions.getView().setInteractionMode(this.getInteractionMode());
    }

    public abstract Statistics<Component, Color, Format, Row, Column, Value> createStatistics();

    protected void customizeStatistics(Statistics<Component, Color, Format, Row, Column, Value> statistics) {
        statistics.setColorTheme(this.getColorTheme());
    }

    public abstract Table<Component, Color, Format, Row, Column, Value> createTable();

    public abstract <Row, Column, Value> Table<Component, Color, Format, Row, Column, Value> createTable(DataFrame<Row, Column, Value> var1, Visual<Color, Row, Column> var2);

    protected void customizeTable(Table<Component, Color, Format, Row, Column, Value> table) {
        table.setShowFiltered(this.settings.getShowFiltered());
        table.setColorTheme(this.settings.getColorTheme());
    }

    public abstract ListView<Component, Integer, String> createList(Column var1);

    public abstract Filters<Component, Color, Row, Column, Value> createFilters();

    public void customizeFilters(Filters<Component, Color, Row, Column, Value> filters) {
        filters.setColorTheme(this.settings.getColorTheme());
        filters.setInteractionMode(this.getInteractionMode());
    }

    public abstract CategoricalFilterComponent<Component, Color> createCategoricalFilter(Column var1, Reducer<Row, Value> var2);

    public abstract <Bin> CategoricalFilterComponent<Component, Color> createCategoricalFilter(Column var1, Reducer<Row, Bin> var2, SingleBinningDimension.SingleBinningStrategy<Row, Bin> var3);

    public abstract <Bin> CategoricalFilterComponent<Component, Color> createCategoricalFilter(Column var1, Reducer<Row, Bin> var2, MultiBinningDimension.MultiBinningStrategy<Row, Bin> var3);

    protected void customizeCategoricalFilterComponent(CategoricalFilterComponent<Component, Color> categoricalFilterComponent) {
        categoricalFilterComponent.setColorTheme(this.settings.getColorTheme());
        categoricalFilterComponent.setInteractionMode(this.getInteractionMode());
    }

    public OrdinalFilterComponent<Component, Color, Format> createOrdinalFilter(Column column) {
        return this.createOrdinalFilter(column, null, 8);
    }

    public abstract OrdinalFilterComponent<Component, Color, Format> createOrdinalFilter(Column var1, CPFormat var2, int var3);

    public abstract SOM<Component, Color, Row, Column> createSOM();

    protected SOMModel<Color, Row, Column> createSOMModel() {
        if (this.getDataFrame() != null) {
            return new DefaultSOMModel();
        }
        return null;
    }

    protected void customizeSOM(SOM<Component, Color, Row, Column> som) {
    }

    public abstract BarChart<Component, Color, Row, Column> createBarChart();

    protected BarChartModel<Color, Row, Column> createBarChartModel() {
        if (this.getDataFrame() != null) {
            return new DefaultBarChartModel();
        }
        return null;
    }

    public abstract HeatMap<Component, Color, Row, Column> createHeatMap();

    protected void customizeBarChart(BarChart<Component, Color, Row, Column> barChart) {
    }

    protected HeatMapModel<Color, Row, Column> createHeatMapModel() {
        if (this.getDataFrame() != null) {
            return new DefaultHeatMapModel();
        }
        return null;
    }

    protected void customizeHeatMap(HeatMap<Component, Color, Row, Column> heatMap) {
    }

    public abstract Details<Component, Color, Row, Column> createDetails();

    public abstract Clustering<Component, Color, Row, Column> createClustering();

    protected SingleBinningDimension<Row, ?> createClusteringModel() {
        if (this.getSubsetDataFrame() != null) {
            return this.getSubsetDataFrame().getBinningDimension((Object)"Clusters", null);
        }
        return null;
    }

    public abstract Regression<Component, Color, Row, Column> createRegression();

    public void setSettings(HighDSettings settings) {
        this.settings = settings;
    }
}

