/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.high_d.distributions;

import com.macrofocus.common.properties.MutableProperty;
import com.macrofocus.common.properties.Property;
import com.macrofocus.common.properties.PropertyEvent;
import com.macrofocus.common.properties.PropertyListener;
import com.macrofocus.common.selection.SelectionEvent;
import com.macrofocus.common.selection.SelectionListener;
import com.macrofocus.common.selection.SingleSelectionEvent;
import com.macrofocus.common.selection.SingleSelectionListener;
import com.macrofocus.crossplatform.CPCanvas;
import com.macrofocus.crossplatform.CPFactory;
import com.macrofocus.geom.Point2D;
import com.macrofocus.geom.Rectangle;
import com.macrofocus.geom.Rectangle2D;
import com.macrofocus.high_d.axis.AxisModel;
import com.macrofocus.high_d.distributions.DistributionsComponent;
import com.macrofocus.high_d.distributions.DistributionsListener;
import com.macrofocus.high_d.distributions.DistributionsModel;
import com.macrofocus.high_d.distributions.DistributionsView;
import com.macrofocus.high_d.distributions.FixedBinsHistogram;
import com.macrofocus.high_d.distributions.Histogram;
import com.macrofocus.igraphics.AbstractIDrawing;
import com.macrofocus.igraphics.CPColor;
import com.macrofocus.igraphics.CPColorFactory;
import com.macrofocus.igraphics.IDrawing;
import com.macrofocus.igraphics.IGraphics;
import com.macrofocus.igraphics.colortheme.ColorTheme;
import com.macrofocus.molap.subset.DimensionEvent;
import com.macrofocus.molap.subset.DimensionListener;
import com.macrofocus.molap.subset.DistributionDimension;
import com.macrofocus.molap.subset.SingleBinningDimension;
import com.macrofocus.order.MutableVisibleOrder;
import com.macrofocus.order.OrderEvent;
import com.macrofocus.order.OrderListener;
import com.macrofocus.palette.Palette;
import com.macrofocus.rubberband.RubberbandDrawing;
import com.macrofocus.timer.CPTimer;
import com.macrofocus.timer.CPTimerListener;
import com.macrofocus.utils.RandomAccessIterable;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class AbstractDistributionsComponent<Component, Color, Row, Column, Value, Bin>
implements DistributionsComponent<Component, Color, Row, Column, Value, Bin> {
    protected DistributionsModel<Color, Row, Column, Value, Bin> model;
    protected final DistributionsView<? extends Component, Color, Row, Column, Value, Bin> view;
    protected final CPCanvas canvas;
    private final CPFactory<?, ?, ?, Color> factory;
    private final Map<AxisModel, Histogram> axisHistogramCache = new HashMap<AxisModel, Histogram>();
    private final double margin = 0.2;
    private final int binSize = 10;
    private final Scale scale = Scale.Local;
    protected final CPTimer timer;
    private final DistributionsListener listener = new DistributionsListener(){

        @Override
        public void distributionsChanged() {
            AbstractDistributionsComponent.this.timer.restart();
        }
    };
    private final OrderListener<AxisModel<Row, Column>> orderListener = new OrderListener<AxisModel<Row, Column>>(){

        public void orderChanged(OrderEvent<AxisModel<Row, Column>> event) {
            AbstractDistributionsComponent.this.scheduleUpdate();
        }

        public void orderVisibility(OrderEvent<AxisModel<Row, Column>> event) {
            AbstractDistributionsComponent.this.scheduleUpdate();
        }

        public void orderAdded(OrderEvent<AxisModel<Row, Column>> event) {
            AbstractDistributionsComponent.this.scheduleUpdate();
        }

        public void orderRemoved(OrderEvent<AxisModel<Row, Column>> event) {
            AbstractDistributionsComponent.this.scheduleUpdate();
        }
    };

    public AbstractDistributionsComponent(DistributionsView<? extends Component, Color, Row, Column, Value, Bin> view, CPFactory<?, ?, ?, Color> factory) {
        this.view = view;
        this.canvas = factory.createCanvas();
        this.factory = factory;
        this.timer = factory.createTimer("DistributionResizer", 50, true, new CPTimerListener(){

            public void timerTriggered() {
                if (AbstractDistributionsComponent.this.getWidth() > 0 && AbstractDistributionsComponent.this.getHeight() > 0) {
                    AbstractDistributionsComponent.this.refresh();
                }
            }
        });
    }

    protected abstract int getWidth();

    protected abstract int getHeight();

    protected abstract void repaint();

    @Override
    public void setModel(DistributionsModel<Color, Row, Column, Value, Bin> model) {
        if (this.model != null) {
            this.model.removeDistributionsListener(this.listener);
            this.model.getAxisGroupModel().getAxisOrder().removeOrderListener(this.orderListener);
        }
        this.model = model;
        if (model != null) {
            this.createOverplots();
            this.model.addDistributionsListener(this.listener);
            this.model.getAxisGroupModel().getAxisOrder().addOrderListener(this.orderListener);
        }
        this.axisHistogramCache.clear();
        if (model != null) {
            this.timer.restart();
        }
    }

    private Histogram<Row> getHistogram(final AxisModel<Row, Column> axisModel) {
        if (!this.axisHistogramCache.containsKey(axisModel)) {
            FixedBinsHistogram<Row> histogram;
            if (axisModel.isNumerical()) {
                MutableProperty binCount = axisModel.getBinCount();
                binCount.addPropertyListener((PropertyListener)new PropertyListener<Integer>(){

                    public void propertyChanged(PropertyEvent<Integer> event) {
                        AbstractDistributionsComponent.this.axisHistogramCache.remove(axisModel);
                        AbstractDistributionsComponent.this.timer.restart();
                    }
                });
                histogram = new FixedBinsHistogram<Row>(binCount != null ? (Integer)binCount.getValue() : this.getHeight() / 10, axisModel.getMinimum(), axisModel.getMaximum(), this.model.getFilter());
            } else {
                histogram = new FixedBinsHistogram<Row>((int)(axisModel.getMaximum() - axisModel.getMinimum()) + 1, axisModel.getMinimum(), axisModel.getMaximum(), this.model.getFilter());
            }
            assert (axisModel != null);
            for (Object row : axisModel) {
                Number value = axisModel.getValue(row);
                if (value == null) continue;
                histogram.addValue(row, value.doubleValue());
            }
            this.axisHistogramCache.put(axisModel, histogram);
        }
        return this.axisHistogramCache.get(axisModel);
    }

    protected void refresh() {
        this.clearCache();
        this.repaint();
    }

    @Override
    public void clearCache() {
        this.axisHistogramCache.clear();
    }

    @Override
    public DistributionDimension<Row, Value, Bin> getClosestDistribution(int x, int y) {
        MutableVisibleOrder axisOrder = this.model.getAxisGroupModel().getAxisOrder();
        for (int i = 0; i < axisOrder.size(); ++i) {
            AxisModel xAxisModel = (AxisModel)axisOrder.get(i);
            Double x1Location = this.model.getLocation(xAxisModel);
            Double x2Location = i + 1 < axisOrder.size() ? this.model.getLocation((AxisModel)axisOrder.get(i + 1)) : Double.valueOf(1.0);
            if (x1Location == null || x2Location == null) continue;
            int x1 = (int)(x1Location * (double)this.getWidth()) + 1;
            int w = (int)((x2Location * (double)this.getWidth() - (double)x1) * 0.8);
            int x2 = x1 + w;
            if (x < x1 || x > x2) continue;
            DistributionDimension<Row, Value, Bin> dimension = this.view.getDistributionDimension(xAxisModel);
            return dimension;
        }
        return null;
    }

    @Override
    public Bin getClosestBin(int x, int y) {
        MutableVisibleOrder axisOrder = this.model.getAxisGroupModel().getAxisOrder();
        for (int i = 0; i < axisOrder.size(); ++i) {
            AxisModel xAxisModel = (AxisModel)axisOrder.get(i);
            Double x1Location = this.model.getLocation(xAxisModel);
            Double x2Location = i + 1 < axisOrder.size() ? this.model.getLocation((AxisModel)axisOrder.get(i + 1)) : Double.valueOf(1.0);
            if (x1Location == null || x2Location == null) continue;
            int x1 = (int)(x1Location * (double)this.getWidth()) + 1;
            int w = (int)((x2Location * (double)this.getWidth() - (double)x1) * 0.8);
            int x2 = x1 + w;
            if (x < x1 || x > x2) continue;
            DistributionDimension<Row, Value, Bin> dimension = this.view.getDistributionDimension(xAxisModel);
            boolean j = false;
            for (Object bin : dimension.getBins()) {
                int y1 = this.getHeight() - (int)((dimension.getBinStartValue(bin) - dimension.getMinValue()) * (double)this.getHeight() / (dimension.getMaxValue() - dimension.getMinValue()));
                int y2 = this.getHeight() - (int)((dimension.getBinEndValue(bin) - dimension.getMinValue()) * (double)this.getHeight() / (dimension.getMaxValue() - dimension.getMinValue()));
                if (y < y2 || y > y1) continue;
                return (Bin)bin;
            }
        }
        return null;
    }

    @Override
    public List<Bin> getBins(Rectangle2D rect) {
        ArrayList list = null;
        MutableVisibleOrder axisOrder = this.model.getAxisGroupModel().getAxisOrder();
        for (int i = 0; i < axisOrder.size(); ++i) {
            AxisModel xAxisModel = (AxisModel)axisOrder.get(i);
            Double x1Location = this.model.getLocation(xAxisModel);
            Double x2Location = i + 1 < axisOrder.size() ? this.model.getLocation((AxisModel)axisOrder.get(i + 1)) : Double.valueOf(1.0);
            if (x1Location == null || x2Location == null) continue;
            int x1 = (int)(x1Location * (double)this.getWidth()) + 1;
            int w = (int)((x2Location * (double)this.getWidth() - (double)x1) * 0.8);
            int x2 = x1 + w;
            if (!(rect.getX() >= (double)x1) || !(rect.getX() <= (double)x2)) continue;
            DistributionDimension<Row, Value, Bin> dimension = this.view.getDistributionDimension(xAxisModel);
            for (Object bin : dimension.getBins()) {
                int y1 = this.getHeight() - (int)((dimension.getBinStartValue(bin) - dimension.getMinValue()) * (double)this.getHeight() / (dimension.getMaxValue() - dimension.getMinValue()));
                int y2 = this.getHeight() - (int)((dimension.getBinEndValue(bin) - dimension.getMinValue()) * (double)this.getHeight() / (dimension.getMaxValue() - dimension.getMinValue()));
                if (!(rect.getY() >= (double)y2) || !(rect.getY() <= (double)y1)) continue;
                if (list == null) {
                    list = new ArrayList();
                }
                list.add(bin);
            }
        }
        return list;
    }

    @Override
    public Row getClosestRow(int x, int y) {
        AxisModel xAxisModel;
        int i;
        MutableVisibleOrder axisOrder = this.model.getAxisGroupModel().getAxisOrder();
        int max_count = 0;
        if (this.scale == Scale.Global) {
            for (i = 0; i < axisOrder.size(); ++i) {
                xAxisModel = (AxisModel)axisOrder.get(i);
                Histogram<Row> histogram = this.getHistogram(xAxisModel);
                max_count = Math.max(max_count, histogram.getMaxDensity());
            }
        }
        for (i = 0; i < axisOrder.size(); ++i) {
            xAxisModel = (AxisModel)axisOrder.get(i);
            Double x1Location = this.model.getLocation(xAxisModel);
            Double x2Location = i + 1 < axisOrder.size() ? this.model.getLocation((AxisModel)axisOrder.get(i + 1)) : Double.valueOf(1.0);
            if (x1Location == null || x2Location == null) continue;
            int x1 = (int)(x1Location * (double)this.getWidth()) + 1;
            int w = (int)((x2Location * (double)this.getWidth() - (double)x1) * 0.8);
            int x2 = x1 + w;
            if (x < x1 || x > x2) continue;
            Histogram<Row> histogram = this.getHistogram(xAxisModel);
            for (int j = 0; j < histogram.getNumberOfBins(); ++j) {
                int y1 = this.getHeight() - (int)((histogram.getBinStartValue(j) - histogram.getMinValue()) * (double)this.getHeight() / (histogram.getMaxValue() - histogram.getMinValue()));
                int y2 = this.getHeight() - (int)((histogram.getBinEndValue(j) - histogram.getMinValue()) * (double)this.getHeight() / (histogram.getMaxValue() - histogram.getMinValue()));
                if (y < y2 || y > y1) continue;
                int activeCountAtBin = histogram.getActiveDensity(j);
                if (activeCountAtBin > 0) {
                    int activeWidth;
                    int max_width = x2 - x1;
                    if (this.scale == Scale.Local) {
                        max_count = histogram.getMaxDensity();
                    }
                    if ((activeWidth = activeCountAtBin * max_width / max_count) <= 0) continue;
                    int index = (x - x1) * (activeCountAtBin - 1) / activeWidth;
                    if (index >= 0 && index < activeCountAtBin) {
                        return histogram.getActiveRowAtBin(j, index);
                    }
                    return null;
                }
                return null;
            }
        }
        return null;
    }

    protected State getState(SingleBinningDimension<Row, Bin> dimension, Bin bin) {
        boolean selected;
        boolean bl = selected = !dimension.getFilterExact().isActive() || dimension.getFilterExact().isSelected(bin);
        if (selected && dimension.getActiveDensity(bin) > 0.0) {
            if (this.view.getProbing().isActive() && this.view.getProbing().isSelected(new AbstractMap.SimpleImmutableEntry<SingleBinningDimension<Row, Bin>, Bin>(dimension, bin))) {
                if (dimension.getFilterExact().isSelected(bin)) {
                    return State.ProbedSelected;
                }
                return State.Probed;
            }
            if (dimension.getFilterExact().isSelected(bin)) {
                return State.Selected;
            }
            return State.Active;
        }
        if (dimension.getActiveDensity(bin) > 0.0) {
            if (this.view.getProbing().isActive() && this.view.getProbing().isSelected(new AbstractMap.SimpleImmutableEntry<SingleBinningDimension<Row, Bin>, Bin>(dimension, bin))) {
                return State.ProbedSelectable;
            }
            return State.Selectable;
        }
        return State.Inactive;
    }

    @Override
    public void createOverplots() {
        if (this.model != null) {
            this.canvas.removeAllLayers();
            this.canvas.addLayer(new HistogramIDrawing());
            this.canvas.addLayer((IDrawing)new RubberbandDrawing((CPColorFactory)this.factory, this.view.getRubberBand()){

                protected Property<ColorTheme<Color>> getColorTheme() {
                    return AbstractDistributionsComponent.this.view.getColorTheme();
                }
            });
        }
    }

    private static enum Scale {
        Global,
        Local;

    }

    protected static enum State {
        Active,
        Probed,
        Selected,
        ProbedSelected,
        Selectable,
        ProbedSelectable,
        Inactive;

    }

    private class HistogramIDrawing<FontMetrics>
    extends AbstractIDrawing<Color, FontMetrics> {
        private SelectionListener<Bin> selectionListener = new SelectionListener<Bin>(){

            public void selectionChanged(SelectionEvent<Bin> event) {
                HistogramIDrawing.this.notifyIDrawingChanged();
            }
        };
        final DimensionListener<Row> dimensionListener = new DimensionListener<Row>(){

            public void dimensionChanged(DimensionEvent<Row> event) {
                HistogramIDrawing.this.notifyIDrawingChanged();
            }

            public void selectedCountChanged() {
                HistogramIDrawing.this.notifyIDrawingChanged();
            }
        };
        final SingleSelectionListener<AbstractMap.SimpleImmutableEntry<SingleBinningDimension<Row, Bin>, Bin>> probingListener = new SingleSelectionListener<AbstractMap.SimpleImmutableEntry<SingleBinningDimension<Row, Bin>, Bin>>(){

            public void selectionChanged(SingleSelectionEvent<AbstractMap.SimpleImmutableEntry<SingleBinningDimension<Row, Bin>, Bin>> event) {
                HistogramIDrawing.this.notifyIDrawingChanged();
            }
        };

        public HistogramIDrawing() {
            MutableVisibleOrder axisOrder = AbstractDistributionsComponent.this.model.getAxisGroupModel().getAxisOrder();
            for (int i = 0; i < axisOrder.size(); ++i) {
                AxisModel xAxisModel = (AxisModel)axisOrder.get(i);
                DistributionDimension dimension = AbstractDistributionsComponent.this.view.getDistributionDimension(xAxisModel);
                dimension.addDimensionListener(this.dimensionListener);
                dimension.getFilterExact().addWeakSelectionListener(this.selectionListener);
            }
            AbstractDistributionsComponent.this.view.getProbing().addWeakSingleSelectionListener(this.probingListener);
        }

        public void draw(IGraphics<Color, FontMetrics> g, Point2D point, double wi, double he, Rectangle clipBounds) {
            AxisModel xAxisModel;
            int i;
            g.setColor(((ColorTheme)AbstractDistributionsComponent.this.view.getColorTheme().getValue()).getBackground());
            g.fillRectangle(0, 0, AbstractDistributionsComponent.this.getWidth(), AbstractDistributionsComponent.this.getHeight());
            MutableVisibleOrder axisOrder = AbstractDistributionsComponent.this.model.getAxisGroupModel().getAxisOrder();
            double max_count = 0.0;
            if (AbstractDistributionsComponent.this.scale == Scale.Global) {
                for (i = 0; i < axisOrder.size(); ++i) {
                    xAxisModel = (AxisModel)axisOrder.get(i);
                    DistributionDimension dimension = AbstractDistributionsComponent.this.view.getDistributionDimension(xAxisModel);
                    max_count = (Boolean)AbstractDistributionsComponent.this.view.getShowFiltered().getValue() != false ? Math.max(max_count, dimension.getMaxDensity()) : Math.max(max_count, dimension.getMaxActiveDensity());
                }
            }
            for (i = 0; i < axisOrder.size(); ++i) {
                xAxisModel = (AxisModel)axisOrder.get(i);
                Double x1Location = AbstractDistributionsComponent.this.model.getLocation(xAxisModel);
                Double x2Location = i + 1 < axisOrder.size() ? AbstractDistributionsComponent.this.model.getLocation((AxisModel)axisOrder.get(i + 1)) : Double.valueOf(1.0);
                if (x1Location == null || x2Location == null) continue;
                DistributionDimension dimension = AbstractDistributionsComponent.this.view.getDistributionDimension(xAxisModel);
                int x1 = (int)(x1Location * (double)AbstractDistributionsComponent.this.getWidth()) + 1;
                int w = (int)((x2Location * (double)AbstractDistributionsComponent.this.getWidth() - (double)x1) * 0.8);
                int x2 = x1 + w;
                g.setColor(((ColorTheme)AbstractDistributionsComponent.this.view.getColorTheme().getValue()).getGhostedPalette().getColor(1.0));
                g.drawLine(x1 - 1, 0, x1 - 1, AbstractDistributionsComponent.this.getHeight());
                int max_width = x2 - x1;
                if (AbstractDistributionsComponent.this.scale == Scale.Local) {
                    max_count = (Boolean)AbstractDistributionsComponent.this.view.getShowFiltered().getValue() != false ? dimension.getMaxDensity() : dimension.getMaxActiveDensity();
                }
                int x_prev = x1;
                int active_x_prev = x1;
                RandomAccessIterable bins = dimension.getBins();
                Iterator it = bins.iterator();
                int j = 0;
                while (it.hasNext()) {
                    CPColor fillColor;
                    CPColor outlineColor;
                    Object bin = it.next();
                    State state = AbstractDistributionsComponent.this.getState(dimension, bin);
                    Palette palette = ((ColorTheme)AbstractDistributionsComponent.this.view.getColorTheme().getValue()).getPalette();
                    switch (state.ordinal()) {
                        case 0: {
                            outlineColor = null;
                            fillColor = palette.getColor(0.3);
                            CPColor labelColor = palette.getColor(0.7);
                            break;
                        }
                        case 1: {
                            outlineColor = ((ColorTheme)AbstractDistributionsComponent.this.view.getColorTheme().getValue()).getProbing();
                            fillColor = palette.getColor(0.3);
                            CPColor labelColor = ((ColorTheme)AbstractDistributionsComponent.this.view.getColorTheme().getValue()).getProbing();
                            break;
                        }
                        case 2: {
                            outlineColor = null;
                            fillColor = palette.getColor(0.55);
                            CPColor labelColor = palette.getColor(1.0);
                            break;
                        }
                        case 3: {
                            outlineColor = ((ColorTheme)AbstractDistributionsComponent.this.view.getColorTheme().getValue()).getProbing();
                            fillColor = palette.getColor(0.55);
                            CPColor labelColor = ((ColorTheme)AbstractDistributionsComponent.this.view.getColorTheme().getValue()).getProbing();
                            break;
                        }
                        case 4: {
                            outlineColor = null;
                            fillColor = palette.getColor(0.1);
                            CPColor labelColor = palette.getColor(0.3);
                            break;
                        }
                        case 5: {
                            outlineColor = ((ColorTheme)AbstractDistributionsComponent.this.view.getColorTheme().getValue()).getProbing();
                            fillColor = palette.getColor(0.1);
                            CPColor labelColor = palette.getColor(0.7);
                            break;
                        }
                        case 6: {
                            outlineColor = null;
                            fillColor = palette.getColor(0.05);
                            CPColor labelColor = palette.getColor(0.2);
                            break;
                        }
                        default: {
                            outlineColor = null;
                            fillColor = AbstractDistributionsComponent.this.factory.getGray();
                            CPColor labelColor = null;
                        }
                    }
                    if (dimension.getDensity(bin) > 0.0) {
                        double selectionCountAtBin;
                        int width = (int)(dimension.getDensity(bin) * (double)max_width / max_count);
                        double binStartValue = dimension.getBinStartValue(bin);
                        int y1 = AbstractDistributionsComponent.this.getHeight() - (int)((binStartValue - dimension.getMinValue()) * (double)AbstractDistributionsComponent.this.getHeight() / (dimension.getMaxValue() - dimension.getMinValue()));
                        double binEndValue = dimension.getBinEndValue(bin);
                        int y2 = AbstractDistributionsComponent.this.getHeight() - (int)((binEndValue - dimension.getMinValue()) * (double)AbstractDistributionsComponent.this.getHeight() / (dimension.getMaxValue() - dimension.getMinValue()));
                        if (((Boolean)AbstractDistributionsComponent.this.view.getShowFiltered().getValue()).booleanValue()) {
                            g.setColor(((ColorTheme)AbstractDistributionsComponent.this.view.getColorTheme().getValue()).getGhostedPalette().getColor(0.0));
                            g.fillRectangle(x1, y2, width, y1 - y2);
                        }
                        double activeCountAtBin = dimension.getActiveDensity(bin);
                        int activeWidth = (int)(activeCountAtBin * (double)max_width / max_count);
                        g.setColor(fillColor);
                        g.fillRectangle(x1, y2, activeWidth, y1 - y2);
                        if (outlineColor != null) {
                            g.setColor(outlineColor);
                            g.drawRectange(x1, y2, activeWidth, y1 - y2);
                        }
                        if ((selectionCountAtBin = dimension.getSelectionDensity(bin)) > 0.0) {
                            int selectionWidth = (int)(selectionCountAtBin * (double)max_width / max_count);
                            g.setColor(((ColorTheme)AbstractDistributionsComponent.this.view.getColorTheme().getValue()).getSelection());
                            g.fillRectangle(x1, y2, selectionWidth, y1 - y2);
                        }
                        if (((Boolean)AbstractDistributionsComponent.this.view.getShowFiltered().getValue()).booleanValue()) {
                            g.setColor(((ColorTheme)AbstractDistributionsComponent.this.view.getColorTheme().getValue()).getGhostedPalette().getColor(1.0));
                            g.drawLine(x_prev, y1, x1 + width, y1);
                            g.drawLine(x1 + width, y1, x1 + width, y2);
                            if (j == bins.size() - 1 || dimension.getBinStartValue(bins.get(j + 1)) != binEndValue) {
                                g.drawLine(x1 + width, y2, x1, y2);
                                x_prev = x1;
                            } else {
                                x_prev = x1 + width;
                            }
                        }
                        g.setColor(((ColorTheme)AbstractDistributionsComponent.this.view.getColorTheme().getValue()).getVisiblePalette().getColor(1.0));
                        g.drawLine(active_x_prev, y1, x1 + activeWidth, y1);
                        g.drawLine(x1 + activeWidth, y1, x1 + activeWidth, y2);
                        if (!it.hasNext() || dimension.getBinStartValue(bins.get(j + 1)) != binEndValue) {
                            g.drawLine(x1 + activeWidth, y2, x1, y2);
                            active_x_prev = x1;
                        } else {
                            active_x_prev = x1 + activeWidth;
                        }
                        if (activeCountAtBin > 0.0) {
                            int r = 0;
                            while ((double)r < activeCountAtBin) {
                                ++r;
                            }
                        }
                    }
                    ++j;
                }
            }
        }
    }
}

