/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.high_d.distributions;

import com.macrofocus.crossplatform.CPCanvas;
import com.macrofocus.high_d.distributions.DistributionsController;
import com.macrofocus.high_d.distributions.DistributionsView;
import com.macrofocus.high_d.interaction.InteractionMode;
import com.macrofocus.molap.subset.DistributionDimension;
import java.util.AbstractMap;

public class AbstractDistributionsController<Component, Color, Row, Column, Value, Bin>
implements DistributionsController<Component, Color, Row, Column, Value, Bin> {
    private DistributionsView<Component, Color, Row, Column, Value, Bin> view;
    private final DefaultMouseListener mouseListener = new DefaultMouseListener();

    @Override
    public void setView(DistributionsView<Component, Color, Row, Column, Value, Bin> view) {
        if (this.view != null) {
            this.view.removeMouseListener(this.mouseListener);
            this.view.removeMouseMotionListener(this.mouseListener);
        }
        this.view = view;
        if (view != null) {
            view.addMouseListener(this.mouseListener);
            view.addMouseMotionListener(this.mouseListener);
        }
    }

    public void select(CPCanvas.MouseEvent e, boolean continuous) {
        DistributionDimension<Row, Value, Bin> dimension = this.view.getClosestDistribution(e.getX(), e.getY());
        Bin bin = this.view.getClosestBin(e.getX(), e.getY());
        if (bin != null) {
            boolean active;
            boolean bl = active = dimension.getActiveDensity(bin) > 0.0;
            if (active) {
                InteractionMode interactionMode = (InteractionMode)this.view.getInteractionMode().getValue();
                if (e.isAltKeyDown()) {
                    switch (interactionMode) {
                        case Selection: {
                            interactionMode = InteractionMode.Filter;
                            break;
                        }
                        case Toggle: {
                            interactionMode = InteractionMode.Filter;
                            break;
                        }
                        case Filter: {
                            InteractionMode interactionMode2 = interactionMode = dimension.getSelection() != null ? InteractionMode.Selection : InteractionMode.Toggle;
                        }
                    }
                }
                if (interactionMode == InteractionMode.Selection) {
                    if (dimension.getSelection() != null) {
                        if (e.isMenuShortcutKeyDown()) {
                            dimension.getSelection().setSelectedIterableState(dimension.getRows(bin), true);
                        } else {
                            dimension.getSelection().setSelectedIterable(dimension.getRows(bin));
                        }
                    }
                } else if (!continuous && dimension.getFilterExact().isSelected(bin) && dimension.getFilterExact().getSelectedCount() == 1) {
                    dimension.filterAll();
                } else if (interactionMode == InteractionMode.Filter && !e.isMenuShortcutKeyDown() || interactionMode == InteractionMode.Toggle && e.isMenuShortcutKeyDown()) {
                    dimension.filterExact(new Object[]{bin});
                } else {
                    boolean allSelected;
                    boolean bl2 = allSelected = !dimension.getFilterExact().isActive();
                    if (allSelected) {
                        if (interactionMode == InteractionMode.Filter) {
                            dimension.getFilterExact().setSelectedIterable((Iterable)dimension.getActiveBins());
                            dimension.getFilterExact().setSelectedState(bin, false);
                        } else {
                            dimension.filterExact(new Object[]{bin});
                        }
                    } else {
                        boolean currentlySelected = dimension.getFilterExact().isSelected(bin);
                        dimension.getFilterExact().setSelectedState(bin, !currentlySelected);
                    }
                }
            }
        }
    }

    public void probe(CPCanvas.MouseEvent e, boolean continuous) {
        DistributionDimension<Row, Value, Bin> dimension = this.view.getClosestDistribution(e.getX(), e.getY());
        Bin bin = this.view.getClosestBin(e.getX(), e.getY());
        if (dimension != null && bin != null) {
            this.view.getProbing().setSelected(new AbstractMap.SimpleImmutableEntry<DistributionDimension<Row, Value, Bin>, Bin>(dimension, bin));
        } else {
            this.view.getProbing().clearSelection();
        }
    }

    public class DefaultMouseListener
    implements CPCanvas.MouseListener,
    CPCanvas.MouseMotionListener {
        public void mouseClicked(CPCanvas.MouseEvent event) {
        }

        public void mousePressed(CPCanvas.MouseEvent event) {
            AbstractDistributionsController.this.select(event, false);
        }

        public void mouseReleased(CPCanvas.MouseEvent event) {
        }

        public void mouseEntered(CPCanvas.MouseEvent event) {
            AbstractDistributionsController.this.probe(event, true);
        }

        public void mouseExited(CPCanvas.MouseEvent event) {
        }

        public void mouseDragged(CPCanvas.MouseEvent event) {
            AbstractDistributionsController.this.probe(event, true);
            AbstractDistributionsController.this.select(event, true);
        }

        public void mouseMoved(CPCanvas.MouseEvent event) {
            AbstractDistributionsController.this.probe(event, true);
        }
    }
}

