/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.high_d.mds.pca;

public class PCAMatrix {
    private double[][] A;
    private int m;
    private int n;

    public PCAMatrix(int m, int n) {
        this.m = m;
        this.n = n;
        this.A = new double[m][n];
    }

    public PCAMatrix(int m, int n, double s) {
        this.m = m;
        this.n = n;
        this.A = new double[m][n];
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                this.A[i][j] = s;
            }
        }
    }

    public PCAMatrix(double[][] A) {
        this.m = A.length;
        this.n = A[0].length;
        for (int i = 0; i < this.m; ++i) {
            if (A[i].length == this.n) continue;
            throw new IllegalArgumentException("All rows must have the same length.");
        }
        this.A = A;
    }

    public PCAMatrix(double[][] A, int m, int n) {
        this.A = A;
        this.m = m;
        this.n = n;
    }

    public PCAMatrix(double[] vals, int m) {
        this.m = m;
        int n = this.n = m != 0 ? vals.length / m : 0;
        if (m * this.n != vals.length) {
            throw new IllegalArgumentException("Array length must be a multiple of m.");
        }
        this.A = new double[m][this.n];
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < this.n; ++j) {
                this.A[i][j] = vals[i + j * m];
            }
        }
    }

    public static PCAMatrix identity(int m, int n) {
        PCAMatrix A = new PCAMatrix(m, n);
        double[][] X = A.getArray();
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                X[i][j] = i == j ? 1.0 : 0.0;
            }
        }
        return A;
    }

    public double[][] getArray() {
        return this.A;
    }

    public static PCAMatrix random(int m, int n) {
        PCAMatrix A = new PCAMatrix(m, n);
        double[][] X = A.getArray();
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                X[i][j] = Math.random();
            }
        }
        return A;
    }

    public static double hypot(double a, double b) {
        double r;
        if (Math.abs(a) > Math.abs(b)) {
            r = b / a;
            r = Math.abs(a) * Math.sqrt(1.0 + r * r);
        } else if (b != 0.0) {
            r = a / b;
            r = Math.abs(b) * Math.sqrt(1.0 + r * r);
        } else {
            r = 0.0;
        }
        return r;
    }

    public PCAMatrix copy() {
        PCAMatrix X = new PCAMatrix(this.m, this.n);
        double[][] C = X.getArray();
        for (int i = 0; i < this.m; ++i) {
            for (int j = 0; j < this.n; ++j) {
                C[i][j] = this.A[i][j];
            }
        }
        return X;
    }

    public double[][] getArrayCopy() {
        double[][] C = new double[this.m][this.n];
        for (int i = 0; i < this.m; ++i) {
            for (int j = 0; j < this.n; ++j) {
                C[i][j] = this.A[i][j];
            }
        }
        return C;
    }

    public int getRowDimension() {
        return this.m;
    }

    public int getColumnDimension() {
        return this.n;
    }

    public double get(int i, int j) {
        return this.A[i][j];
    }

    public void set(int i, int j, double s) {
        this.A[i][j] = s;
    }

    public PCAMatrix times(double s) {
        PCAMatrix X = new PCAMatrix(this.m, this.n);
        double[][] C = X.getArray();
        for (int i = 0; i < this.m; ++i) {
            for (int j = 0; j < this.n; ++j) {
                C[i][j] = s * this.A[i][j];
            }
        }
        return X;
    }

    public PCAMatrix minus(PCAMatrix B) {
        PCAMatrix X = new PCAMatrix(this.m, this.n);
        double[][] C = X.getArray();
        for (int i = 0; i < this.m; ++i) {
            for (int j = 0; j < this.n; ++j) {
                C[i][j] = this.A[i][j] - B.A[i][j];
            }
        }
        return X;
    }

    public PCAMatrix times(PCAMatrix B) {
        if (B.m != this.n) {
            throw new IllegalArgumentException("Matrix inner dimensions must agree.");
        }
        PCAMatrix X = new PCAMatrix(this.m, B.n);
        double[][] C = X.getArray();
        double[] Bcolj = new double[this.n];
        for (int j = 0; j < B.n; ++j) {
            for (int k = 0; k < this.n; ++k) {
                Bcolj[k] = B.A[k][j];
            }
            for (int i = 0; i < this.m; ++i) {
                double[] Arowi = this.A[i];
                double s = 0.0;
                for (int k = 0; k < this.n; ++k) {
                    s += Arowi[k] * Bcolj[k];
                }
                C[i][j] = s;
            }
        }
        return X;
    }

    public double trace() {
        double t = 0.0;
        for (int i = 0; i < Math.min(this.m, this.n); ++i) {
            t += this.A[i][i];
        }
        return t;
    }

    public PCAMatrix transpose() {
        PCAMatrix X = new PCAMatrix(this.n, this.m);
        double[][] C = X.getArray();
        for (int i = 0; i < this.m; ++i) {
            for (int j = 0; j < this.n; ++j) {
                C[j][i] = this.A[i][j];
            }
        }
        return X;
    }
}

