/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.high_d.mds.spring;

import com.macrofocus.high_d.mds.MDSEngineEvent;
import com.macrofocus.high_d.mds.MDSModel;
import com.macrofocus.high_d.mds.spring.SpringMDSEngine;
import com.macrofocus.high_d.mds.spring.SpringModel;
import com.macrofocus.molap.dataframe.matrix.Matrix;
import com.macrofocus.timer.CPExecutor;
import java.util.Random;

public final class FastNeighbouringSamplingSpringMDSEngine
extends SpringMDSEngine {
    private Matrix dist;
    private SpringModel spring;
    private int length;
    private double layoutBounds = 100.0;
    private boolean groundForceOn = true;
    private double groundSpringConstant = 0.3;
    private double groundDampingConstant = 1.0;
    private double springConstant = 0.6;
    private double dampingConstant = 0.5;
    private double objectMass = 1.0;
    private double deltaTime = 0.1;
    private double deltaTimeSquare = Math.pow(this.deltaTime, 2.0);
    private int numSamples = 10;
    private int numNeighbours = 5;
    private int randomizeSampleEvery = 1;
    private int[][] samples;
    private int[][] neighbours;
    private Random rand;

    public FastNeighbouringSamplingSpringMDSEngine(CPExecutor executor) {
        super(executor);
    }

    public FastNeighbouringSamplingSpringMDSEngine(SpringModel spring, Matrix dist, int length, CPExecutor executor) {
        this(executor);
        this.setParameters(spring, dist, length);
    }

    @Override
    public MDSModel getModel() {
        return this.spring;
    }

    @Override
    protected Matrix getDistanceTable() {
        return this.dist;
    }

    @Override
    public void setParameters(SpringModel spring, Matrix dist, int length) {
        this.spring = spring;
        this.dist = dist;
        this.rand = new Random(123L);
        this.setLength(length);
    }

    public void setLength(int length) {
        this.length = length;
    }

    @Override
    public CPExecutor.Command createRunCommand() {
        return new CPExecutor.Command(){
            int progress = -1;

            public boolean execute() {
                if (this.progress < 0) {
                    int i;
                    for (i = 0; i < FastNeighbouringSamplingSpringMDSEngine.this.spring.getRowCount() && !FastNeighbouringSamplingSpringMDSEngine.this.isInterrupted(); ++i) {
                        if (FastNeighbouringSamplingSpringMDSEngine.this.dist.isAvailable((Object)i, (Object)i)) {
                            double radius = FastNeighbouringSamplingSpringMDSEngine.this.rand.nextDouble() * FastNeighbouringSamplingSpringMDSEngine.this.layoutBounds * 0.5;
                            double azimuth = FastNeighbouringSamplingSpringMDSEngine.this.rand.nextDouble() * 360.0;
                            double elevation = FastNeighbouringSamplingSpringMDSEngine.this.rand.nextDouble() * 180.0 - 90.0;
                            double phi = azimuth / 180.0 * Math.PI;
                            double theta = elevation / 180.0 * Math.PI;
                            double x = radius * Math.cos(theta) * Math.cos(phi);
                            double y = radius * Math.cos(theta) * Math.sin(phi);
                            double z = radius * Math.sin(theta);
                            FastNeighbouringSamplingSpringMDSEngine.this.spring.setPosition(i, x, y, z);
                            FastNeighbouringSamplingSpringMDSEngine.this.spring.setVelocity(i, 0.0, 0.0, 0.0);
                            FastNeighbouringSamplingSpringMDSEngine.this.spring.setForce(i, 0.0, 0.0, 0.0);
                            continue;
                        }
                        FastNeighbouringSamplingSpringMDSEngine.this.spring.setPosition(i, Double.NaN, Double.NaN, Double.NaN);
                    }
                    FastNeighbouringSamplingSpringMDSEngine.this.samples = new int[FastNeighbouringSamplingSpringMDSEngine.this.spring.getRowCount()][FastNeighbouringSamplingSpringMDSEngine.this.numSamples];
                    FastNeighbouringSamplingSpringMDSEngine.this.neighbours = new int[FastNeighbouringSamplingSpringMDSEngine.this.spring.getRowCount()][FastNeighbouringSamplingSpringMDSEngine.this.numNeighbours];
                    for (i = 0; i < FastNeighbouringSamplingSpringMDSEngine.this.spring.getRowCount() && !FastNeighbouringSamplingSpringMDSEngine.this.isInterrupted(); ++i) {
                        for (int j = 0; j < FastNeighbouringSamplingSpringMDSEngine.this.numNeighbours; ++j) {
                            FastNeighbouringSamplingSpringMDSEngine.this.neighbours[i][j] = -1;
                        }
                    }
                    for (i = 0; i < FastNeighbouringSamplingSpringMDSEngine.this.dist.getRowCount() && !FastNeighbouringSamplingSpringMDSEngine.this.isInterrupted(); ++i) {
                        if (!FastNeighbouringSamplingSpringMDSEngine.this.spring.isAvailable(i)) continue;
                        block4: for (int j = 0; j < FastNeighbouringSamplingSpringMDSEngine.this.dist.getColumnCount(); ++j) {
                            if (i == j || !FastNeighbouringSamplingSpringMDSEngine.this.spring.isAvailable(j)) continue;
                            double d = FastNeighbouringSamplingSpringMDSEngine.this.dist.getDouble((Object)i, (Object)j);
                            for (int k = 0; k < FastNeighbouringSamplingSpringMDSEngine.this.numNeighbours; ++k) {
                                if (FastNeighbouringSamplingSpringMDSEngine.this.neighbours[i][k] != -1 && !(d < FastNeighbouringSamplingSpringMDSEngine.this.dist.getDouble((Object)i, (Object)FastNeighbouringSamplingSpringMDSEngine.this.neighbours[i][k]))) continue;
                                FastNeighbouringSamplingSpringMDSEngine.this.neighbours[i][k] = j;
                                continue block4;
                            }
                        }
                    }
                }
                ++this.progress;
                if (this.progress < FastNeighbouringSamplingSpringMDSEngine.this.length && !FastNeighbouringSamplingSpringMDSEngine.this.isInterrupted()) {
                    int base;
                    for (base = 0; base < FastNeighbouringSamplingSpringMDSEngine.this.spring.getRowCount(); ++base) {
                        if (!FastNeighbouringSamplingSpringMDSEngine.this.spring.isAvailable(base)) continue;
                        if (this.progress == 0 || FastNeighbouringSamplingSpringMDSEngine.this.randomizeSampleEvery > 0 && FastNeighbouringSamplingSpringMDSEngine.this.randomizeSampleEvery % this.progress == 0) {
                            FastNeighbouringSamplingSpringMDSEngine.this.randomizeSample(base);
                        }
                        FastNeighbouringSamplingSpringMDSEngine.this.calculateForces(base);
                    }
                    for (base = 0; base < FastNeighbouringSamplingSpringMDSEngine.this.spring.getRowCount(); ++base) {
                        if (!FastNeighbouringSamplingSpringMDSEngine.this.spring.isAvailable(base)) continue;
                        FastNeighbouringSamplingSpringMDSEngine.this.updateChanges(base);
                    }
                    FastNeighbouringSamplingSpringMDSEngine.this.notifyEngineIterated(new MDSEngineEvent(FastNeighbouringSamplingSpringMDSEngine.this, this.progress));
                    ++this.progress;
                    return true;
                }
                FastNeighbouringSamplingSpringMDSEngine.this.notifyEngineFinished(new MDSEngineEvent(FastNeighbouringSamplingSpringMDSEngine.this, FastNeighbouringSamplingSpringMDSEngine.this.length));
                return false;
            }
        };
    }

    private void randomizeSample(int base) {
        for (int j = 0; j < this.numSamples; ++j) {
            int random;
            while ((random = this.rand.nextInt(this.spring.getRowCount())) == base || !this.spring.isAvailable(random)) {
            }
            this.samples[base][j] = random;
        }
    }

    private void calculateForces(int base) {
        int current;
        int k;
        this.spring.setForce(base, 0.0, 0.0, 0.0);
        for (k = 0; k < this.numSamples; ++k) {
            current = this.samples[base][k];
            if (current == -1 || base == current) continue;
            this.addForces(base, current);
        }
        for (k = 0; k < this.numNeighbours; ++k) {
            current = this.neighbours[base][k];
            if (base == current) continue;
            this.addForces(base, current);
        }
        if (this.groundForceOn) {
            this.computeGroundForce(base);
        }
    }

    private void computeGroundForce(int base) {
        double ground = -(this.spring.getZ(base) * this.groundSpringConstant) - this.spring.getVelocityZ(base) * this.groundDampingConstant;
        this.spring.setForceZ(base, ground);
    }

    private void addForces(int base, int current) {
        if (this.dist.isAvailable((Object)base, (Object)current)) {
            double vx = this.spring.getX(current) - this.spring.getX(base);
            double vy = this.spring.getY(current) - this.spring.getY(base);
            double vz = this.spring.getZ(current) - this.spring.getZ(base);
            double actual = Math.sqrt(vx * vx + vy * vy + vz * vz);
            double desired = this.dist.getDouble((Object)base, (Object)current);
            if (desired <= 0.0) {
                System.err.println("Identical entry  " + base + " and " + current + ": " + desired);
                return;
            }
            if (Double.isNaN(desired)) {
                System.err.println("Unknown distance comparing " + base + " and " + current);
                return;
            }
            if (actual > 0.0) {
                vx /= actual;
                vy /= actual;
                vz /= actual;
            } else {
                vx = 0.0;
                vy = 0.0;
                vz = 0.0;
            }
            double factor = this.springConstant * (actual - desired) / (double)(this.numNeighbours + this.numSamples);
            this.spring.addForce(base, vx *= factor, vy *= factor, vz *= factor);
            this.spring.addForce(current, -vx, -vy, -vz);
        }
    }

    private void updateChanges(int base) {
        double vx = this.spring.getVelocityX(base);
        double vy = this.spring.getVelocityY(base);
        double vz = this.spring.getVelocityZ(base);
        double ax = (this.spring.getForceX(base) - this.dampingConstant * vx) / this.objectMass;
        double ay = (this.spring.getForceY(base) - this.dampingConstant * vy) / this.objectMass;
        double az = (this.spring.getForceZ(base) - this.dampingConstant * vz) / this.objectMass;
        this.spring.setPosition(base, this.spring.getX(base) + (vx * this.deltaTime + 0.5 * ax * this.deltaTimeSquare), this.spring.getY(base) + (vy * this.deltaTime + 0.5 * ay * this.deltaTimeSquare), this.spring.getZ(base) + (vz * this.deltaTime + 0.5 * az * this.deltaTimeSquare));
        this.spring.setVelocity(base, vx + ax * this.deltaTime, vy + ay * this.deltaTime, vz + az * this.deltaTime);
    }

    public void setGroundDampingConstant(double groundDampingConstant) {
        this.groundDampingConstant = groundDampingConstant;
    }

    public void setDampingConstant(double dampingConstant) {
        this.dampingConstant = dampingConstant;
    }

    public void setDeltaTime(double deltaTime) {
        this.deltaTime = deltaTime;
        this.deltaTimeSquare = Math.pow(deltaTime, 2.0);
    }

    public void setGroundForceOn(boolean groundForceOn) {
        this.groundForceOn = groundForceOn;
    }

    public void setGroundSpringConstant(double groundSpringConstant) {
        this.groundSpringConstant = groundSpringConstant;
    }

    public void setLayoutBounds(double layoutBounds) {
        this.layoutBounds = layoutBounds;
    }

    public void setNumNeighbours(int numNeighbours) {
        this.numNeighbours = numNeighbours;
    }

    public void setNumSamples(int numSamples) {
        this.numSamples = numSamples;
    }

    public void setObjectMass(double objectMass) {
        this.objectMass = objectMass;
    }

    public void setSpringConstant(double springConstant) {
        this.springConstant = springConstant;
    }

    public void setRandomizeSampleEvery(int randomizeSampleEvery) {
        this.randomizeSampleEvery = randomizeSampleEvery;
    }
}

