/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.high_d.table.swing;

import com.macrofocus.common.properties.MutableProperty;
import com.macrofocus.common.properties.PropertiesListener;
import com.macrofocus.common.properties.PropertyEvent;
import com.macrofocus.common.selection.SelectionEvent;
import com.macrofocus.common.selection.SelectionListener;
import com.macrofocus.crossplatform.CPComponent;
import com.macrofocus.crossplatform.swing.AbstractSwingComponent;
import com.macrofocus.crossplatform.swing.SwingFactory;
import com.macrofocus.filter.FilterEvent;
import com.macrofocus.filter.FilterListener;
import com.macrofocus.format.CPFormat;
import com.macrofocus.helper.ColorHelper;
import com.macrofocus.helper.SwingHelper;
import com.macrofocus.high_d.axis.AxisListener;
import com.macrofocus.high_d.axis.AxisModel;
import com.macrofocus.high_d.axis.group.AxisGroupModel;
import com.macrofocus.high_d.table.AbstractTable;
import com.macrofocus.high_d.table.ShowFilteredDataFrame;
import com.macrofocus.high_d.table.Table;
import com.macrofocus.high_d.table.swing.DataFrameTableModel;
import com.macrofocus.high_d.table.swing.TableColumnAdjuster;
import com.macrofocus.igraphics.CPColorFactory;
import com.macrofocus.igraphics.colortheme.ColorTheme;
import com.macrofocus.molap.aggregates.cube.UnivariateStatistics;
import com.macrofocus.molap.dataframe.DataFrame;
import com.macrofocus.molap.dataframe.SortOrder;
import com.macrofocus.visual.Visual;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.text.Format;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.RowSorter;
import javax.swing.event.MouseInputAdapter;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

public class SwingTable<R, C, V>
extends AbstractTable<JComponent, Color, Format, R, C, V> {
    private final JScrollPane scrollPane;
    private RollOverTable table;
    private Visual<Color, R, C> visual;
    private AxisGroupModel<R, C> axisGroupModel;
    private final Color selectionColor = new Color(255, 0, 0);
    private final Color probingAndSelectionColor = new Color(255, 100, 0);
    private ShowFilteredDataFrame<R, C, V> dataFrame;
    private Map<C, TableCellRenderer> renderers = new HashMap<C, TableCellRenderer>();
    private R anchor;
    final PropertiesListener propertiesListener = new PropertiesListener(){

        public void propertyChanged(Object name, PropertyEvent event) {
            if (name == Table.PropertyType.ShowFiltered) {
                if (SwingTable.this.dataFrame != null) {
                    SwingTable.this.dataFrame.getShowFiltered().setValue((Object)((Boolean)SwingTable.this.getShowFiltered().getValue()));
                }
            } else if (name == Table.PropertyType.ColorTheme) {
                SwingTable.this.scrollPane.repaint();
            }
            if (SwingTable.this.table != null) {
                SwingTable.this.table.repaint();
            }
        }
    };
    private final SelectionListener<R> probingListener = new SelectionListener<R>(){

        public void selectionChanged(SelectionEvent<R> event) {
            Rectangle rectangle = null;
            for (Object r : event.getAffected()) {
                int rowAddress = SwingTable.this.dataFrame.getRowAddress(r);
                if (rowAddress < 0) continue;
                Rectangle firstCellRect = SwingTable.this.table.getCellRect(SwingTable.this.table.convertRowIndexToView(rowAddress), 0, true);
                Rectangle lastCellRect = SwingTable.this.table.getCellRect(SwingTable.this.table.convertRowIndexToView(rowAddress), SwingTable.this.table.getColumnCount() - 1, true);
                Rectangle rowBounds = firstCellRect.union(lastCellRect);
                if (rectangle == null) {
                    rectangle = rowBounds;
                    continue;
                }
                rectangle = rectangle.union(rowBounds);
            }
            if (rectangle != null) {
                SwingTable.this.table.repaint(rectangle);
            }
        }
    };
    private final SelectionListener<R> selectionListener = new SelectionListener<R>(){

        public void selectionChanged(SelectionEvent<R> event) {
            int rowAddress;
            Object selected = null;
            for (Object r : event.getAffected()) {
                if (!event.getModel().isSelected(r)) continue;
                selected = r;
                break;
            }
            if (selected != null && (rowAddress = SwingTable.this.dataFrame.getRowAddress(selected)) >= 0) {
                if (SwingTable.this.anchor == null || !SwingTable.this.visual.getSelection().isSelected(SwingTable.this.anchor)) {
                    SwingTable.this.anchor = selected;
                }
                Rectangle cellRect = SwingTable.this.table.getCellRect(SwingTable.this.table.convertRowIndexToView(rowAddress), 0, true);
                SwingTable.this.table.scrollRectToVisible(cellRect);
            }
            SwingTable.this.table.repaint();
        }
    };
    private final FilterListener<R> filterListener = new FilterListener<R>(){

        public void filterChanged(FilterEvent<R> event) {
            if (((Boolean)SwingTable.this.getShowFiltered().getValue()).booleanValue()) {
                SwingTable.this.table.repaint();
            }
        }
    };
    private final AxisListener axisListener = new AxisListener(){

        public void axisChanged() {
            SwingTable.this.table.repaint();
        }
    };

    public SwingTable() {
        super((CPColorFactory)SwingFactory.getInstance());
        this.scrollPane = new JScrollPane();
        this.scrollPane.setVerticalScrollBarPolicy(22);
        this.properties.addPropertiesListener(this.propertiesListener);
    }

    public SwingTable(DataFrame<R, C, V> dataFrame, Visual<Color, R, C> visual) {
        this(dataFrame, dataFrame, visual);
    }

    public SwingTable(DataFrame<R, C, V> filteredDataFrame, DataFrame<R, C, V> completeDataFrame, Visual<Color, R, C> visual) {
        this();
        this.setModel(new ShowFilteredDataFrame(filteredDataFrame, completeDataFrame, this.getShowFiltered()), visual, null);
    }

    public DataFrame<R, C, V> getSortedDataFrame() {
        System.err.println("getSortedDataFrame() not fully implemented");
        return this.dataFrame;
    }

    public void setStyleClass(String ... styleClasses) {
        AbstractSwingComponent.setStyleClass((CPComponent)this, (String[])styleClasses);
    }

    public void setModel(ShowFilteredDataFrame<R, C, V> dataFrame, Visual<Color, R, C> visual, AxisGroupModel<R, C> axisGroupModel) {
        if (this.dataFrame != dataFrame || this.visual != visual) {
            if (this.visual != null) {
                this.visual.getProbing().removeSelectionListener(this.probingListener);
                this.visual.getSelection().removeSelectionListener(this.selectionListener);
                this.visual.getFilter().removeFilterListener(this.filterListener);
            }
            if (this.axisGroupModel != null) {
                this.axisGroupModel.removeAxisListener(this.axisListener);
            }
            this.dataFrame = dataFrame;
            this.visual = visual;
            this.axisGroupModel = axisGroupModel;
            if (this.dataFrame != null) {
                this.dataFrame.setShowFiltered(this.getShowFiltered());
            }
            if (this.visual != null) {
                this.visual.getProbing().addWeakSelectionListener(this.probingListener);
                this.visual.getSelection().addWeakSelectionListener(this.selectionListener);
                this.visual.getFilter().addWeakFilterListener(this.filterListener);
            }
            if (this.axisGroupModel != null) {
                this.axisGroupModel.addAxisListener(this.axisListener);
            }
            this.table = new RollOverTable(new DataFrameTableModel<R, C, V>(dataFrame));
            this.table.setAutoCreateRowSorter(true);
            this.table.setAutoResizeMode(0);
            this.table.setAutoscrolls(true);
            this.table.setShowHorizontalLines(false);
            this.table.setShowVerticalLines(false);
            this.table.setSelectionBackground(this.selectionColor);
            this.table.setIntercellSpacing(new Dimension(0, 0));
            for (Object c : dataFrame.columns()) {
                this.setFormat(c, null);
            }
            this.table.setCellSelectionEnabled(false);
            this.table.setSelectionMode(0);
            this.scrollPane.setViewportView(this.table);
        }
    }

    public JScrollPane getNativeComponent() {
        return this.scrollPane;
    }

    public void adjustColumns(boolean columnHeaderIncluded, boolean dynamicAdjustment) {
        TableColumnAdjuster tableColumnAdjuster = new TableColumnAdjuster(this.table);
        tableColumnAdjuster.setColumnHeaderIncluded(columnHeaderIncluded);
        tableColumnAdjuster.setDynamicAdjustment(dynamicAdjustment);
        tableColumnAdjuster.adjustColumns();
    }

    public void setColumnVisible(C column, boolean visible) {
        throw new UnsupportedOperationException();
    }

    public void setHidable(C column, boolean hidable) {
        throw new UnsupportedOperationException();
    }

    public void setSortKey(C column, SortOrder order) {
        if (column != null) {
            this.table.getRowSorter().setSortKeys(Arrays.asList(new RowSorter.SortKey(this.dataFrame.getColumnAddress(column), order == SortOrder.DESCENDING ? javax.swing.SortOrder.DESCENDING : javax.swing.SortOrder.ASCENDING)));
        } else {
            this.table.getRowSorter().setSortKeys(Collections.EMPTY_LIST);
        }
    }

    public void setFormat(C column, CPFormat format) {
        this.renderers.put(column, new FormattedRenderer<C>(format, this.dataFrame.getCompleteDataFrame(), column));
        this.table.repaint();
    }

    public void setLabel(C column, String label) {
        System.err.println(((Object)((Object)this)).getClass().getSimpleName() + ".setLabel(C column, String label) not yet implemented");
    }

    public void setFrozenColumnCount(int columnCount) {
        System.err.println(((Object)((Object)this)).getClass().getSimpleName() + ".setFrozenColumnCount() not yet implemented");
    }

    public void reset() {
        System.err.println(((Object)((Object)this)).getClass().getSimpleName() + ".reset() not yet implemented");
    }

    public void setShowFiltered(MutableProperty<Boolean> showFiltered) {
        this.properties.replaceProperty((Object)Table.PropertyType.ShowFiltered, showFiltered);
    }

    public void setColumnResizePolicy(Table.ColumnResizePolicy policy) {
        System.err.println(((Object)((Object)this)).getClass().getSimpleName() + ".setColumnResizePolicy() not yet implemented");
    }

    public void setCellRenderer(C column, Table.CellRenderer<JComponent, R, C, V> renderer) {
        System.err.println(((Object)((Object)this)).getClass().getSimpleName() + ".setCellRenderer() not yet implemented");
    }

    public void setDetailsFactory(boolean alwaysVisible, Table.DetailsFactory<JComponent, R> factory) {
        System.err.println(((Object)((Object)this)).getClass().getSimpleName() + ".setDetailsFactory() not yet implemented");
    }

    public JTable getJTable() {
        return this.table;
    }

    public class RollOverTable
    extends JTable {
        public RollOverTable(TableModel model) {
            super(model);
            RollOverListener lst = new RollOverListener();
            this.addMouseMotionListener(lst);
            this.addMouseListener(lst);
        }

        @Override
        public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
            JComponent c = (JComponent)super.prepareRenderer(renderer, row, column);
            Object columnKey = SwingTable.this.dataFrame.getColumnKey(this.convertColumnIndexToModel(column));
            if (SwingTable.this.renderers.containsKey(columnKey)) {
                TableCellRenderer r2 = SwingTable.this.renderers.get(columnKey);
                Object value = this.getValueAt(row, column);
                boolean isSelected = false;
                boolean hasFocus = false;
                if (!this.isPaintingForPrint()) {
                    isSelected = this.isCellSelected(row, column);
                    boolean rowIsLead = this.selectionModel.getLeadSelectionIndex() == row;
                    boolean colIsLead = this.columnModel.getSelectionModel().getLeadSelectionIndex() == column;
                    hasFocus = rowIsLead && colIsLead && this.isFocusOwner();
                }
                JComponent c2 = (JComponent)r2.getTableCellRendererComponent(this, value, isSelected, hasFocus, row, column);
                c2.setName("Table.cellRenderer");
                c2.setBorder(c.getBorder());
                c2.setOpaque(c.isOpaque());
                c2.setBackground(c.getBackground());
                c2.setForeground(c.getForeground());
                if (c2 instanceof JLabel) {
                    ((JLabel)c2).setText(((JLabel)c2).getText());
                }
                Object key = SwingTable.this.dataFrame.getRowKey(this.convertRowIndexToModel(row));
                if (SwingTable.this.visual != null) {
                    if (SwingTable.this.visual.getProbing().isSelected(key)) {
                        if (SwingTable.this.visual.getSelection().isSelected(key)) {
                            c2.setForeground(this.getSelectionForeground());
                            c2.setBackground(SwingTable.this.probingAndSelectionColor);
                        } else {
                            c2.setForeground(this.getSelectionForeground());
                            c2.setBackground((Color)((ColorTheme)SwingTable.this.getColorTheme().getValue()).getProbing().getNativeColor());
                        }
                    } else if (SwingTable.this.visual.getSelection().isSelected(key)) {
                        c2.setForeground(this.getSelectionForeground());
                        c2.setBackground((Color)((ColorTheme)SwingTable.this.getColorTheme().getValue()).getSelection().getNativeColor());
                    } else {
                        if (((Boolean)SwingTable.this.getShowFiltered().getValue()).booleanValue() && SwingTable.this.visual.getFilter().isFiltered(key)) {
                            c2.setForeground(Color.gray);
                        } else {
                            c2.setForeground(this.getForeground());
                        }
                        Color background = SwingTable.this.getStyle().getValue() == Table.Style.Alternate && row % 2 == 1 ? (ColorHelper.lum((Color)this.getBackground()) > ColorHelper.lum((Color)Color.gray) ? ColorHelper.darker((Color)this.getBackground(), (double)0.93) : ColorHelper.brighter((Color)this.getBackground(), (double)0.93)) : this.getBackground();
                        c2.setBackground(background);
                    }
                } else {
                    Color background = SwingTable.this.getStyle().getValue() == Table.Style.Alternate && row % 2 == 1 ? (ColorHelper.lum((Color)this.getBackground()) > ColorHelper.lum((Color)Color.gray) ? ColorHelper.darker((Color)this.getBackground(), (double)0.93) : ColorHelper.brighter((Color)this.getBackground(), (double)0.93)) : this.getBackground();
                    c2.setBackground(background);
                }
                return c2;
            }
            return c;
        }

        private class RollOverListener
        extends MouseInputAdapter {
            private RollOverListener() {
            }

            @Override
            public void mouseExited(MouseEvent e) {
                SwingTable.this.visual.getProbing().clearSelection();
                RollOverTable.this.repaint();
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                int rowIndex = RollOverTable.this.rowAtPoint(e.getPoint());
                if (rowIndex >= 0) {
                    Object row = SwingTable.this.dataFrame.getRowKey(RollOverTable.this.convertRowIndexToModel(rowIndex));
                    if (!SwingTable.this.visual.getFilter().isFiltered(row)) {
                        SwingTable.this.visual.getProbing().setSelected(row);
                    } else {
                        SwingTable.this.visual.getProbing().clearSelection();
                    }
                } else {
                    SwingTable.this.visual.getProbing().clearSelection();
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                int rowIndex = RollOverTable.this.rowAtPoint(e.getPoint());
                if (rowIndex >= 0) {
                    Object row = SwingTable.this.dataFrame.getRowKey(RollOverTable.this.convertRowIndexToModel(rowIndex));
                    if (!SwingTable.this.visual.getFilter().isFiltered(row)) {
                        if (!SwingHelper.isMultipleSelectionKey((InputEvent)e)) {
                            if (e.isShiftDown() && SwingTable.this.anchor != null && row != null) {
                                int anchorAddress = SwingTable.this.dataFrame.getRowAddress(SwingTable.this.anchor);
                                int rowAddress = SwingTable.this.dataFrame.getRowAddress(row);
                                if (anchorAddress >= 0 && rowAddress >= 0) {
                                    int rowView = SwingTable.this.table.convertRowIndexToView(rowAddress);
                                    int anchorView = SwingTable.this.table.convertRowIndexToView(anchorAddress);
                                    int min = Math.min(rowView, anchorView);
                                    int max = Math.max(rowView, anchorView);
                                    ArrayList<Object> rowsToSelect = new ArrayList<Object>();
                                    for (int r = min; r <= max; ++r) {
                                        int x = SwingTable.this.table.convertRowIndexToModel(r);
                                        rowsToSelect.add(SwingTable.this.dataFrame.getRowKey(x));
                                    }
                                    SwingTable.this.visual.getSelection().setSelectedIterable(rowsToSelect);
                                }
                            } else {
                                SwingTable.this.visual.getProbing().setSelected(row);
                                SwingTable.this.visual.getSelection().setSelected(row);
                                SwingTable.this.setSelectionMode(SwingTable.this.visual.getSelection().isSelected(row));
                            }
                        } else {
                            SwingTable.this.setSelectionMode(!SwingTable.this.visual.getSelection().isSelected(row));
                            SwingTable.this.visual.getProbing().setSelected(row);
                            SwingTable.this.visual.getSelection().setSelectedElementsState(SwingTable.this.isSelectionMode(), new Object[]{row});
                        }
                    } else {
                        SwingTable.this.visual.getProbing().clearSelection();
                        SwingTable.this.visual.getSelection().clearSelection();
                    }
                } else {
                    SwingTable.this.visual.getProbing().clearSelection();
                    SwingTable.this.visual.getSelection().clearSelection();
                }
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                int rowIndex = RollOverTable.this.rowAtPoint(e.getPoint());
                if (rowIndex >= 0) {
                    Object row = SwingTable.this.dataFrame.getRowKey(RollOverTable.this.convertRowIndexToModel(rowIndex));
                    if (!SwingTable.this.visual.getFilter().isFiltered(row)) {
                        if (!SwingHelper.isMultipleSelectionKey((InputEvent)e)) {
                            if (e.isShiftDown() && SwingTable.this.anchor != null && row != null) {
                                int anchorAddress = SwingTable.this.dataFrame.getRowAddress(SwingTable.this.anchor);
                                int rowAddress = SwingTable.this.dataFrame.getRowAddress(row);
                                if (anchorAddress >= 0 && rowAddress >= 0) {
                                    int rowView = SwingTable.this.table.convertRowIndexToView(rowAddress);
                                    int anchorView = SwingTable.this.table.convertRowIndexToView(anchorAddress);
                                    int min = Math.min(rowView, anchorView);
                                    int max = Math.max(rowView, anchorView);
                                    ArrayList<Object> rowsToSelect = new ArrayList<Object>();
                                    for (int r = min; r <= max; ++r) {
                                        int x = SwingTable.this.table.convertRowIndexToModel(r);
                                        rowsToSelect.add(SwingTable.this.dataFrame.getRowKey(x));
                                    }
                                    SwingTable.this.visual.getSelection().setSelectedIterable(rowsToSelect);
                                }
                            } else {
                                SwingTable.this.visual.getProbing().setSelected(row);
                                SwingTable.this.visual.getSelection().setSelected(row);
                            }
                        } else {
                            SwingTable.this.visual.getProbing().setSelected(row);
                            SwingTable.this.visual.getSelection().setSelectedElementsState(SwingTable.this.isSelectionMode(), new Object[]{row});
                        }
                    } else {
                        SwingTable.this.visual.getProbing().clearSelection();
                        SwingTable.this.visual.getSelection().clearSelection();
                    }
                } else {
                    SwingTable.this.visual.getProbing().clearSelection();
                    SwingTable.this.visual.getSelection().clearSelection();
                }
            }
        }
    }

    public class FormattedRenderer<C>
    extends JLabel
    implements TableCellRenderer {
        private final double INSET_LEFT = 0.0;
        private final double INSET_RIGHT = 4.0;
        private final double INSET_TOP = 2.5;
        private final double INSET_BOTTOM = 1.5;
        private CPFormat format;
        private DataFrame<R, C, ?> dataFrame;
        private C column;
        private Object value;

        public FormattedRenderer(CPFormat format, DataFrame<R, C, ?> dataFrame, C column) {
            this.dataFrame = dataFrame;
            this.column = column;
            this.format = format;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            FormattedRenderer c = this;
            this.value = value;
            JLabel label = c;
            label.setBorder(BorderFactory.createEmptyBorder());
            if (value == null || value instanceof Number) {
                this.setHorizontalAlignment(4);
            } else {
                this.setHorizontalAlignment(2);
            }
            this.setFont(table.getFont());
            if (this.format != null) {
                this.setText(this.format.formatHtml(value, true));
            } else if (value != null && value instanceof Number) {
                this.setText(NumberFormat.getInstance().format(value));
            } else {
                this.setText(value != null ? value.toString() : "");
            }
            return c;
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            Graphics2D g2 = (Graphics2D)g;
            if (((Boolean)SwingTable.this.getShowDistribution().getValue()).booleanValue() && this.value != null && this.value instanceof Number) {
                double max;
                double min;
                double v = ((Number)this.value).doubleValue();
                if (SwingTable.this.axisGroupModel != null) {
                    AxisModel axisModel = SwingTable.this.axisGroupModel.getAxisModel(this.dataFrame.getColumnName(this.column));
                    if (axisModel != null) {
                        min = axisModel.getMinimum();
                        max = axisModel.getMaximum();
                    } else {
                        min = 0.0;
                        max = 0.0;
                    }
                } else {
                    UnivariateStatistics statistics = this.dataFrame.getStatistics(this.column);
                    min = 0.0;
                    max = statistics.getMaximum().doubleValue() - min;
                }
                if (min != max) {
                    g.setColor(new Color(127, 127, 127, 63));
                    double width = (int)(((double)this.getWidth() - 0.0 - 4.0) * (v - min) / (max - min));
                    Rectangle2D.Double shape = new Rectangle2D.Double(0.0, 2.5, width, (double)this.getHeight() - 2.5 - 1.5);
                    g2.fill(shape);
                    g2.draw(shape);
                }
            }
            if (SwingTable.this.getStyle().getValue() == Table.Style.Border) {
                g.setColor(new Color(127, 127, 127, 32));
                double y = (double)this.getHeight() - 1.5;
                g2.draw(new Line2D.Double(0.0, y, this.getWidth(), y));
            }
        }

        protected void setValue(Object value) {
            this.setText(value == null ? "" : value.toString());
        }
    }
}

